/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.rnai;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.broad.igv.data.rnai.RNAIHairpinValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RNAIHairpinCache {
    private static RNAIHairpinCache theInstance = new RNAIHairpinCache();
    Map<String, Map<String, Collection<RNAIHairpinValue>>> hairpinScores = new HashMap<String, Map<String, Collection<RNAIHairpinValue>>>();

    private RNAIHairpinCache() {
    }

    public static RNAIHairpinCache getInstance() {
        return theInstance;
    }

    public void addHairpinScore(String batchId, String geneName, RNAIHairpinValue score) {
        Collection<RNAIHairpinValue> scoresForGene;
        Map<String, Collection<RNAIHairpinValue>> scoresForBatch = this.hairpinScores.get(batchId);
        if (scoresForBatch == null) {
            scoresForBatch = new HashMap<String, Collection<RNAIHairpinValue>>();
            this.hairpinScores.put(batchId, scoresForBatch);
        }
        if ((scoresForGene = scoresForBatch.get(geneName)) == null) {
            scoresForGene = new TreeSet<RNAIHairpinValue>(new RNAIHairpinNameComparator());
            scoresForBatch.put(geneName, scoresForGene);
        }
        scoresForGene.add(score);
    }

    public Collection<RNAIHairpinValue> getHairpinScores(String batchId, String geneName) {
        Map<String, Collection<RNAIHairpinValue>> scoresForBatch = this.hairpinScores.get(batchId);
        if (scoresForBatch == null) {
            return null;
        }
        return scoresForBatch.get(geneName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RNAIHairpinNameComparator
    implements Comparator<RNAIHairpinValue> {
        private RNAIHairpinNameComparator() {
        }

        @Override
        public int compare(RNAIHairpinValue hp1, RNAIHairpinValue hp2) {
            if (hp1.getName().length() < hp2.getName().length()) {
                return -1;
            }
            return hp1.getName().compareTo(hp2.getName());
        }
    }
}

