/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestData {
    private static Logger logger = Logger.getLogger(TestData.class);
    private static String genomeId = "hg18";

    public static void main(String[] args) {
        TestData.generateIGVTestFiles(new File("/Users/jrobinso/IGVTestData"));
    }

    public static void generateAllTestFiles(File fileLocation) {
        TestData.generateCNTestFiles(fileLocation);
        TestData.generateGctTestFiles(fileLocation);
    }

    public static void generateIGVTestFiles(File cnFileLocation) {
        int numberOfSamples = 100;
        int fileLength = 10000;
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        ArrayList<String> chromosomeList = new ArrayList<String>(genome.getChromosomeNames());
        TestData.generateIGVTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
    }

    public static void generateCNTestFiles(File cnFileLocation) {
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        ArrayList<String> chromosomeList = new ArrayList<String>(genome.getChromosomeNames());
        for (int numberOfSamples : new int[]{10, 100, 1000}) {
            int fileLength = 1;
            TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        }
        for (int fileLength : new int[]{10, 100, 1000, 10000, 100000, 500000}) {
            int numberOfSamples = 1;
            TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        }
        for (int nSamples : new int[]{10, 100}) {
            for (int fileLength : new int[]{1000, 10000}) {
                int numberOfSamples = 10;
                TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
            }
        }
        int numberOfSamples = 1;
        int fileLength = 25000;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        numberOfSamples = 100;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        numberOfSamples = 300;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        fileLength = 250000;
        numberOfSamples = 300;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
        fileLength = 500000;
        numberOfSamples = 300;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
    }

    public static void generateVeryLargeCNTestFile(File cnFileLocation) {
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        ArrayList<String> chromosomeList = new ArrayList<String>(genome.getChromosomeNames());
        int numberOfSamples = 96;
        int fileLength = 1800000;
        TestData.generateCNTestFile(genome, chromosomeList, cnFileLocation, fileLength, numberOfSamples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateCNTestFile(Genome genome, List<String> chromosomeList, File outputLocation, int fileLength, int numberOfSamples) {
        if (fileLength < chromosomeList.size()) {
            fileLength = chromosomeList.size();
        }
        int snpIdentifier = 0;
        int chunks = fileLength / chromosomeList.size();
        if (chunks < 1) {
            chunks = 1;
        }
        int divisor = chunks - 1;
        float lowestSampleValue = 0.0f;
        float highestSampleValue = lowestSampleValue + 4.0f;
        float sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)chromosomeList.size();
        GeneManager geneManager = GeneManager.getGeneManager(genome.getId());
        geneManager.sortGeneLists();
        TestData.sortChromosomeList(chromosomeList);
        if (divisor > 0) {
            sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)divisor;
        }
        File file = new File(outputLocation, "igv_cn_" + fileLength + "_" + numberOfSamples + ".cn");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            StringBuffer record = new StringBuffer();
            record.append("SNP");
            record.append("\t");
            record.append("Chromosome");
            record.append("\t");
            record.append("PhysicalPosition");
            for (int i2 = 0; i2 < numberOfSamples; ++i2) {
                record.append("\t");
                record.append("Value");
                record.append(i2 + 1);
            }
            record.append("\n");
            writer.write(record.toString());
            record.delete(0, record.length());
            float sampleValue = lowestSampleValue;
            for (String chromosomeName : chromosomeList) {
                Chromosome chromosome = genome.getChromosome(chromosomeName);
                float chromosomeChunkIncrement = chromosome.getLength();
                if (divisor > 0) {
                    chromosomeChunkIncrement = chromosome.getLength() / divisor;
                }
                chromosomeName = chromosome.getName();
                chromosomeName = chromosomeName.substring(3, chromosomeName.length());
                for (float i3 = 0.0f; i3 < (float)chunks; i3 += 1.0f) {
                    long chunkStart = (int)Math.floor(i3 * chromosomeChunkIncrement);
                    record.append("SNP_");
                    record.append(++snpIdentifier);
                    record.append("\t");
                    record.append(chromosomeName);
                    record.append("\t");
                    record.append(chunkStart);
                    for (int j2 = 0; j2 < numberOfSamples; ++j2) {
                        record.append("\t");
                        record.append(sampleValue);
                    }
                    writer.println(record.toString());
                    record.delete(0, record.length());
                    sampleValue += sampleValueIncrement;
                }
                if (divisor <= 0) continue;
                sampleValue = lowestSampleValue;
            }
            writer.close();
            writer = null;
        }
        catch (Exception e2) {
            logger.error("Could not write test files", e2);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateIGVTestFile(Genome genome, List<String> chromosomeList, File outputLocation, int fileLength, int numberOfSamples) {
        if (fileLength < chromosomeList.size()) {
            fileLength = chromosomeList.size();
        }
        int snpIdentifier = 0;
        int chunks = fileLength / chromosomeList.size();
        if (chunks < 1) {
            chunks = 1;
        }
        int divisor = chunks - 1;
        float lowestSampleValue = 0.0f;
        float highestSampleValue = lowestSampleValue + 4.0f;
        float sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)chromosomeList.size();
        GeneManager geneManager = GeneManager.getGeneManager(genome.getId());
        geneManager.sortGeneLists();
        TestData.sortChromosomeList(chromosomeList);
        if (divisor > 0) {
            sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)divisor;
        }
        File file = new File(outputLocation, "igv_" + fileLength + "_" + numberOfSamples + ".igv");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            StringBuffer record = new StringBuffer();
            writer.println("#comment 1");
            writer.println("#comment 2");
            record.append("Chromosome\tStart\tEnd\tName");
            for (int i2 = 0; i2 < numberOfSamples; ++i2) {
                record.append("\t");
                record.append("Value");
                record.append(i2 + 1);
            }
            record.append("\n");
            writer.write(record.toString());
            record.delete(0, record.length());
            float sampleValue = lowestSampleValue;
            for (String chromosomeName : chromosomeList) {
                Chromosome chromosome = genome.getChromosome(chromosomeName);
                float chromosomeChunkIncrement = chromosome.getLength();
                if (divisor > 0) {
                    chromosomeChunkIncrement = chromosome.getLength() / divisor;
                }
                chromosomeName = chromosome.getName();
                chromosomeName = chromosomeName.substring(3, chromosomeName.length());
                for (float i3 = 0.0f; i3 < (float)chunks; i3 += 1.0f) {
                    long chunkStart = (int)Math.floor(i3 * chromosomeChunkIncrement);
                    record.append(chromosomeName);
                    record.append("\t");
                    record.append(chunkStart);
                    record.append("\t");
                    record.append(chunkStart + 1000L);
                    record.append("\t");
                    record.append("Probe_");
                    record.append(++snpIdentifier);
                    for (int j2 = 0; j2 < numberOfSamples; ++j2) {
                        record.append("\t");
                        record.append(sampleValue);
                    }
                    writer.println(record.toString());
                    record.delete(0, record.length());
                    sampleValue += sampleValueIncrement;
                }
                if (divisor <= 0) continue;
                sampleValue = lowestSampleValue;
            }
            writer.close();
            writer = null;
        }
        catch (Exception e2) {
            logger.error("Could not write test files", e2);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    public static void generateGctTestFiles(File outputLocation) {
        Genome genome = GenomeManager.getInstance().getGenome(genomeId);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genomeId);
        }
        ArrayList<String> chromosomeList = new ArrayList<String>(genome.getChromosomeNames());
        TestData.generateGctGeneTestFile(genome, chromosomeList, outputLocation);
        TestData.generateGctChromosomeTestFile(genome, chromosomeList, outputLocation);
    }

    public static void generateGctTestFiles(Genome genome, List<String> chromosomeList, File outputLocation) {
        TestData.generateGctGeneTestFile(genome, chromosomeList, outputLocation);
        TestData.generateGctChromosomeTestFile(genome, chromosomeList, outputLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateGctGeneTestFile(Genome genome, List<String> chromosomeList, File outputLocation) {
        float lowestSampleValue = -1.5f;
        float highestSampleValue = lowestSampleValue + 3.0f;
        GeneManager geneManager = GeneManager.getGeneManager(genome.getId());
        geneManager.sortGeneLists();
        TestData.sortChromosomeList(chromosomeList);
        int divisor = chromosomeList.size() - 1;
        float sampleValueIncrement = 0.0f;
        if (divisor > 0) {
            sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)divisor;
        }
        File file = new File(outputLocation, "igv_genes.gct");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            int lengthOfFile = TestData.countTotalGenes(genome.getId(), chromosomeList);
            int numberOfSamples = 1;
            StringBuffer record = new StringBuffer();
            record.append("#1.2");
            record.append("\n");
            record.append(lengthOfFile);
            record.append("\t");
            record.append(numberOfSamples);
            record.append("\n");
            record.append("NAME");
            record.append("\t");
            record.append("DESCRIPTION");
            record.append("\t");
            record.append("SAMPLE");
            record.append("\n");
            writer.write(record.toString());
            record.delete(0, record.length());
            float sampleValue = lowestSampleValue;
            for (String chromosome : chromosomeList) {
                List<Feature> genes = geneManager.getGenesForChromosome(chromosome);
                for (Feature gene : genes) {
                    record.append(gene.getName());
                    record.append("\t");
                    record.append("|@");
                    record.append(chromosome);
                    record.append(":");
                    record.append(gene.getStart());
                    record.append("-");
                    record.append(gene.getEnd());
                    record.append("|");
                    record.append("\t");
                    record.append(sampleValue);
                    writer.println(record.toString());
                    record.delete(0, record.length());
                }
                sampleValue += sampleValueIncrement;
            }
            writer.close();
            writer = null;
        }
        catch (Exception e2) {
            logger.error("Could not write test files", e2);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateGctChromosomeTestFile(Genome genome, List<String> chromosomeList, File outputLocation) {
        int chunks = 100;
        int divisor = chunks - 1;
        if (chunks < 1) {
            chunks = 1;
        }
        float lowestSampleValue = -1.5f;
        float highestSampleValue = lowestSampleValue + 3.0f;
        float sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)chromosomeList.size();
        GeneManager geneManager = GeneManager.getGeneManager(genome.getId());
        geneManager.sortGeneLists();
        TestData.sortChromosomeList(chromosomeList);
        if (divisor > 0) {
            sampleValueIncrement = (highestSampleValue - lowestSampleValue) / (float)divisor;
        }
        File file = new File(outputLocation, "igv_chromosome.gct");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            int lengthOfFile = chromosomeList.size() * chunks;
            int numberOfSamples = 1;
            StringBuffer record = new StringBuffer();
            record.append("#1.2");
            record.append("\n");
            record.append(lengthOfFile);
            record.append("\t");
            record.append(numberOfSamples);
            record.append("\n");
            record.append("NAME");
            record.append("\t");
            record.append("DESCRIPTION");
            record.append("\t");
            record.append("SAMPLE");
            record.append("\n");
            writer.write(record.toString());
            record.delete(0, record.length());
            float sampleValue = lowestSampleValue;
            for (String chromosomeName : chromosomeList) {
                Chromosome chromosome = genome.getChromosome(chromosomeName);
                float chromosomeChunkIncrement = chromosome.getLength();
                if (divisor > 0) {
                    chromosomeChunkIncrement = chromosome.getLength() / divisor;
                }
                for (float i2 = 0.0f; i2 < (float)chunks; i2 += 1.0f) {
                    long chunkStart = (int)Math.floor(i2 * chromosomeChunkIncrement);
                    long chunkEnd = (int)Math.ceil((float)chunkStart + chromosomeChunkIncrement - 1.0f);
                    record.append("Probe_" + i2);
                    record.append("\t");
                    record.append("|@");
                    record.append(chromosome.getName());
                    record.append(":");
                    record.append(chunkStart);
                    record.append("-");
                    record.append(chunkEnd);
                    record.append("|");
                    record.append("\t");
                    record.append(sampleValue);
                    writer.println(record.toString());
                    record.delete(0, record.length());
                    sampleValue += sampleValueIncrement;
                }
                if (divisor <= 0) continue;
                sampleValue = lowestSampleValue;
            }
            writer.close();
            writer = null;
        }
        catch (Exception e2) {
            logger.error("Could not write test files", e2);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    public static int countTotalGenes(String genome, List<String> chromosomeList) {
        int totalGenes = 0;
        GeneManager geneManager = GeneManager.getGeneManager(genome);
        for (String chromosome : chromosomeList) {
            List<Feature> genes = geneManager.getGenesForChromosome(chromosome);
            for (Feature gene : genes) {
                ++totalGenes;
            }
        }
        return totalGenes;
    }

    private static void sortChromosomeList(List<String> chromosomeList) {
        Collections.sort(chromosomeList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String name1 = (String)arg0;
                String name2 = (String)arg1;
                if (name1.startsWith("chr") && name2.startsWith("chr")) {
                    try {
                        name1 = name1.substring(3).trim();
                        name2 = name2.substring(3).trim();
                        Integer integer1 = Integer.parseInt(name1);
                        Integer integer2 = Integer.parseInt(name2);
                        int returnValue = integer1.compareTo(integer2);
                        return returnValue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0;
                    }
                }
                throw new RuntimeException("Found an invalid chromosome name: " + name1 + " or " + name2);
            }
        });
    }
}

