/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.RuntimeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMRecordSetBuilder
implements Iterable<SAMRecord> {
    private static final String[] chroms = new String[]{"chrM", "chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY"};
    private static final byte[] BASES = new byte[]{65, 67, 71, 84};
    private static final String READ_GROUP_ID = "1";
    private static final String SAMPLE = "FREE_SAMPLE";
    private final Random random = new Random();
    private SAMFileHeader header;
    private Collection<SAMRecord> records;
    private int readLength = 36;
    private SAMProgramRecord programRecord = null;
    private SAMReadGroupRecord readGroup = null;

    public SAMRecordSetBuilder() {
        this(true, SAMFileHeader.SortOrder.coordinate);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder) {
        this(sortForMe, sortOrder, true);
    }

    public SAMRecordSetBuilder(boolean sortForMe, SAMFileHeader.SortOrder sortOrder, boolean addReadGroup) {
        ArrayList<SAMSequenceRecord> sequences = new ArrayList<SAMSequenceRecord>();
        for (String chrom : chroms) {
            SAMSequenceRecord sequenceRecord = new SAMSequenceRecord(chrom, 1000000);
            sequences.add(sequenceRecord);
        }
        this.header = new SAMFileHeader();
        this.header.setSequenceDictionary(new SAMSequenceDictionary(sequences));
        this.header.setSortOrder(sortOrder);
        if (sortForMe) {
            SAMRecordComparator comparator = sortOrder == SAMFileHeader.SortOrder.queryname ? new SAMRecordQueryNameComparator() : new SAMRecordCoordinateComparator();
            this.records = new TreeSet<SAMRecord>(comparator);
        } else {
            this.records = new ArrayList<SAMRecord>();
        }
        if (addReadGroup) {
            SAMReadGroupRecord readGroupRecord = new SAMReadGroupRecord(READ_GROUP_ID);
            readGroupRecord.setSample(SAMPLE);
            ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
            readGroups.add(readGroupRecord);
            this.header.setReadGroups(readGroups);
        }
    }

    public void setProgramRecord(SAMProgramRecord programRecord) {
        this.programRecord = programRecord;
        if (programRecord != null) {
            this.header.addProgramRecord(programRecord);
        }
    }

    public void setReadGroup(SAMReadGroupRecord readGroup) {
        this.readGroup = readGroup;
        if (readGroup != null) {
            this.header.addReadGroup(readGroup);
        }
    }

    public Collection<SAMRecord> getRecords() {
        return this.records;
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return new CloseableIterator<SAMRecord>(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = SAMRecordSetBuilder.this.records.iterator();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public void addFrag(String name, int contig, int start, boolean negativeStrand) {
        SAMRecord rec = new SAMRecord(this.header);
        rec.setReadName(name);
        rec.setReferenceIndex(contig);
        rec.setReferenceName(chroms[contig]);
        rec.setAlignmentStart(start);
        rec.setReadNegativeStrandFlag(negativeStrand);
        rec.setCigarString(this.readLength + "M");
        rec.setMappingQuality(255);
        rec.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            rec.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            rec.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(rec);
        this.records.add(rec);
    }

    public void addUnmappedFragment(String name) {
        SAMRecord rec = new SAMRecord(this.header);
        rec.setReadName(name);
        rec.setReadUnmappedFlag(true);
        rec.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            rec.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        if (this.readGroup != null) {
            rec.setAttribute(SAMTag.RG.name(), (Object)this.readGroup.getReadGroupId());
        }
        this.fillInBasesAndQualities(rec);
        this.records.add(rec);
    }

    public void addPair(String name, int contig, int start1, int start2) {
        SAMRecord end1 = new SAMRecord(this.header);
        SAMRecord end2 = new SAMRecord(this.header);
        boolean end1IsFirstOfPair = this.random.nextBoolean();
        end1.setReadName(name);
        end1.setReferenceIndex(contig);
        end1.setAlignmentStart(start1);
        end1.setReadNegativeStrandFlag(false);
        end1.setCigarString(this.readLength + "M");
        end1.setMappingQuality(255);
        end1.setReadPairedFlag(true);
        end1.setProperPairFlag(true);
        end1.setMateReferenceIndex(contig);
        end1.setMateAlignmentStart(start2);
        end1.setMateNegativeStrandFlag(true);
        end1.setFirstOfPairFlag(end1IsFirstOfPair);
        end1.setSecondOfPairFlag(!end1IsFirstOfPair);
        end1.setInferredInsertSize(CoordMath.getLength(start1, CoordMath.getEnd(start2, this.readLength)));
        end1.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end1.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(end1);
        end2.setReadName(name);
        end2.setReferenceIndex(contig);
        end2.setAlignmentStart(start2);
        end2.setReadNegativeStrandFlag(true);
        end2.setCigarString(this.readLength + "M");
        end2.setMappingQuality(255);
        end2.setReadPairedFlag(true);
        end2.setProperPairFlag(true);
        end2.setMateReferenceIndex(contig);
        end2.setMateAlignmentStart(start1);
        end2.setMateNegativeStrandFlag(false);
        end2.setFirstOfPairFlag(!end1IsFirstOfPair);
        end2.setSecondOfPairFlag(end1IsFirstOfPair);
        end2.setInferredInsertSize(end1.getInferredInsertSize());
        end2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(end2);
        this.records.add(end1);
        this.records.add(end2);
    }

    public void addUnmappedPair(String name) {
        SAMRecord end1 = new SAMRecord(this.header);
        SAMRecord end2 = new SAMRecord(this.header);
        boolean end1IsFirstOfPair = this.random.nextBoolean();
        end1.setReadName(name);
        end1.setReadPairedFlag(false);
        end1.setReadUnmappedFlag(true);
        end1.setProperPairFlag(false);
        end1.setFirstOfPairFlag(end1IsFirstOfPair);
        end1.setSecondOfPairFlag(!end1IsFirstOfPair);
        end1.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end1.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(end1);
        end2.setReadName(name);
        end2.setReadPairedFlag(false);
        end2.setReadUnmappedFlag(true);
        end2.setProperPairFlag(false);
        end2.setFirstOfPairFlag(!end1IsFirstOfPair);
        end2.setSecondOfPairFlag(end1IsFirstOfPair);
        end2.setAttribute(SAMTag.RG.name(), (Object)READ_GROUP_ID);
        if (this.programRecord != null) {
            end2.setAttribute(SAMTag.PG.name(), (Object)this.programRecord.getProgramGroupId());
        }
        this.fillInBasesAndQualities(end2);
        this.records.add(end1);
        this.records.add(end2);
    }

    private void fillInBasesAndQualities(SAMRecord rec) {
        int length = this.readLength;
        byte[] bases = new byte[length];
        byte[] quals = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bases[i2] = BASES[this.random.nextInt(BASES.length)];
            quals[i2] = (byte)this.random.nextInt(50);
        }
        rec.setReadBases(bases);
        rec.setBaseQualities(quals);
    }

    public SAMFileReader getSamReader() {
        File tempFile;
        try {
            tempFile = File.createTempFile("temp", ".sam");
        }
        catch (IOException e2) {
            throw new RuntimeIOException("problems creating tempfile", e2);
        }
        this.header.setAttribute("VN", "1.0");
        SAMFileWriter w = new SAMFileWriterFactory().makeBAMWriter(this.header, true, tempFile);
        for (SAMRecord r : this.getRecords()) {
            w.addAlignment(r);
        }
        w.close();
        SAMFileReader reader = new SAMFileReader(tempFile);
        tempFile.deleteOnExit();
        return reader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }
}

