/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.sequence;

import edu.mit.broad.prodinfo.sequence.Sequence;
import edu.mit.broad.prodinfo.sequence.SequenceRegion;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSlider
implements Iterator<SequenceRegion> {
    private int windowSize;
    private int overlap;
    private int atPosition = 0;
    private int seqStart;
    private Sequence seq;

    public static WindowSlider getSlider(Sequence seq, int windowSize, int overlap) {
        WindowSlider ws = new WindowSlider(windowSize, overlap);
        ws.seq = seq;
        ws.seqStart = 0;
        return ws;
    }

    public static WindowSlider getSlider(SequenceRegion seq, int windowSize, int overlap) {
        WindowSlider ws = new WindowSlider(windowSize, overlap);
        ws.seq = seq;
        ws.atPosition = seq.getStart();
        ws.seqStart = seq.getStart();
        return ws;
    }

    WindowSlider(int windowSize, int overlap) {
        this.windowSize = windowSize;
        this.overlap = overlap;
    }

    @Override
    public boolean hasNext() {
        return this.atPosition < this.seq.getEnd() - this.windowSize;
    }

    @Override
    public SequenceRegion next() {
        SequenceRegion window = this.seq.getRegion(this.atPosition - this.seqStart, this.atPosition - this.seqStart + this.windowSize);
        window.setStart(this.atPosition);
        window.setEnd(this.atPosition + this.windowSize);
        this.atPosition = this.atPosition + this.windowSize - this.overlap;
        return window;
    }

    @Override
    public void remove() {
    }
}

