/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.prodinfo.multiplealignment;

import edu.mit.broad.prodinfo.chromosome.BasicGenomicAnnotation;
import edu.mit.broad.prodinfo.datastrutures.IntervalTree;
import edu.mit.broad.prodinfo.genomicplot.GenomicAnnotation;
import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAFAlignment
extends MultipleAlignment {
    private IntervalTree<MAFMultipleAlignmentBlock> alignmentBlockTree;
    private List<String> sequenceIds;
    MAFHeader header = new MAFHeader();
    IntervalTree<Long> index;
    private String referenceChromosome;

    public MAFAlignment() {
        this.alignmentBlockTree = new IntervalTree();
        this.sequenceIds = new ArrayList<String>();
    }

    public MAFAlignment(String indexFile) throws IOException, ParseException {
        this();
        this.loadIndex(indexFile);
    }

    public MAFHeader getHeader() {
        return this.header;
    }

    @Override
    public void encode() {
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> alnBlockIt = this.alignmentBlockTree.iterator();
        while (alnBlockIt.hasNext()) {
            IntervalTree.Node<MAFMultipleAlignmentBlock> blockNode = alnBlockIt.next();
            blockNode.getValue().encode();
        }
    }

    @Override
    public void encodeAsMatrix() {
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> alnBlockIt = this.alignmentBlockTree.iterator();
        while (alnBlockIt.hasNext()) {
            IntervalTree.Node<MAFMultipleAlignmentBlock> blockNode = alnBlockIt.next();
            blockNode.getValue().encodeAsMatrix();
        }
    }

    @Override
    public void reverse() {
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> alnBlockIt = this.alignmentBlockTree.iterator();
        while (alnBlockIt.hasNext()) {
            IntervalTree.Node<MAFMultipleAlignmentBlock> blockNode = alnBlockIt.next();
            blockNode.getValue().reverse();
        }
    }

    @Override
    public int length() {
        int length = 0;
        if (this.alignmentBlockTree.size() > 0) {
            MAFMultipleAlignmentBlock first = this.alignmentBlockTree.min().getValue();
            MAFMultipleAlignmentBlock last = this.alignmentBlockTree.max().getValue();
            length = last.getReferenceEnd() - first.getReferenceStart();
        }
        return length;
    }

    @Override
    public Map<String, Short> getColumn(int i2) {
        Map<String, Short> col = this.getGapColumn();
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> overlappingNodeIt = this.alignmentBlockTree.overlappers(i2, i2 + 1);
        if (overlappingNodeIt.hasNext()) {
            MAFMultipleAlignmentBlock containingBlock = overlappingNodeIt.next().getValue();
            Map<String, Short> closestCol = containingBlock.getColumn(i2);
            for (String seqId : closestCol.keySet()) {
                col.put(seqId, closestCol.get(seqId));
            }
        }
        return col;
    }

    @Override
    public void addShortEncodedColumn(Map<String, Short> col) {
        throw new RuntimeException("Not yet implemented, to edit an alignment use a base MultipleAlignment MAF are ReadOnly");
    }

    @Override
    public void addShortEncodedRegion(Map<String, short[]> region) {
        throw new RuntimeException("Not yet implemented, to edit an alignment use a base MultipleAlignment MAF are ReadOnly");
    }

    @Override
    public void addSequence(MultipleAlignment.AlignedSequence seq) {
        throw new RuntimeException("Not yet implemented, to edit an alignment use a base MultipleAlignment MAF are ReadOnly");
    }

    @Override
    public void addSequences(List<MultipleAlignment.AlignedSequence> sequences) {
        throw new RuntimeException("Not yet implemented, to edit an alignment use a base MultipleAlignment MAF are ReadOnly");
    }

    @Override
    public boolean isEmpty() {
        return this.alignmentBlockTree.isEmpty();
    }

    @Override
    public void write(BufferedWriter bw) throws IOException {
        if (this.getIOHelper() != null) {
            super.write(bw);
        } else {
            this.header.addVariableValuePair("ref", this.getReferenceId());
            this.header.write(bw);
            Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> blockIt = this.alignmentBlockTree.iterator();
            while (blockIt.hasNext()) {
                blockIt.next().getValue().write(bw);
            }
        }
    }

    @Override
    public MAFAlignment getSubAlignment(int refStart, int refEnd, boolean reverse) {
        MAFAlignment subAln = new MAFAlignment();
        subAln.setReferenceId(this.getReferenceId());
        subAln.sequenceIds = this.sequenceIds;
        IntervalTree.ValuesIterator overlapperIt = new IntervalTree.ValuesIterator(this.alignmentBlockTree.overlappers(refStart, refEnd));
        BasicGenomicAnnotation target = new BasicGenomicAnnotation(this.getReference());
        target.setStart(refStart);
        target.setEnd(refEnd);
        while (overlapperIt.hasNext()) {
            MAFMultipleAlignmentBlock overlappingBlock = (MAFMultipleAlignmentBlock)overlapperIt.next();
            subAln.addBlock(overlappingBlock.trim(target));
        }
        return subAln;
    }

    public MultipleAlignment.AlignedSequence getAlignedSequence(String sequenceId, boolean fillInGapsBetweenBlocks) {
        if (!this.sequenceIds.contains(sequenceId) || this.alignmentBlockTree.isEmpty()) {
            return null;
        }
        MultipleAlignment.AlignedSequence seq = new MultipleAlignment.AlignedSequence(sequenceId);
        seq.setId(sequenceId);
        if (this.getReferenceId().equals(sequenceId)) {
            seq.setStart(this.alignmentBlockTree.min().getValue().getReferenceStart());
            seq.setChromosome(this.alignmentBlockTree.min().getValue().getAlignedSequence(sequenceId).getChromosome());
            seq.setEnd(this.alignmentBlockTree.max().getValue().getReferenceEnd());
        }
        IntervalTree.ValuesIterator it = new IntervalTree.ValuesIterator(this.alignmentBlockTree.iterator());
        MultipleAlignment lastBlock = null;
        while (it.hasNext()) {
            MAFMultipleAlignmentBlock block = (MAFMultipleAlignmentBlock)it.next();
            MultipleAlignment.AlignedSequence segment = block.getAlignedSequence(sequenceId);
            if (lastBlock != null && lastBlock.getReferenceEnd() < block.getReferenceStart() && fillInGapsBetweenBlocks) {
                for (int i2 = 0; i2 < block.getReferenceStart() - lastBlock.getReferenceEnd(); ++i2) {
                    seq.appendToSequence('N');
                }
            }
            seq.appendToSequence(segment.getSequenceBases());
            lastBlock = block;
        }
        return seq;
    }

    @Override
    public MultipleAlignment.AlignedSequence getAlignedSequence(String sequenceId) {
        return this.getAlignedSequence(sequenceId, true);
    }

    public List<MultipleAlignment.AlignedSequence> getAlignedSequences(boolean fillGapsBetweenBlocks) {
        ArrayList<MultipleAlignment.AlignedSequence> sequences = new ArrayList<MultipleAlignment.AlignedSequence>(this.sequenceIds.size());
        for (String id : this.sequenceIds) {
            sequences.add(this.getAlignedSequence(id, fillGapsBetweenBlocks));
        }
        return sequences;
    }

    @Override
    public List<MultipleAlignment.AlignedSequence> getAlignedSequences() {
        return this.getAlignedSequences(true);
    }

    public boolean overlaps(GenomicAnnotation annotation) {
        return this.index.overlappers(annotation.getStart(), annotation.getEnd()).hasNext();
    }

    public boolean contains(GenomicAnnotation annotation) {
        return this.index.min().getStart() < annotation.getStart() && this.index.max().getEnd() > annotation.getEnd();
    }

    @Override
    public List<String> getAlignedSequenceIds() {
        return this.sequenceIds;
    }

    @Override
    public int getReferenceStart() {
        IntervalTree.Node<MAFMultipleAlignmentBlock> first = this.alignmentBlockTree.min();
        return first == null ? -1 : first.getValue().getReferenceStart();
    }

    @Override
    public int getReferenceEnd() {
        IntervalTree.Node<MAFMultipleAlignmentBlock> last = this.alignmentBlockTree.max();
        return last == null ? -1 : last.getValue().getReferenceEnd();
    }

    @Override
    public void compress() {
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> nodeIt = this.alignmentBlockTree.iterator();
        while (nodeIt.hasNext()) {
            nodeIt.next().getValue().compress();
        }
    }

    public MultipleAlignment toMultipleAlignment(boolean fillGapsBetweenBlocks) {
        MultipleAlignment ma = new MultipleAlignment();
        ma.setReferenceId(this.getReferenceId());
        ma.setRefGapped(true);
        ma.addSequences(this.getAlignedSequences(fillGapsBetweenBlocks));
        ma.getReference().setStart(this.getReferenceStart());
        ma.getReference().setEnd(this.getReferenceEnd());
        return ma;
    }

    public MultipleAlignment toMultipleAlignment() {
        return this.toMultipleAlignment(true);
    }

    @Override
    public MultipleAlignment sampleColumns(int colNum, int numConsecutiveCols) {
        Random r = new Random();
        int treeSize = this.alignmentBlockTree.size();
        MultipleAlignment sampledAlignment = new MultipleAlignment();
        sampledAlignment.setReferenceId(this.getReferenceId());
        int i2 = 0;
        while (i2 < colNum - numConsecutiveCols + 1) {
            int blockId = r.nextInt(treeSize);
            System.out.println("randomly selected block " + blockId + " out of " + treeSize + " blocks");
            MAFMultipleAlignmentBlock block = this.alignmentBlockTree.findByIndex(blockId).getValue();
            MultipleAlignment sampledCols = block.sampleColumns(1, numConsecutiveCols);
            for (String seqId : this.getAlignedSequenceIds()) {
                if (sampledCols.getAlignedSequence(seqId) != null) continue;
                MultipleAlignment.AlignedSequence missingSeq = new MultipleAlignment.AlignedSequence(seqId);
                for (int j2 = 0; j2 < numConsecutiveCols; ++j2) {
                    missingSeq.appendToSequence('-');
                }
                sampledCols.addSequence(missingSeq);
            }
            sampledAlignment.append(sampledCols);
            i2 = numConsecutiveCols + i2;
        }
        return sampledAlignment;
    }

    public void load(String fileName) throws IOException, ParseException {
        this.load(fileName, 0, 1000000000);
    }

    public void load(RandomAccessFile handle, List<String> sequencesToLoad) throws IOException, ParseException {
        this.load(handle, 1, 1000000000, sequencesToLoad);
    }

    public void load(RandomAccessFile handle, int referenceStart, int referenceEnd) throws IOException, ParseException {
        this.load(handle, referenceStart, referenceEnd, new ArrayList<String>());
    }

    public void load(RandomAccessFile handle, int referenceStart, int referenceEnd, List<String> sequencesToLoad) throws IOException, ParseException {
        MAFMultipleAlignmentBlock lastMA;
        long offset = this.getClosestOffset(referenceStart);
        this.alignmentBlockTree = new IntervalTree();
        handle.seek(offset);
        boolean okToAdd = true;
        BasicGenomicAnnotation reference = new BasicGenomicAnnotation("reference");
        reference.setStart(referenceStart);
        reference.setEnd(referenceEnd);
        this.sequenceIds = new ArrayList<String>();
        if (sequencesToLoad != null) {
            Iterator<String> seqIt = sequencesToLoad.iterator();
            while (seqIt.hasNext()) {
                this.sequenceIds.add(seqIt.next());
            }
        }
        String line = null;
        String[] lineInfo = null;
        Stack<MAFMultipleAlignmentBlock> alignmentBlockStack = new Stack<MAFMultipleAlignmentBlock>();
        while ((line = handle.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            if (line.startsWith("a ")) {
                MAFMultipleAlignmentBlock mAFMultipleAlignmentBlock = lastMA = alignmentBlockStack.isEmpty() ? null : (MAFMultipleAlignmentBlock)alignmentBlockStack.pop();
                if (lastMA != null) {
                    this.alignmentBlockTree.put(lastMA.getReferenceStart(), lastMA.getReferenceEnd(), lastMA.trim(reference));
                }
                MAFMultipleAlignmentBlock ma = new MAFMultipleAlignmentBlock();
                alignmentBlockStack.push(ma);
                lineInfo = line.substring(2).split("\\s");
                ma.setAlignmentInfoFromRawData(lineInfo);
                okToAdd = true;
                continue;
            }
            if (line.startsWith("s ")) {
                if (alignmentBlockStack.isEmpty() || !okToAdd) continue;
                MAFMultipleAlignmentBlock ma = (MAFMultipleAlignmentBlock)alignmentBlockStack.peek();
                lineInfo = line.substring(2).split("\\s+");
                MultipleAlignment.AlignedSequence seq = ma.createSequenceFromRawData(lineInfo);
                if (this.getReferenceId() == null) {
                    this.setReferenceId(seq.getId());
                    this.setReferenceChromosome(seq.getChromosome());
                }
                if (ma.getReferenceId() == null) {
                    ma.setReferenceId(seq.getId());
                }
                if (sequencesToLoad != null && sequencesToLoad.size() != 0 && !sequencesToLoad.contains(seq.getId())) continue;
                ma.addSequence(seq);
                if (this.getReferenceId().equals(seq.getId()) && seq.getEnd() <= referenceStart) {
                    alignmentBlockStack.pop();
                    okToAdd = false;
                    continue;
                }
                if (this.getReferenceId().equals(seq.getId()) && seq.getStart() >= referenceEnd) {
                    alignmentBlockStack.pop();
                    break;
                }
                if (this.getAlignedSequenceIds().contains(seq.getId())) continue;
                this.sequenceIds.add(seq.getId());
                continue;
            }
            if (line.startsWith("i ") || line.startsWith("q ") || line.startsWith("e ")) continue;
            throw new ParseException("Invalid alignment line <" + line + ">");
        }
        MAFMultipleAlignmentBlock mAFMultipleAlignmentBlock = lastMA = alignmentBlockStack.isEmpty() ? null : (MAFMultipleAlignmentBlock)alignmentBlockStack.pop();
        if (lastMA != null && lastMA.getReferenceStart() < referenceEnd && lastMA.getReferenceEnd() > referenceStart) {
            this.alignmentBlockTree.put(lastMA.getReferenceStart(), lastMA.getReferenceEnd(), lastMA.trim(reference));
        }
    }

    public void load(String fileName, int referenceStart, int referenceEnd) throws IOException, ParseException {
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        this.load(raf, referenceStart, referenceEnd);
        raf.close();
    }

    public IntervalTree<Long> getIndex() {
        return this.index;
    }

    public void writeIndex(String indexFileName) throws IOException {
        Iterator<IntervalTree.Node<Long>> idxEntryIt = this.index.iterator();
        BufferedWriter bw = new BufferedWriter(new FileWriter(indexFileName));
        while (idxEntryIt.hasNext()) {
            IntervalTree.Node<Long> entry = idxEntryIt.next();
            bw.write(String.valueOf(entry.getStart()));
            bw.write("\t" + String.valueOf(entry.getEnd() - entry.getStart()));
            bw.write("\t" + String.valueOf(entry.getValue()));
            bw.newLine();
        }
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String alignmentFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(alignmentFile, "r");
        this.index = new IntervalTree();
        String[] lineInfo = null;
        long lastOffset = 0L;
        try {
            String line;
            boolean readNext = false;
            while ((line = raf.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                if (line.startsWith("a ")) {
                    readNext = true;
                    lastOffset = raf.getFilePointer() - (long)line.getBytes().length - 1L;
                    continue;
                }
                if (line.startsWith("s ")) {
                    if (readNext) {
                        lineInfo = line.split("\\s+");
                        int start = Integer.parseInt(lineInfo[2]);
                        int end = Integer.parseInt(lineInfo[3]) + start;
                        this.index.put(start, end, lastOffset);
                    }
                    readNext = false;
                    continue;
                }
                if (line.startsWith("i ") || line.startsWith("q ")) continue;
                readNext = false;
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public void setBlocks(List<MAFMultipleAlignmentBlock> blocks) {
        this.alignmentBlockTree = new IntervalTree();
        Iterator<MAFMultipleAlignmentBlock> blockIt = blocks.iterator();
        while (blockIt.hasNext()) {
            this.addBlock(blockIt.next());
        }
    }

    public void addBlock(MAFMultipleAlignmentBlock block) throws IllegalArgumentException {
        Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> overlappers = this.alignmentBlockTree.overlappers(block.getReferenceStart(), block.getReferenceEnd());
        if (overlappers != null && overlappers.hasNext()) {
            throw new IllegalArgumentException("A block in the alignment to append already overlaps exisiting alignment block. Can't append");
        }
        for (String seqId : block.getAlignedSequenceIds()) {
            if (this.sequenceIds.contains(seqId)) continue;
            this.sequenceIds.add(seqId);
        }
        this.alignmentBlockTree.put(block.getReferenceStart(), block.getReferenceEnd(), block);
    }

    public void addBlocks(List<MAFMultipleAlignmentBlock> blocks) throws IllegalArgumentException {
        this.addBlocks(blocks.iterator());
    }

    public void addBlocks(Iterator<MAFMultipleAlignmentBlock> blockIt) throws IllegalArgumentException {
        while (blockIt.hasNext()) {
            this.addBlock(blockIt.next());
        }
    }

    public void append(MAFAlignment mafAln) throws IllegalArgumentException {
        this.addBlocks(mafAln.getBlockIterator());
    }

    public void clear() {
        this.alignmentBlockTree = new IntervalTree();
    }

    long getClosestOffset(int position) {
        IntervalTree.Node<Long> node = this.index.max(position, position + 1);
        return node == null ? 0L : node.getValue();
    }

    public Iterator<MAFMultipleAlignmentBlock> getBlockIterator() {
        final Iterator<IntervalTree.Node<MAFMultipleAlignmentBlock>> nodeIt = this.alignmentBlockTree.iterator();
        return new Iterator<MAFMultipleAlignmentBlock>(){

            @Override
            public boolean hasNext() {
                return nodeIt.hasNext();
            }

            @Override
            public MAFMultipleAlignmentBlock next() {
                return (MAFMultipleAlignmentBlock)((IntervalTree.Node)nodeIt.next()).getValue();
            }

            @Override
            public void remove() {
                nodeIt.remove();
            }
        };
    }

    private void setReferenceChromosome(String chromosome) {
        this.referenceChromosome = chromosome;
    }

    private String getReferenceChromosome() {
        return this.referenceChromosome;
    }

    private void padN(int start, int end) {
        MultipleAlignment.AlignedSequence ref;
        MAFMultipleAlignmentBlock pad;
        if (this.getReference() == null) {
            return;
        }
        int startPadLength = this.getReferenceStart() - start;
        int endPadLength = end - this.getReferenceEnd();
        if (startPadLength > 0) {
            pad = new MAFMultipleAlignmentBlock();
            pad.setReferenceId(this.getReferenceId());
            ref = new MultipleAlignment.AlignedSequence(this.getReference().getContainingSequenceId());
            ref.setStart(start);
            ref.setEnd(this.getReferenceStart());
            ref.setId(this.getReferenceId());
            pad.addAlignedSequence(ref);
            ref.setSequenceBases(this.buildPad(startPadLength));
            this.addBlock(pad);
        }
        if (endPadLength > 0) {
            pad = new MAFMultipleAlignmentBlock();
            pad.setReferenceId(this.getReferenceId());
            ref = new MultipleAlignment.AlignedSequence(this.getReference().getContainingSequenceId());
            ref.setStart(this.getReferenceEnd() + 1);
            ref.setEnd(end);
            ref.setId(this.getReferenceId());
            pad.addAlignedSequence(ref);
            ref.setSequenceBases(this.buildPad(endPadLength));
            this.addBlock(pad);
        }
    }

    private String buildPad(int size) {
        StringBuilder padSeq = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            padSeq.append("N");
        }
        return padSeq.toString();
    }

    protected void setAlignedSequences(List<String> seqIds) {
        this.sequenceIds = seqIds;
    }

    public void loadIndex(String idxFile) throws IOException {
        this.index = new IntervalTree();
        BufferedReader br = new BufferedReader(new FileReader(idxFile));
        String line = null;
        boolean l2 = false;
        while ((line = br.readLine()) != null) {
            String[] info = line.split("\t");
            int start = Integer.parseInt(info[0]);
            int end = Integer.parseInt(info[1]) + start;
            long offset = Long.parseLong(info[2]);
            this.index.put(start, end, offset);
        }
    }

    private Map<String, Short> getGapColumn() {
        HashMap<String, Short> gapCol = new HashMap<String, Short>(this.sequenceIds.size());
        Iterator<String> sequenceIdIt = this.sequenceIds.iterator();
        while (sequenceIdIt.hasNext()) {
            gapCol.put(sequenceIdIt.next(), (short)4);
        }
        return gapCol;
    }

    public static class MAFHeader {
        MAFAlignment alignment;
        String version;
        String scoring;
        String program;
        String runParameters;
        Hashtable<String, String> otherVariables = new Hashtable();
        private static final long serialVersionUID = 239451013421586L;

        protected void setVariablesFromRawData(String[] data) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                String[] variableValuePair = data[i2].split("=");
                if (variableValuePair[0].equalsIgnoreCase("version")) {
                    this.version = variableValuePair[1];
                    continue;
                }
                if (variableValuePair[0].equalsIgnoreCase("scoring")) {
                    this.scoring = variableValuePair[1];
                    continue;
                }
                if (variableValuePair[0].equalsIgnoreCase("program")) {
                    this.program = variableValuePair[1];
                    continue;
                }
                this.otherVariables.put(variableValuePair[0].toLowerCase(), variableValuePair[1]);
            }
        }

        public String getRunParameters() {
            return this.runParameters;
        }

        public void addVariableValuePair(String variable, String value) {
            this.otherVariables.put(variable, value);
        }

        public void write(BufferedWriter bw) throws IOException {
            bw.write("##maf");
            if (this.version != null && this.version.length() > 0) {
                bw.write(" version=");
                bw.write(this.version);
            }
            if (this.scoring != null && this.scoring.length() > 0) {
                bw.write(" scoring=");
                bw.write(this.scoring);
            }
            if (this.program != null && this.program.length() > 0) {
                bw.write(" program=");
                bw.write(this.program);
            }
            for (String var : this.otherVariables.keySet()) {
                bw.write(" ");
                bw.write(var);
                bw.write("=");
                bw.write(this.otherVariables.get(var));
            }
            bw.newLine();
            if (this.runParameters != null) {
                bw.write("# ");
                bw.write(this.runParameters);
            }
            bw.newLine();
            bw.newLine();
        }

        public void setRunParameters(String runParameters) {
            this.runParameters = runParameters;
        }

        public void setProgram(String program) {
            this.program = program;
        }

        public void setScoring(String scoring) {
            this.scoring = scoring;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getProgram() {
            return this.program;
        }

        public String getScoring() {
            return this.scoring;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class MAFMultipleAlignmentBlock
    extends MultipleAlignment {
        int pass;

        public MAFMultipleAlignmentBlock() {
            this.setRefGapped(true);
        }

        public MAFMultipleAlignmentBlock(MultipleAlignment ma) {
            this();
            this.setReferenceId(ma.getReferenceId());
            Iterator<MultipleAlignment.AlignedSequence> it = ma.getAlignedSequences().iterator();
            while (it.hasNext()) {
                this.addAlignedSequence(it.next());
            }
        }

        public int getPass() {
            return this.pass;
        }

        public MultipleAlignment.AlignedSequence createSequenceFromRawData(String[] data) {
            String[] seqNameInfo = data[0].split("\\.");
            MultipleAlignment.AlignedSequence aln = new MultipleAlignment.AlignedSequence(seqNameInfo[0].intern());
            if (seqNameInfo.length > 1) {
                aln.setChromosome(seqNameInfo[1]);
            }
            aln.setId(seqNameInfo[0]);
            aln.setName(seqNameInfo[0]);
            aln.setRegionStart(Integer.parseInt(data[1]));
            aln.setRegionEnd(aln.getRegionStart() + Integer.parseInt(data[2]));
            aln.setStrand(data[3]);
            aln.setTotalLength(Integer.parseInt(data[4]));
            aln.setSequenceBases(data[5]);
            return aln;
        }

        public MultipleAlignment.AlignedSequence addSequenceFromRawData(String[] data) {
            MultipleAlignment.AlignedSequence aln = this.createSequenceFromRawData(data);
            this.addSequence(aln);
            return aln;
        }

        public void addAlignedSequence(MultipleAlignment.AlignedSequence aln) {
            this.addSequence(aln);
        }

        public MultipleAlignment.AlignedSequence getAlignedSequence(String sequenceId) {
            MultipleAlignment.AlignedSequence seq = super.getAlignedSequence(sequenceId);
            if (seq == null) {
                seq = new MultipleAlignment.AlignedSequence(sequenceId);
                int length = this.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    seq.appendToSequence('-');
                }
            }
            return seq;
        }

        public void setAlignmentInfoFromRawData(String[] data) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                String[] nameValPair = data[i2].split("=");
                if (nameValPair[0].equalsIgnoreCase("pass")) {
                    this.setPass(Integer.parseInt(nameValPair[1]));
                    continue;
                }
                if (nameValPair[0].equalsIgnoreCase("score")) {
                    this.setScore(Float.parseFloat(nameValPair[1]));
                    continue;
                }
                System.err.println("Unsuported alignment attribute: " + nameValPair[0] + " .... ignoring");
            }
        }

        public void setPass(int pass) {
            this.pass = pass;
        }

        public MAFMultipleAlignmentBlock trim(GenomicAnnotation target) {
            if (target.getStart() <= this.getReferenceStart() && target.getEnd() >= this.getReferenceEnd()) {
                return this;
            }
            return new MAFMultipleAlignmentBlock(this.getSubAlignment(target.getStart(), target.getEnd(), false));
        }
    }
}

