/*
 * Decompiled with CFR 0.152.
 */
package demos;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorComposite
extends JFrame {
    MyCanvas canvas;
    JTextField textField;
    float alphaValue = 0.65f;

    public ColorComposite() {
        Container container = this.getContentPane();
        this.canvas = new MyCanvas();
        container.add(this.canvas);
        JPanel panel = new JPanel();
        JLabel label = new JLabel("Color-Composite: ");
        JSlider slider = new JSlider(0, 0, 100, 65);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                JSlider tempSlider = (JSlider)e2.getSource();
                ColorComposite.this.alphaValue = (float)((double)tempSlider.getValue() / 100.0);
                ColorComposite.this.textField.setText(Float.toString(ColorComposite.this.alphaValue));
                ColorComposite.this.canvas.repaint();
            }
        });
        this.textField = new JTextField("0.65", 4);
        panel.add(label);
        panel.add(slider);
        panel.add(this.textField);
        container.add("South", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        this.setSize(450, 450);
        this.setVisible(true);
    }

    public static void main(String[] arg) {
        new ColorComposite();
    }

    class MyCanvas
    extends JLabel {
        Rectangle2D rec1 = new Rectangle2D.Float(25.0f, 25.0f, 75.0f, 150.0f);
        Rectangle2D rec2 = new Rectangle2D.Float(125.0f, 25.0f, 100.0f, 75.0f);
        Rectangle2D rec3 = new Rectangle2D.Float(75.0f, 125.0f, 125.0f, 75.0f);
        Rectangle2D rec4 = new Rectangle2D.Float(225.0f, 125.0f, 125.0f, 75.0f);
        Rectangle2D rec5 = new Rectangle2D.Float(150.0f, 50.0f, 125.0f, 175.0f);

        MyCanvas() {
            this.setBackground(Color.white);
            this.setSize(400, 225);
        }

        public void paint(Graphics g2) {
            Graphics2D g2D = (Graphics2D)g2;
            AlphaComposite ac = AlphaComposite.getInstance(3, ColorComposite.this.alphaValue);
            g2D.setComposite(ac);
            g2D.setStroke(new BasicStroke(5.0f));
            g2D.draw(this.rec1);
            GradientPaint gp = new GradientPaint(125.0f, 25.0f, Color.yellow, 225.0f, 100.0f, Color.blue);
            g2D.setPaint(gp);
            g2D.fill(this.rec2);
            BufferedImage bi = new BufferedImage(5, 5, 1);
            Graphics2D big = bi.createGraphics();
            big.setColor(Color.magenta);
            big.fillRect(0, 0, 5, 5);
            big.setColor(Color.black);
            big.drawLine(0, 0, 5, 5);
            Rectangle r = new Rectangle(0, 0, 5, 5);
            TexturePaint tp = new TexturePaint(bi, r);
            g2D.setPaint(tp);
            g2D.fill(this.rec3);
            g2D.setColor(Color.green);
            g2D.fill(this.rec4);
            g2D.setColor(Color.red);
            g2D.fill(this.rec5);
        }
    }
}

