/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */
package org.broad.igv.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

import com.jidesoft.dialog.*;
import com.jidesoft.swing.*;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.main.CommandListener;
import org.broad.igv.ui.legend.ChromosomeColorLegend;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.Utilities;

import javax.swing.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;

/**
 * @author jrobinso
 */
public class PreferencesEditor extends javax.swing.JDialog {

    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = new HashMap();
    PreferenceManager prefMgr = PreferenceManager.getInstance();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    private static int lastSelectedIndex = 0;
    boolean proxySettingsChanged;


    private void normalizeCoverageCBFocusLost(FocusEvent e) {
        // TODO add your code here
    }

    private void clearAllProxyButtonActionPerformed(ActionEvent e) {
        if (MessageUtils.confirm("This will immediately clear all proxy settings.  Are you sure?")) {
            this.proxyHostField.setText("");
            this.proxyPortField.setText("");
            this.proxyUsernameField.setText("");
            this.proxyPasswordField.setText("");
            this.useProxyCB.setSelected(false);
            PreferenceManager.getInstance().clearProxySettings();
        }
    }

    public PreferencesEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initValues();

        tabbedPane.setSelectedIndex(lastSelectedIndex);
        setLocationRelativeTo(parent);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    // Generated using JFormDesigner non-commercial license
    private void initComponents() {
        tabbedPane = new JTabbedPane();
        generalPanel = new JPanel();
        jPanel10 = new JPanel();
        missingDataExplanation = new JLabel();
        showMissingDataCB = new JCheckBox();
        combinePanelsCB = new JCheckBox();
        joinSegmentsCB = new JCheckBox();
        showAttributesDisplayCheckBox = new JCheckBox();
        searchZoomCB = new JCheckBox();
        missingDataExplanation6 = new JLabel();
        missingDataExplanation7 = new JLabel();
        tracksPanel = new JPanel();
        jPanel6 = new JPanel();
        jLabel5 = new JLabel();
        defaultChartTrackHeightField = new JTextField();
        trackNameAttributeLabel = new JLabel();
        trackNameAttributeField = new JTextField();
        missingDataExplanation2 = new JLabel();
        jLabel8 = new JLabel();
        defaultTrackHeightField = new JTextField();
        missingDataExplanation4 = new JLabel();
        missingDataExplanation5 = new JLabel();
        missingDataExplanation3 = new JLabel();
        expandCB = new JCheckBox();
        normalizeCoverageCB = new JCheckBox();
        missingDataExplanation8 = new JLabel();
        expandIconCB = new JCheckBox();
        overlaysPanel = new JPanel();
        jPanel5 = new JPanel();
        jLabel3 = new JLabel();
        overlayAttributeTextField = new JTextField();
        overlayTrackCB = new JCheckBox();
        jLabel2 = new JLabel();
        displayTracksCB = new JCheckBox();
        jLabel4 = new JLabel();
        colorOverlyCB = new JCheckBox();
        chooseOverlayColorsButton = new JideButton();
        chartPanel = new JPanel();
        jPanel4 = new JPanel();
        topBorderCB = new JCheckBox();
        label1 = new Label();
        chartDrawTrackNameCB = new JCheckBox();
        bottomBorderCB = new JCheckBox();
        jLabel7 = new JLabel();
        colorBordersCB = new JCheckBox();
        labelYAxisCB = new JCheckBox();
        autoscaleCB = new JCheckBox();
        jLabel9 = new JLabel();
        showDatarangeCB = new JCheckBox();
        alignmentPanel = new JPanel();
        jPanel1 = new JPanel();
        jPanel11 = new JPanel();
        samMaxLevelsField = new JTextField();
        snpThresholdField = new JTextField();
        jLabel11 = new JLabel();
        jLabel26 = new JLabel();
        jLabel17 = new JLabel();
        jLabel16 = new JLabel();
        mappingQualityThresholdField = new JTextField();
        jLabel14 = new JLabel();
        insertSizeThresholdField = new JTextField();
        jLabel13 = new JLabel();
        jLabel15 = new JLabel();
        jLabel18 = new JLabel();
        samMaxWindowSizeField = new JTextField();
        jLabel12 = new JLabel();
        jPanel12 = new JPanel();
        samMinBaseQualityField = new JTextField();
        samShadeMismatchedBaseCB = new JCheckBox();
        samMaxBaseQualityField = new JTextField();
        showCovTrackCB = new JCheckBox();
        samFilterDuplicatesCB = new JCheckBox();
        showRefSeqCB = new JCheckBox();
        jLabel19 = new JLabel();
        filterCB = new JCheckBox();
        filterURL = new JTextField();
        samFlagUnmappedPairCB = new JCheckBox();
        shadeCenterCB = new JCheckBox();
        jLabel10 = new JLabel();
        legendPanel = new ChromosomeColorLegend();
        filterFailedReadsCB = new JCheckBox();
        label2 = new JLabel();
        showSoftClippedCB = new JCheckBox();
        expressionPane = new JPanel();
        jPanel8 = new JPanel();
        expMapToGeneCB = new JRadioButton();
        jLabel24 = new JLabel();
        expMapToLociCB = new JRadioButton();
        jLabel21 = new JLabel();
        advancedPanel = new JPanel();
        jPanel3 = new JPanel();
        jPanel2 = new JPanel();
        jLabel1 = new JLabel();
        genomeServerURLTextField = new JTextField();
        jLabel6 = new JLabel();
        dataServerURLTextField = new JTextField();
        editServerPropertiesCB = new JCheckBox();
        clearGenomeCacheButton = new JButton();
        jButton1 = new JButton();
        jPanel7 = new JPanel();
        enablePortCB = new JCheckBox();
        portField = new JTextField();
        jLabel22 = new JLabel();
        jPanel9 = new JPanel();
        useByteRangeCB = new JCheckBox();
        jLabel25 = new JLabel();
        proxyPanel = new JPanel();
        jPanel15 = new JPanel();
        jPanel16 = new JPanel();
        proxyUsernameField = new JTextField();
        jLabel28 = new JLabel();
        authenticateProxyCB = new JCheckBox();
        jLabel29 = new JLabel();
        proxyPasswordField = new JPasswordField();
        jPanel17 = new JPanel();
        proxyHostField = new JTextField();
        proxyPortField = new JTextField();
        jLabel27 = new JLabel();
        jLabel23 = new JLabel();
        useProxyCB = new JCheckBox();
        label3 = new JLabel();
        clearAllProxyButton = new JButton();
        okCancelButtonPanel = new ButtonPanel();
        okButton = new JButton();
        cancelButton = new JButton();

        //======== this ========
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        //======== tabbedPane ========
        {

            //======== generalPanel ========
            {
                generalPanel.setLayout(null);

                //======== jPanel10 ========
                {

                    //---- missingDataExplanation ----
                    missingDataExplanation.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation.setText("<html>Distinguish  regions with zero values from regions with no data on plots <br>(e.g. bar charts).  Regions with no data are indicated with a gray background.");

                    //---- showMissingDataCB ----
                    showMissingDataCB.setText("Distinguish Missing Data");
                    showMissingDataCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            showMissingDataCBActionPerformed(e);
                        }
                    });

                    //---- combinePanelsCB ----
                    combinePanelsCB.setText("Combine Data and Feature Panels");
                    combinePanelsCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            combinePanelsCBActionPerformed(e);
                        }
                    });

                    //---- joinSegmentsCB ----
                    joinSegmentsCB.setText("Join Adjacent CopyNumber Segments");
                    joinSegmentsCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            joinSegmentsCBActionPerformed(e);
                        }
                    });

                    //---- showAttributesDisplayCheckBox ----
                    showAttributesDisplayCheckBox.setText("Show Attribute Display");
                    showAttributesDisplayCheckBox.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            showAttributesDisplayCheckBoxActionPerformed(e);
                        }
                    });

                    //---- searchZoomCB ----
                    searchZoomCB.setText("Zoom to features");
                    searchZoomCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            searchZoomCBActionPerformed(e);
                        }
                    });

                    //---- missingDataExplanation6 ----
                    missingDataExplanation6.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation6.setText("<html>This option applies to segmented copy number data only.  When selected, gaps between<br>adjacent segments are filled by extending segment endpoints.");

                    //---- missingDataExplanation7 ----
                    missingDataExplanation7.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation7.setText("<html>This option controls the behavior of feature searchs.  If true, the zoom level is changed as required to size the view to the feature size.  If false the zoom level is unchanged.");
                    missingDataExplanation7.setVerticalAlignment(SwingConstants.TOP);

                    GroupLayout jPanel10Layout = new GroupLayout(jPanel10);
                    jPanel10.setLayout(jPanel10Layout);
                    jPanel10Layout.setHorizontalGroup(
                        jPanel10Layout.createParallelGroup()
                            .add(jPanel10Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel10Layout.createParallelGroup()
                                    .add(jPanel10Layout.createSequentialGroup()
                                        .add(35, 35, 35)
                                        .add(missingDataExplanation, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .add(showMissingDataCB)
                                    .add(combinePanelsCB)
                                    .add(joinSegmentsCB)
                                    .add(searchZoomCB)
                                    .add(showAttributesDisplayCheckBox)
                                    .add(jPanel10Layout.createSequentialGroup()
                                        .add(44, 44, 44)
                                        .add(jPanel10Layout.createParallelGroup(GroupLayout.TRAILING)
                                            .add(missingDataExplanation7, GroupLayout.PREFERRED_SIZE, 508, GroupLayout.PREFERRED_SIZE)
                                            .add(missingDataExplanation6, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))))
                                .addContainerGap(50, Short.MAX_VALUE))
                    );
                    jPanel10Layout.setVerticalGroup(
                        jPanel10Layout.createParallelGroup()
                            .add(jPanel10Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(showMissingDataCB)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .add(18, 18, 18)
                                .add(combinePanelsCB)
                                .add(26, 26, 26)
                                .add(joinSegmentsCB)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation6, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .add(18, 18, 18)
                                .add(showAttributesDisplayCheckBox)
                                .add(28, 28, 28)
                                .add(searchZoomCB)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation7, GroupLayout.PREFERRED_SIZE, 78, GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(53, Short.MAX_VALUE))
                    );
                }
                generalPanel.add(jPanel10);
                jPanel10.setBounds(0, 0, 610, 420);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < generalPanel.getComponentCount(); i++) {
                        Rectangle bounds = generalPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = generalPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    generalPanel.setMinimumSize(preferredSize);
                    generalPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("General", generalPanel);


            //======== tracksPanel ========
            {
                tracksPanel.setLayout(null);

                //======== jPanel6 ========
                {

                    //---- jLabel5 ----
                    jLabel5.setText("Default Track Height, Charts (Pixels)");

                    //---- defaultChartTrackHeightField ----
                    defaultChartTrackHeightField.setText("40");
                    defaultChartTrackHeightField.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            defaultChartTrackHeightFieldActionPerformed(e);
                        }
                    });
                    defaultChartTrackHeightField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            defaultChartTrackHeightFieldFocusLost(e);
                        }
                    });

                    //---- trackNameAttributeLabel ----
                    trackNameAttributeLabel.setText("Track Name Attribute");

                    //---- trackNameAttributeField ----
                    trackNameAttributeField.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            trackNameAttributeFieldActionPerformed(e);
                        }
                    });
                    trackNameAttributeField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            trackNameAttributeFieldFocusLost(e);
                        }
                    });

                    //---- missingDataExplanation2 ----
                    missingDataExplanation2.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation2.setText("<html>Name of an attribute to be used to label  tracks.  If provided tracks will be labeled with the corresponding attribute values from the sample information file");
                    missingDataExplanation2.setVerticalAlignment(SwingConstants.TOP);

                    //---- jLabel8 ----
                    jLabel8.setText("Default Track Height, Other (Pixels)");

                    //---- defaultTrackHeightField ----
                    defaultTrackHeightField.setText("15");
                    defaultTrackHeightField.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            defaultTrackHeightFieldActionPerformed(e);
                        }
                    });
                    defaultTrackHeightField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            defaultTrackHeightFieldFocusLost(e);
                        }
                    });

                    //---- missingDataExplanation4 ----
                    missingDataExplanation4.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation4.setText("<html>Default height of chart tracks (barcharts, scatterplots, etc)");

                    //---- missingDataExplanation5 ----
                    missingDataExplanation5.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation5.setText("<html>Default height of all other tracks");

                    //---- missingDataExplanation3 ----
                    missingDataExplanation3.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation3.setText("<html><i> If selected feature tracks are expanded by default.");

                    //---- expandCB ----
                    expandCB.setText("Expand Feature Tracks");
                    expandCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            expandCBActionPerformed(e);
                        }
                    });

                    //---- normalizeCoverageCB ----
                    normalizeCoverageCB.setText("Normalize Coverage Data");
                    normalizeCoverageCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            normalizeCoverageCBActionPerformed(e);
                        }
                    });
                    normalizeCoverageCB.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            normalizeCoverageCBFocusLost(e);
                        }
                    });

                    //---- missingDataExplanation8 ----
                    missingDataExplanation8.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    missingDataExplanation8.setText("<html><i> Applies to coverage tracks computed with igvtools (.tdf files).  If selected coverage values are scaled by (1,000,000 / totalCount),  where totalCount is the total number of features or alignments.");
                    missingDataExplanation8.setVerticalAlignment(SwingConstants.TOP);

                    //---- expandIconCB ----
                    expandIconCB.setText("Show Expand Icon");
                    expandIconCB.setToolTipText("If checked displays an expand/collapse icon on feature tracks.");
                    expandIconCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            expandIconCBActionPerformed(e);
                        }
                    });

                    GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
                    jPanel6.setLayout(jPanel6Layout);
                    jPanel6Layout.setHorizontalGroup(
                        jPanel6Layout.createParallelGroup()
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(jPanel6Layout.createParallelGroup()
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(jPanel6Layout.createParallelGroup()
                                            .add(jPanel6Layout.createSequentialGroup()
                                                .add(24, 24, 24)
                                                .add(missingDataExplanation4, GroupLayout.PREFERRED_SIZE, 354, GroupLayout.PREFERRED_SIZE))
                                            .add(jPanel6Layout.createSequentialGroup()
                                                .add(trackNameAttributeLabel)
                                                .addPreferredGap(LayoutStyle.RELATED)
                                                .add(trackNameAttributeField, GroupLayout.PREFERRED_SIZE, 216, GroupLayout.PREFERRED_SIZE))
                                            .add(jPanel6Layout.createSequentialGroup()
                                                .add(jLabel8)
                                                .add(39, 39, 39)
                                                .add(defaultTrackHeightField, GroupLayout.PREFERRED_SIZE, 57, GroupLayout.PREFERRED_SIZE))
                                            .add(jPanel6Layout.createSequentialGroup()
                                                .add(24, 24, 24)
                                                .add(missingDataExplanation5, GroupLayout.DEFAULT_SIZE, 1141, Short.MAX_VALUE))
                                            .add(jPanel6Layout.createSequentialGroup()
                                                .add(jLabel5)
                                                .add(36, 36, 36)
                                                .add(defaultChartTrackHeightField, GroupLayout.PREFERRED_SIZE, 57, GroupLayout.PREFERRED_SIZE))))
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(expandIconCB)
                                        .add(724, 724, 724)
                                        .add(missingDataExplanation3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .add(63, 63, 63)
                                        .add(missingDataExplanation2, GroupLayout.PREFERRED_SIZE, 578, GroupLayout.PREFERRED_SIZE))
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(expandCB))
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(normalizeCoverageCB))
                                    .add(jPanel6Layout.createSequentialGroup()
                                        .add(50, 50, 50)
                                        .add(missingDataExplanation8, GroupLayout.PREFERRED_SIZE, 608, GroupLayout.PREFERRED_SIZE)))
                                .addContainerGap())
                    );
                    jPanel6Layout.setVerticalGroup(
                        jPanel6Layout.createParallelGroup()
                            .add(jPanel6Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel6Layout.createParallelGroup(GroupLayout.BASELINE)
                                    .add(jLabel5)
                                    .add(defaultChartTrackHeightField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation4, GroupLayout.PREFERRED_SIZE, 25, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jPanel6Layout.createParallelGroup(GroupLayout.BASELINE)
                                    .add(jLabel8)
                                    .add(defaultTrackHeightField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation5, GroupLayout.PREFERRED_SIZE, 25, GroupLayout.PREFERRED_SIZE)
                                .add(26, 26, 26)
                                .add(jPanel6Layout.createParallelGroup(GroupLayout.BASELINE)
                                    .add(trackNameAttributeLabel)
                                    .add(trackNameAttributeField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(missingDataExplanation2, GroupLayout.PREFERRED_SIZE, 54, GroupLayout.PREFERRED_SIZE)
                                .add(28, 28, 28)
                                .add(expandCB)
                                .add(23, 23, 23)
                                .add(jPanel6Layout.createParallelGroup()
                                    .add(missingDataExplanation3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .add(expandIconCB))
                                .addPreferredGap(LayoutStyle.RELATED, 31, Short.MAX_VALUE)
                                .add(normalizeCoverageCB)
                                .add(18, 18, 18)
                                .add(missingDataExplanation8, GroupLayout.PREFERRED_SIZE, 52, GroupLayout.PREFERRED_SIZE)
                                .add(15, 15, 15))
                    );
                }
                tracksPanel.add(jPanel6);
                jPanel6.setBounds(40, 20, 690, 480);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < tracksPanel.getComponentCount(); i++) {
                        Rectangle bounds = tracksPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = tracksPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    tracksPanel.setMinimumSize(preferredSize);
                    tracksPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Tracks", tracksPanel);


            //======== overlaysPanel ========
            {

                //======== jPanel5 ========
                {

                    //---- jLabel3 ----
                    jLabel3.setText("Overlay tracks based on attribute:");

                    //---- overlayAttributeTextField ----
                    overlayAttributeTextField.setText("LINKING_ID");
                    overlayAttributeTextField.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            overlayAttributeTextFieldActionPerformed(e);
                        }
                    });
                    overlayAttributeTextField.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            overlayAttributeTextFieldFocusLost(e);
                        }
                    });
                    overlayAttributeTextField.addKeyListener(new KeyAdapter() {
                        @Override
                        public void keyTyped(KeyEvent e) {
                            overlayAttributeTextFieldKeyTyped(e);
                        }
                    });

                    //---- overlayTrackCB ----
                    overlayTrackCB.setSelected(true);
                    overlayTrackCB.setText("Overlay mutation tracks");
                    overlayTrackCB.setActionCommand("overlayTracksCB");
                    overlayTrackCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            overlayTrackCBActionPerformed(e);
                        }
                    });

                    //---- jLabel2 ----
                    jLabel2.setFont(new Font("Lucida Grande", Font.ITALIC, 12));

                    //---- displayTracksCB ----
                    displayTracksCB.setText("Display mutation data as distinct tracks");
                    displayTracksCB.setActionCommand("displayTracksCB");
                    displayTracksCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            displayTracksCBActionPerformed(e);
                        }
                    });

                    //---- jLabel4 ----
                    jLabel4.setFont(new Font("Lucida Grande", Font.ITALIC, 12));

                    //---- colorOverlyCB ----
                    colorOverlyCB.setText("Color code overlay");
                    colorOverlyCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            colorOverlyCBActionPerformed(e);
                        }
                    });

                    //---- chooseOverlayColorsButton ----
                    chooseOverlayColorsButton.setForeground(new Color(0, 0, 247));
                    chooseOverlayColorsButton.setText("Choose colors");
                    chooseOverlayColorsButton.setFont(new Font("Lucida Grande", Font.ITALIC, 12));
                    chooseOverlayColorsButton.setVerticalAlignment(SwingConstants.BOTTOM);
                    chooseOverlayColorsButton.setVerticalTextPosition(SwingConstants.BOTTOM);
                    chooseOverlayColorsButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            chooseOverlayColorsButtonActionPerformed(e);
                        }
                    });

                    GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
                    jPanel5.setLayout(jPanel5Layout);
                    jPanel5Layout.setHorizontalGroup(
                        jPanel5Layout.createParallelGroup()
                            .add(jPanel5Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel5Layout.createParallelGroup()
                                    .add(displayTracksCB)
                                    .add(jLabel4)
                                    .add(overlayTrackCB)
                                    .add(jLabel2)
                                    .add(jPanel5Layout.createSequentialGroup()
                                        .add(59, 59, 59)
                                        .add(jPanel5Layout.createParallelGroup()
                                            .add(jPanel5Layout.createSequentialGroup()
                                                .add(colorOverlyCB)
                                                .addPreferredGap(LayoutStyle.RELATED)
                                                .add(chooseOverlayColorsButton, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                            .add(jPanel5Layout.createSequentialGroup()
                                                .add(jLabel3)
                                                .addPreferredGap(LayoutStyle.RELATED)
                                                .add(overlayAttributeTextField, GroupLayout.PREFERRED_SIZE, 228, GroupLayout.PREFERRED_SIZE)))))
                                .addContainerGap())
                    );
                    jPanel5Layout.setVerticalGroup(
                        jPanel5Layout.createParallelGroup()
                            .add(jPanel5Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jLabel2)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jLabel4)
                                .add(39, 39, 39)
                                .add(overlayTrackCB)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jPanel5Layout.createParallelGroup(GroupLayout.BASELINE)
                                    .add(jLabel3)
                                    .add(overlayAttributeTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .add(6, 6, 6)
                                .add(jPanel5Layout.createParallelGroup(GroupLayout.TRAILING)
                                    .add(colorOverlyCB)
                                    .add(chooseOverlayColorsButton, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .add(36, 36, 36)
                                .add(displayTracksCB)
                                .addContainerGap(30, Short.MAX_VALUE))
                    );
                }

                GroupLayout overlaysPanelLayout = new GroupLayout(overlaysPanel);
                overlaysPanel.setLayout(overlaysPanelLayout);
                overlaysPanelLayout.setHorizontalGroup(
                    overlaysPanelLayout.createParallelGroup()
                        .add(overlaysPanelLayout.createSequentialGroup()
                            .add(28, 28, 28)
                            .add(jPanel5, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addContainerGap(235, Short.MAX_VALUE))
                );
                overlaysPanelLayout.setVerticalGroup(
                    overlaysPanelLayout.createParallelGroup()
                        .add(overlaysPanelLayout.createSequentialGroup()
                            .add(55, 55, 55)
                            .add(jPanel5, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addContainerGap(225, Short.MAX_VALUE))
                );
            }
            tabbedPane.addTab("Mutations", overlaysPanel);


            //======== chartPanel ========
            {
                chartPanel.setLayout(null);

                //======== jPanel4 ========
                {

                    //---- topBorderCB ----
                    topBorderCB.setText("Draw Top Border");
                    topBorderCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            topBorderCBActionPerformed(e);
                        }
                    });

                    //---- label1 ----
                    label1.setFont(label1.getFont());
                    label1.setText("Default settings for barcharts and scatterplots:");

                    //---- chartDrawTrackNameCB ----
                    chartDrawTrackNameCB.setText("Draw Track Label");
                    chartDrawTrackNameCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            chartDrawTrackNameCBActionPerformed(e);
                        }
                    });

                    //---- bottomBorderCB ----
                    bottomBorderCB.setText("Draw Bottom Border");
                    bottomBorderCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            bottomBorderCBActionPerformed(e);
                        }
                    });

                    //---- jLabel7 ----
                    jLabel7.setText("<html><i>If selected charts are dynamically rescaled to the range of the data in view.");

                    //---- colorBordersCB ----
                    colorBordersCB.setText("Color Borders");
                    colorBordersCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            colorBordersCBActionPerformed(e);
                        }
                    });

                    //---- labelYAxisCB ----
                    labelYAxisCB.setText("Label Y Axis");
                    labelYAxisCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            labelYAxisCBActionPerformed(e);
                        }
                    });

                    //---- autoscaleCB ----
                    autoscaleCB.setText("Continuous Autoscale");
                    autoscaleCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            autoscaleCBActionPerformed(e);
                        }
                    });

                    //---- jLabel9 ----
                    jLabel9.setText("<html><i>Draw a label centered over the track provided<br>the track height is at least 25 pixels. ");

                    //---- showDatarangeCB ----
                    showDatarangeCB.setText("Show Data Range");
                    showDatarangeCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            showDatarangeCBActionPerformed(e);
                        }
                    });
                    showDatarangeCB.addFocusListener(new FocusAdapter() {
                        @Override
                        public void focusLost(FocusEvent e) {
                            showDatarangeCBFocusLost(e);
                        }
                    });

                    GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
                    jPanel4.setLayout(jPanel4Layout);
                    jPanel4Layout.setHorizontalGroup(
                        jPanel4Layout.createParallelGroup()
                            .add(jPanel4Layout.createParallelGroup()
                                .add(GroupLayout.TRAILING, jPanel4Layout.createSequentialGroup()
                                    .addContainerGap(221, Short.MAX_VALUE)
                                    .add(jLabel9, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .add(84, 84, 84)))
                            .add(jPanel4Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel4Layout.createParallelGroup()
                                    .add(label1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .add(jPanel4Layout.createSequentialGroup()
                                        .add(20, 20, 20)
                                        .add(jPanel4Layout.createParallelGroup()
                                            .add(jPanel4Layout.createSequentialGroup()
                                                .add(jPanel4Layout.createParallelGroup()
                                                    .add(autoscaleCB)
                                                    .add(showDatarangeCB))
                                                .add(18, 18, 18)
                                                .add(jLabel7, GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE))
                                            .add(jPanel4Layout.createSequentialGroup()
                                                .add(jPanel4Layout.createParallelGroup()
                                                    .add(topBorderCB)
                                                    .add(colorBordersCB)
                                                    .add(bottomBorderCB)
                                                    .add(labelYAxisCB)
                                                    .add(chartDrawTrackNameCB))
                                                .addPreferredGap(LayoutStyle.RELATED, 403, Short.MAX_VALUE)))))
                                .addContainerGap())
                    );
                    jPanel4Layout.setVerticalGroup(
                        jPanel4Layout.createParallelGroup()
                            .add(jPanel4Layout.createParallelGroup()
                                .add(jPanel4Layout.createSequentialGroup()
                                    .add(131, 131, 131)
                                    .add(jLabel9, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .addContainerGap(181, Short.MAX_VALUE)))
                            .add(jPanel4Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(label1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(topBorderCB)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(bottomBorderCB)
                                .add(7, 7, 7)
                                .add(colorBordersCB)
                                .add(18, 18, 18)
                                .add(chartDrawTrackNameCB)
                                .add(23, 23, 23)
                                .add(labelYAxisCB)
                                .add(18, 18, 18)
                                .add(jPanel4Layout.createParallelGroup(GroupLayout.BASELINE)
                                    .add(autoscaleCB)
                                    .add(jLabel7, GroupLayout.PREFERRED_SIZE, 50, GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(LayoutStyle.UNRELATED)
                                .add(showDatarangeCB)
                                .add(36, 36, 36))
                    );
                }
                chartPanel.add(jPanel4);
                jPanel4.setBounds(20, 30, 590, 340);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < chartPanel.getComponentCount(); i++) {
                        Rectangle bounds = chartPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = chartPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    chartPanel.setMinimumSize(preferredSize);
                    chartPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Charts", chartPanel);


            //======== alignmentPanel ========
            {
                alignmentPanel.setLayout(null);

                //======== jPanel1 ========
                {
                    jPanel1.setLayout(null);

                    //======== jPanel11 ========
                    {
                        jPanel11.setLayout(null);

                        //---- samMaxLevelsField ----
                        samMaxLevelsField.setText("jTextField1");
                        samMaxLevelsField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samMaxLevelFieldActionPerformed(e);
                            }
                        });
                        samMaxLevelsField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                samMaxLevelFieldFocusLost(e);
                            }
                        });
                        jPanel11.add(samMaxLevelsField);
                        samMaxLevelsField.setBounds(new Rectangle(new Point(206, 41), samMaxLevelsField.getPreferredSize()));

                        //---- snpThresholdField ----
                        snpThresholdField.setText("0");
                        snpThresholdField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                snpThresholdFieldActionPerformed(e);
                            }
                        });
                        snpThresholdField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                snpThresholdFieldFocusLost(e);
                            }
                        });
                        jPanel11.add(snpThresholdField);
                        snpThresholdField.setBounds(206, 144, 84, snpThresholdField.getPreferredSize().height);

                        //---- jLabel11 ----
                        jLabel11.setText("Visibility range threshold (kb)");
                        jPanel11.add(jLabel11);
                        jLabel11.setBounds(new Rectangle(new Point(6, 12), jLabel11.getPreferredSize()));

                        //---- jLabel26 ----
                        jLabel26.setText("Coverage allele-freq threshold");
                        jPanel11.add(jLabel26);
                        jLabel26.setBounds(6, 150, 200, jLabel26.getPreferredSize().height);

                        //---- jLabel17 ----
                        jLabel17.setText("Insert size flagging threshold:");
                        jPanel11.add(jLabel17);
                        jLabel17.setBounds(6, 116, 200, jLabel17.getPreferredSize().height);

                        //---- jLabel16 ----
                        jLabel16.setText("<html><i>Reads with qualities  below the threshold are not shown.");
                        jPanel11.add(jLabel16);
                        jLabel16.setBounds(new Rectangle(new Point(296, 82), jLabel16.getPreferredSize()));

                        //---- mappingQualityThresholdField ----
                        mappingQualityThresholdField.setText("0");
                        mappingQualityThresholdField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                mappingQualityThresholdFieldActionPerformed(e);
                            }
                        });
                        mappingQualityThresholdField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                mappingQualityThresholdFieldFocusLost(e);
                            }
                        });
                        jPanel11.add(mappingQualityThresholdField);
                        mappingQualityThresholdField.setBounds(206, 76, 84, mappingQualityThresholdField.getPreferredSize().height);

                        //---- jLabel14 ----
                        jLabel14.setText("<html><i>Maximum depth of reads to display (approximate).");
                        jPanel11.add(jLabel14);
                        jLabel14.setBounds(296, 40, 390, 30);

                        //---- insertSizeThresholdField ----
                        insertSizeThresholdField.setText("0");
                        insertSizeThresholdField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                insertSizeThresholdFieldActionPerformed(e);
                            }
                        });
                        insertSizeThresholdField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                insertSizeThresholdFieldFocusLost(e);
                            }
                        });
                        jPanel11.add(insertSizeThresholdField);
                        insertSizeThresholdField.setBounds(206, 110, 84, insertSizeThresholdField.getPreferredSize().height);

                        //---- jLabel13 ----
                        jLabel13.setText("Maximum read depth:");
                        jPanel11.add(jLabel13);
                        jLabel13.setBounds(new Rectangle(new Point(6, 47), jLabel13.getPreferredSize()));

                        //---- jLabel15 ----
                        jLabel15.setText("Mapping quality threshold:");
                        jPanel11.add(jLabel15);
                        jLabel15.setBounds(new Rectangle(new Point(6, 82), jLabel15.getPreferredSize()));

                        //---- jLabel18 ----
                        jLabel18.setText("<html><i>Paired end alignments with insert sizes > this value are flagged.");
                        jPanel11.add(jLabel18);
                        jLabel18.setBounds(296, 110, 414, 40);

                        //---- samMaxWindowSizeField ----
                        samMaxWindowSizeField.setText("jTextField1");
                        samMaxWindowSizeField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samMaxWindowSizeFieldActionPerformed(e);
                            }
                        });
                        samMaxWindowSizeField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                samMaxWindowSizeFieldFocusLost(e);
                            }
                        });
                        jPanel11.add(samMaxWindowSizeField);
                        samMaxWindowSizeField.setBounds(new Rectangle(new Point(206, 6), samMaxWindowSizeField.getPreferredSize()));

                        //---- jLabel12 ----
                        jLabel12.setText("<html><i>Nominal window size at which alignments become visible");
                        jPanel11.add(jLabel12);
                        jLabel12.setBounds(new Rectangle(new Point(296, 12), jLabel12.getPreferredSize()));

                        { // compute preferred size
                            Dimension preferredSize = new Dimension();
                            for(int i = 0; i < jPanel11.getComponentCount(); i++) {
                                Rectangle bounds = jPanel11.getComponent(i).getBounds();
                                preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                                preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                            }
                            Insets insets = jPanel11.getInsets();
                            preferredSize.width += insets.right;
                            preferredSize.height += insets.bottom;
                            jPanel11.setMinimumSize(preferredSize);
                            jPanel11.setPreferredSize(preferredSize);
                        }
                    }
                    jPanel1.add(jPanel11);
                    jPanel11.setBounds(new Rectangle(new Point(6, 20), jPanel11.getPreferredSize()));

                    //======== jPanel12 ========
                    {
                        jPanel12.setLayout(null);

                        //---- samMinBaseQualityField ----
                        samMinBaseQualityField.setText("0");
                        samMinBaseQualityField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samMinBaseQualityFieldActionPerformed(e);
                            }
                        });
                        samMinBaseQualityField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                samMinBaseQualityFieldFocusLost(e);
                            }
                        });
                        jPanel12.add(samMinBaseQualityField);
                        samMinBaseQualityField.setBounds(325, 140, 50, samMinBaseQualityField.getPreferredSize().height);

                        //---- samShadeMismatchedBaseCB ----
                        samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality. ");
                        samShadeMismatchedBaseCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samShadeMismatchedBaseCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(samShadeMismatchedBaseCB);
                        samShadeMismatchedBaseCB.setBounds(6, 146, 290, samShadeMismatchedBaseCB.getPreferredSize().height);

                        //---- samMaxBaseQualityField ----
                        samMaxBaseQualityField.setText("0");
                        samMaxBaseQualityField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samMaxBaseQualityFieldActionPerformed(e);
                            }
                        });
                        samMaxBaseQualityField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                samMaxBaseQualityFieldFocusLost(e);
                            }
                        });
                        jPanel12.add(samMaxBaseQualityField);
                        samMaxBaseQualityField.setBounds(455, 140, 50, samMaxBaseQualityField.getPreferredSize().height);

                        //---- showCovTrackCB ----
                        showCovTrackCB.setText("Show coverage track");
                        showCovTrackCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                showCovTrackCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(showCovTrackCB);
                        showCovTrackCB.setBounds(385, 76, 270, showCovTrackCB.getPreferredSize().height);

                        //---- samFilterDuplicatesCB ----
                        samFilterDuplicatesCB.setText("Filter duplicate reads");
                        samFilterDuplicatesCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samShowDuplicatesCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(samFilterDuplicatesCB);
                        samFilterDuplicatesCB.setBounds(6, 6, 290, samFilterDuplicatesCB.getPreferredSize().height);

                        //---- showRefSeqCB ----
                        showRefSeqCB.setText("Show reference sequence");
                        showRefSeqCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                showRefSeqCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(showRefSeqCB);
                        showRefSeqCB.setBounds(385, 6, 270, showRefSeqCB.getPreferredSize().height);

                        //---- jLabel19 ----
                        jLabel19.setText("Min: ");
                        jPanel12.add(jLabel19);
                        jLabel19.setBounds(new Rectangle(new Point(285, 145), jLabel19.getPreferredSize()));

                        //---- filterCB ----
                        filterCB.setText("Filter alignments");
                        filterCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                filterCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(filterCB);
                        filterCB.setBounds(6, 181, 144, filterCB.getPreferredSize().height);

                        //---- filterURL ----
                        filterURL.setText("URL or path to filter file");
                        filterURL.setEnabled(false);
                        filterURL.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                filterURLActionPerformed(e);
                            }
                        });
                        filterURL.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                filterURLFocusLost(e);
                            }
                        });
                        jPanel12.add(filterURL);
                        filterURL.setBounds(190, 185, 482, filterURL.getPreferredSize().height);

                        //---- samFlagUnmappedPairCB ----
                        samFlagUnmappedPairCB.setText("Flag unmapped pairs");
                        samFlagUnmappedPairCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                samFlagUnmappedPairCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(samFlagUnmappedPairCB);
                        samFlagUnmappedPairCB.setBounds(6, 76, 310, samFlagUnmappedPairCB.getPreferredSize().height);

                        //---- shadeCenterCB ----
                        shadeCenterCB.setText("Shade alignments intersecting center");
                        shadeCenterCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                shadeCenterCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(shadeCenterCB);
                        shadeCenterCB.setBounds(385, 41, 450, shadeCenterCB.getPreferredSize().height);

                        //---- jLabel10 ----
                        jLabel10.setText("<html>Chromosome color legend &nbsp;&nbsp;&nbsp;<i>Used to flag paired end reads with mates on other chromosomes");
                        jPanel12.add(jLabel10);
                        jLabel10.setBounds(5, 230, 640, 30);

                        //======== legendPanel ========
                        {

                            GroupLayout legendPanelLayout = new GroupLayout(legendPanel);
                            legendPanel.setLayout(legendPanelLayout);
                            legendPanelLayout.setHorizontalGroup(
                                legendPanelLayout.createParallelGroup()
                                    .add(0, 602, Short.MAX_VALUE)
                            );
                            legendPanelLayout.setVerticalGroup(
                                legendPanelLayout.createParallelGroup()
                                    .add(0, 25, Short.MAX_VALUE)
                            );
                        }
                        jPanel12.add(legendPanel);
                        legendPanel.setBounds(new Rectangle(new Point(5, 270), legendPanel.getPreferredSize()));

                        //---- filterFailedReadsCB ----
                        filterFailedReadsCB.setText("Filter vendor failed reads");
                        filterFailedReadsCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                filterVendorFailedReadsCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(filterFailedReadsCB);
                        filterFailedReadsCB.setBounds(new Rectangle(new Point(6, 41), filterFailedReadsCB.getPreferredSize()));

                        //---- label2 ----
                        label2.setText("Max:");
                        jPanel12.add(label2);
                        label2.setBounds(new Rectangle(new Point(400, 145), label2.getPreferredSize()));

                        //---- showSoftClippedCB ----
                        showSoftClippedCB.setText("Show soft-clipped bases");
                        showSoftClippedCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                showSoftClippedCBActionPerformed(e);
                            }
                        });
                        jPanel12.add(showSoftClippedCB);
                        showSoftClippedCB.setBounds(new Rectangle(new Point(6, 111), showSoftClippedCB.getPreferredSize()));

                        { // compute preferred size
                            Dimension preferredSize = new Dimension();
                            for(int i = 0; i < jPanel12.getComponentCount(); i++) {
                                Rectangle bounds = jPanel12.getComponent(i).getBounds();
                                preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                                preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                            }
                            Insets insets = jPanel12.getInsets();
                            preferredSize.width += insets.right;
                            preferredSize.height += insets.bottom;
                            jPanel12.setMinimumSize(preferredSize);
                            jPanel12.setPreferredSize(preferredSize);
                        }
                    }
                    jPanel1.add(jPanel12);
                    jPanel12.setBounds(6, 198, 740, 297);

                    { // compute preferred size
                        Dimension preferredSize = new Dimension();
                        for(int i = 0; i < jPanel1.getComponentCount(); i++) {
                            Rectangle bounds = jPanel1.getComponent(i).getBounds();
                            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                        }
                        Insets insets = jPanel1.getInsets();
                        preferredSize.width += insets.right;
                        preferredSize.height += insets.bottom;
                        jPanel1.setMinimumSize(preferredSize);
                        jPanel1.setPreferredSize(preferredSize);
                    }
                }
                alignmentPanel.add(jPanel1);
                jPanel1.setBounds(0, 0, 760, 510);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < alignmentPanel.getComponentCount(); i++) {
                        Rectangle bounds = alignmentPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = alignmentPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    alignmentPanel.setMinimumSize(preferredSize);
                    alignmentPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Alignments", alignmentPanel);


            //======== expressionPane ========
            {
                expressionPane.setLayout(null);

                //======== jPanel8 ========
                {

                    //---- expMapToGeneCB ----
                    expMapToGeneCB.setText("Map probes to genes");
                    expMapToGeneCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            expMapToGeneCBActionPerformed(e);
                        }
                    });

                    //---- jLabel24 ----
                    jLabel24.setText("Expression probe mapping options: ");

                    //---- expMapToLociCB ----
                    expMapToLociCB.setText("<html>Map probes to target loci");
                    expMapToLociCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            expMapToLociCBActionPerformed(e);
                        }
                    });

                    //---- jLabel21 ----
                    jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");

                    GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
                    jPanel8.setLayout(jPanel8Layout);
                    jPanel8Layout.setHorizontalGroup(
                        jPanel8Layout.createParallelGroup()
                            .add(jPanel8Layout.createSequentialGroup()
                                .add(jPanel8Layout.createParallelGroup()
                                    .add(jPanel8Layout.createSequentialGroup()
                                        .add(45, 45, 45)
                                        .add(jPanel8Layout.createParallelGroup()
                                            .add(expMapToLociCB, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                            .add(expMapToGeneCB)))
                                    .add(jPanel8Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(jPanel8Layout.createParallelGroup()
                                            .add(jPanel8Layout.createSequentialGroup()
                                                .add(24, 24, 24)
                                                .add(jLabel21, GroupLayout.PREFERRED_SIZE, 497, GroupLayout.PREFERRED_SIZE))
                                            .add(jLabel24))))
                                .addContainerGap(193, Short.MAX_VALUE))
                    );
                    jPanel8Layout.setVerticalGroup(
                        jPanel8Layout.createParallelGroup()
                            .add(jPanel8Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jLabel24)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jLabel21, GroupLayout.PREFERRED_SIZE, 44, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(expMapToLociCB, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .add(14, 14, 14)
                                .add(expMapToGeneCB)
                                .addContainerGap(172, Short.MAX_VALUE))
                    );
                }
                expressionPane.add(jPanel8);
                jPanel8.setBounds(10, 30, 720, 310);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < expressionPane.getComponentCount(); i++) {
                        Rectangle bounds = expressionPane.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = expressionPane.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    expressionPane.setMinimumSize(preferredSize);
                    expressionPane.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Probes", expressionPane);


            //======== advancedPanel ========
            {
                advancedPanel.setBorder(new EmptyBorder(1, 10, 1, 10));
                advancedPanel.setLayout(null);

                //======== jPanel3 ========
                {

                    //======== jPanel2 ========
                    {

                        //---- jLabel1 ----
                        jLabel1.setText("Genome Server URL");

                        //---- genomeServerURLTextField ----
                        genomeServerURLTextField.setText("jTextField1");
                        genomeServerURLTextField.setEnabled(false);
                        genomeServerURLTextField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                genomeServerURLTextFieldActionPerformed(e);
                            }
                        });
                        genomeServerURLTextField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                genomeServerURLTextFieldFocusLost(e);
                            }
                        });

                        //---- jLabel6 ----
                        jLabel6.setText("Data Registry URL");

                        //---- dataServerURLTextField ----
                        dataServerURLTextField.setEnabled(false);
                        dataServerURLTextField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                dataServerURLTextFieldActionPerformed(e);
                            }
                        });
                        dataServerURLTextField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                dataServerURLTextFieldFocusLost(e);
                            }
                        });

                        //---- editServerPropertiesCB ----
                        editServerPropertiesCB.setText("Edit server properties");
                        editServerPropertiesCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                editServerPropertiesCBActionPerformed(e);
                            }
                        });

                        //---- clearGenomeCacheButton ----
                        clearGenomeCacheButton.setText("Clear Genome Cache");
                        clearGenomeCacheButton.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                clearGenomeCacheButtonActionPerformed(e);
                            }
                        });

                        //---- jButton1 ----
                        jButton1.setText("Reset to Defaults");
                        jButton1.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                jButton1ActionPerformed(e);
                            }
                        });

                        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
                        jPanel2.setLayout(jPanel2Layout);
                        jPanel2Layout.setHorizontalGroup(
                            jPanel2Layout.createParallelGroup()
                                .add(jPanel2Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .add(jPanel2Layout.createParallelGroup()
                                        .add(jPanel2Layout.createSequentialGroup()
                                            .add(29, 29, 29)
                                            .add(jPanel2Layout.createParallelGroup()
                                                .add(jLabel1)
                                                .add(jPanel2Layout.createSequentialGroup()
                                                    .add(jLabel6)
                                                    .add(44, 44, 44)
                                                    .add(jPanel2Layout.createParallelGroup(GroupLayout.LEADING, false)
                                                        .add(dataServerURLTextField)
                                                        .add(genomeServerURLTextField, GroupLayout.PREFERRED_SIZE, 494, GroupLayout.PREFERRED_SIZE)))))
                                        .add(jPanel2Layout.createSequentialGroup()
                                            .add(editServerPropertiesCB)
                                            .add(18, 18, 18)
                                            .add(jButton1))
                                        .add(clearGenomeCacheButton))
                                    .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        );
                        jPanel2Layout.setVerticalGroup(
                            jPanel2Layout.createParallelGroup()
                                .add(jPanel2Layout.createSequentialGroup()
                                    .addContainerGap()
                                    .add(jPanel2Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(editServerPropertiesCB)
                                        .add(jButton1))
                                    .addPreferredGap(LayoutStyle.RELATED)
                                    .add(jPanel2Layout.createParallelGroup(GroupLayout.CENTER)
                                        .add(jLabel1)
                                        .add(genomeServerURLTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(LayoutStyle.RELATED)
                                    .add(jPanel2Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(jLabel6)
                                        .add(dataServerURLTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .add(18, 18, 18)
                                    .add(clearGenomeCacheButton)
                                    .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        );
                    }

                    //======== jPanel7 ========
                    {

                        //---- enablePortCB ----
                        enablePortCB.setText("Enable port");
                        enablePortCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                enablePortCBActionPerformed(e);
                            }
                        });

                        //---- portField ----
                        portField.setText("60151");
                        portField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                portFieldActionPerformed(e);
                            }
                        });
                        portField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                portFieldFocusLost(e);
                            }
                        });

                        //---- jLabel22 ----
                        jLabel22.setFont(new Font("Lucida Grande", Font.ITALIC, 13));
                        jLabel22.setText("Enable port to send commands and http requests to IGV. ");

                        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
                        jPanel7.setLayout(jPanel7Layout);
                        jPanel7Layout.setHorizontalGroup(
                            jPanel7Layout.createParallelGroup()
                                .add(jPanel7Layout.createSequentialGroup()
                                    .add(jPanel7Layout.createParallelGroup()
                                        .add(jPanel7Layout.createSequentialGroup()
                                            .addContainerGap()
                                            .add(enablePortCB)
                                            .add(39, 39, 39)
                                            .add(portField, GroupLayout.PREFERRED_SIZE, 126, GroupLayout.PREFERRED_SIZE))
                                        .add(jPanel7Layout.createSequentialGroup()
                                            .add(48, 48, 48)
                                            .add(jLabel22)))
                                    .addContainerGap(330, Short.MAX_VALUE))
                        );
                        jPanel7Layout.setVerticalGroup(
                            jPanel7Layout.createParallelGroup()
                                .add(jPanel7Layout.createSequentialGroup()
                                    .add(28, 28, 28)
                                    .add(jPanel7Layout.createParallelGroup(GroupLayout.CENTER)
                                        .add(enablePortCB)
                                        .add(portField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(LayoutStyle.UNRELATED)
                                    .add(jLabel22)
                                    .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        );
                    }

                    GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
                    jPanel3.setLayout(jPanel3Layout);
                    jPanel3Layout.setHorizontalGroup(
                        jPanel3Layout.createParallelGroup()
                            .add(jPanel3Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel3Layout.createParallelGroup()
                                    .add(jPanel7, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(jPanel2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addContainerGap())
                    );
                    jPanel3Layout.setVerticalGroup(
                        jPanel3Layout.createParallelGroup()
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(20, 20, 20)
                                .add(jPanel7, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED, 58, Short.MAX_VALUE)
                                .add(jPanel2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .addContainerGap())
                    );
                }
                advancedPanel.add(jPanel3);
                jPanel3.setBounds(10, 0, 750, 330);

                //======== jPanel9 ========
                {

                    //---- useByteRangeCB ----
                    useByteRangeCB.setText("Use http byte-range requests");
                    useByteRangeCB.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            useByteRangeCBActionPerformed(e);
                        }
                    });

                    //---- jLabel25 ----
                    jLabel25.setFont(new Font("Lucida Grande", Font.ITALIC, 13));
                    jLabel25.setText("<html>This option applies to certain \"Load from Server...\" tracks hosted at the Broad.    Disable this option if you are unable to load the phastCons conservation track under the hg18 annotations.");

                    GroupLayout jPanel9Layout = new GroupLayout(jPanel9);
                    jPanel9.setLayout(jPanel9Layout);
                    jPanel9Layout.setHorizontalGroup(
                        jPanel9Layout.createParallelGroup()
                            .add(jPanel9Layout.createSequentialGroup()
                                .add(jPanel9Layout.createParallelGroup()
                                    .add(jPanel9Layout.createSequentialGroup()
                                        .add(44, 44, 44)
                                        .add(jLabel25, GroupLayout.PREFERRED_SIZE, 601, GroupLayout.PREFERRED_SIZE))
                                    .add(jPanel9Layout.createSequentialGroup()
                                        .addContainerGap()
                                        .add(useByteRangeCB)))
                                .addContainerGap(65, Short.MAX_VALUE))
                    );
                    jPanel9Layout.setVerticalGroup(
                        jPanel9Layout.createParallelGroup()
                            .add(jPanel9Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(useByteRangeCB, GroupLayout.PREFERRED_SIZE, 38, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jLabel25, GroupLayout.DEFAULT_SIZE, 64, Short.MAX_VALUE)
                                .add(6, 6, 6))
                    );
                }
                advancedPanel.add(jPanel9);
                jPanel9.setBounds(30, 340, 710, 120);

                { // compute preferred size
                    Dimension preferredSize = new Dimension();
                    for(int i = 0; i < advancedPanel.getComponentCount(); i++) {
                        Rectangle bounds = advancedPanel.getComponent(i).getBounds();
                        preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                        preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                    }
                    Insets insets = advancedPanel.getInsets();
                    preferredSize.width += insets.right;
                    preferredSize.height += insets.bottom;
                    advancedPanel.setMinimumSize(preferredSize);
                    advancedPanel.setPreferredSize(preferredSize);
                }
            }
            tabbedPane.addTab("Advanced", advancedPanel);


            //======== proxyPanel ========
            {
                proxyPanel.setLayout(new BoxLayout(proxyPanel, BoxLayout.X_AXIS));

                //======== jPanel15 ========
                {

                    //======== jPanel16 ========
                    {

                        //---- proxyUsernameField ----
                        proxyUsernameField.setText("jTextField1");
                        proxyUsernameField.setEnabled(false);
                        proxyUsernameField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                proxyUsernameFieldActionPerformed(e);
                            }
                        });
                        proxyUsernameField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyUsernameFieldFocusLost(e);
                            }
                        });

                        //---- jLabel28 ----
                        jLabel28.setText("Username");

                        //---- authenticateProxyCB ----
                        authenticateProxyCB.setText("Authentication required");
                        authenticateProxyCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                authenticateProxyCBActionPerformed(e);
                            }
                        });

                        //---- jLabel29 ----
                        jLabel29.setText("Password");

                        //---- proxyPasswordField ----
                        proxyPasswordField.setText("jPasswordField1");
                        proxyPasswordField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyPasswordFieldFocusLost(e);
                            }
                        });

                        GroupLayout jPanel16Layout = new GroupLayout(jPanel16);
                        jPanel16.setLayout(jPanel16Layout);
                        jPanel16Layout.setHorizontalGroup(
                            jPanel16Layout.createParallelGroup()
                                .add(jPanel16Layout.createSequentialGroup()
                                    .add(jPanel16Layout.createParallelGroup()
                                        .add(jPanel16Layout.createSequentialGroup()
                                            .add(28, 28, 28)
                                            .add(jPanel16Layout.createParallelGroup()
                                                .add(jLabel28)
                                                .add(jLabel29))
                                            .add(37, 37, 37)
                                            .add(jPanel16Layout.createParallelGroup(GroupLayout.LEADING, false)
                                                .add(proxyPasswordField)
                                                .add(proxyUsernameField, GroupLayout.DEFAULT_SIZE, 261, Short.MAX_VALUE)))
                                        .add(jPanel16Layout.createSequentialGroup()
                                            .addContainerGap()
                                            .add(authenticateProxyCB)))
                                    .addContainerGap(354, Short.MAX_VALUE))
                        );
                        jPanel16Layout.setVerticalGroup(
                            jPanel16Layout.createParallelGroup()
                                .add(jPanel16Layout.createSequentialGroup()
                                    .add(17, 17, 17)
                                    .add(authenticateProxyCB)
                                    .addPreferredGap(LayoutStyle.RELATED)
                                    .add(jPanel16Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(jLabel28)
                                        .add(proxyUsernameField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(LayoutStyle.RELATED)
                                    .add(jPanel16Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(jLabel29)
                                        .add(proxyPasswordField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        );
                    }

                    //======== jPanel17 ========
                    {

                        //---- proxyHostField ----
                        proxyHostField.setText("jTextField1");
                        proxyHostField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                proxyHostFieldActionPerformed(e);
                            }
                        });
                        proxyHostField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyHostFieldFocusLost(e);
                            }
                        });

                        //---- proxyPortField ----
                        proxyPortField.setText("jTextField1");
                        proxyPortField.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                proxyPortFieldActionPerformed(e);
                            }
                        });
                        proxyPortField.addFocusListener(new FocusAdapter() {
                            @Override
                            public void focusLost(FocusEvent e) {
                                proxyPortFieldFocusLost(e);
                            }
                        });

                        //---- jLabel27 ----
                        jLabel27.setText("Proxy port");

                        //---- jLabel23 ----
                        jLabel23.setText("Proxy host");

                        //---- useProxyCB ----
                        useProxyCB.setText("Use proxy");
                        useProxyCB.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                useProxyCBActionPerformed(e);
                            }
                        });

                        GroupLayout jPanel17Layout = new GroupLayout(jPanel17);
                        jPanel17.setLayout(jPanel17Layout);
                        jPanel17Layout.setHorizontalGroup(
                            jPanel17Layout.createParallelGroup()
                                .add(jPanel17Layout.createSequentialGroup()
                                    .add(jPanel17Layout.createParallelGroup()
                                        .add(jPanel17Layout.createSequentialGroup()
                                            .addContainerGap()
                                            .add(jPanel17Layout.createParallelGroup()
                                                .add(jLabel27)
                                                .add(jLabel23))
                                            .add(28, 28, 28)
                                            .add(jPanel17Layout.createParallelGroup()
                                                .add(proxyPortField, GroupLayout.PREFERRED_SIZE, 108, GroupLayout.PREFERRED_SIZE)
                                                .add(proxyHostField, GroupLayout.PREFERRED_SIZE, 485, GroupLayout.PREFERRED_SIZE)))
                                        .add(jPanel17Layout.createSequentialGroup()
                                            .add(9, 9, 9)
                                            .add(useProxyCB)))
                                    .addContainerGap(21, Short.MAX_VALUE))
                        );
                        jPanel17Layout.setVerticalGroup(
                            jPanel17Layout.createParallelGroup()
                                .add(GroupLayout.TRAILING, jPanel17Layout.createSequentialGroup()
                                    .addContainerGap(29, Short.MAX_VALUE)
                                    .add(useProxyCB)
                                    .add(18, 18, 18)
                                    .add(jPanel17Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(jLabel23)
                                        .add(proxyHostField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(LayoutStyle.RELATED)
                                    .add(jPanel17Layout.createParallelGroup(GroupLayout.BASELINE)
                                        .add(jLabel27)
                                        .add(proxyPortField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                    .addContainerGap())
                        );
                    }

                    //---- label3 ----
                    label3.setText("<html>Note:  do not use these settings unless you receive error or warning messages about server connections.  On most systems the correct settings will be automatically copied from your web browser.");

                    //---- clearAllProxyButton ----
                    clearAllProxyButton.setText("Clear All");
                    clearAllProxyButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
                            clearAllProxyButtonActionPerformed(e);
                        }
                    });

                    GroupLayout jPanel15Layout = new GroupLayout(jPanel15);
                    jPanel15.setLayout(jPanel15Layout);
                    jPanel15Layout.setHorizontalGroup(
                        jPanel15Layout.createParallelGroup()
                            .add(jPanel15Layout.createSequentialGroup()
                                .addContainerGap()
                                .add(jPanel15Layout.createParallelGroup()
                                    .add(jPanel17, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .add(jPanel15Layout.createSequentialGroup()
                                        .add(jPanel16, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .add(33, 33, 33))
                                    .add(jPanel15Layout.createSequentialGroup()
                                        .add(label3, GroupLayout.PREFERRED_SIZE, 674, GroupLayout.PREFERRED_SIZE)
                                        .addContainerGap())))
                            .add(jPanel15Layout.createSequentialGroup()
                                .add(17, 17, 17)
                                .add(clearAllProxyButton)
                                .addContainerGap(667, Short.MAX_VALUE))
                    );
                    jPanel15Layout.setVerticalGroup(
                        jPanel15Layout.createParallelGroup()
                            .add(jPanel15Layout.createSequentialGroup()
                                .add(label3, GroupLayout.PREFERRED_SIZE, 82, GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(LayoutStyle.RELATED)
                                .add(jPanel17, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                .add(18, 18, 18)
                                .add(jPanel16, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(32, 32, 32)
                                .add(clearAllProxyButton)
                                .add(87, 87, 87))
                    );
                }
                proxyPanel.add(jPanel15);
            }
            tabbedPane.addTab("Proxy", proxyPanel);

        }
        contentPane.add(tabbedPane, BorderLayout.CENTER);

        //======== okCancelButtonPanel ========
        {

            //---- okButton ----
            okButton.setText("OK");
            okButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    okButtonActionPerformed(e);
                }
            });
            okCancelButtonPanel.add(okButton);

            //---- cancelButton ----
            cancelButton.setText("Cancel");
            cancelButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    cancelButtonActionPerformed(e);
                }
            });
            okCancelButtonPanel.add(cancelButton);
        }
        contentPane.add(okCancelButtonPanel, BorderLayout.SOUTH);
        pack();
        setLocationRelativeTo(getOwner());
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        canceled = true;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed

        if (inputValidated) {

            checkForProbeChanges();

            lastSelectedIndex = tabbedPane.getSelectedIndex();

            // Store the changed preferences
            prefMgr.putAll(updatedPreferenceMap);

            if (updatedPreferenceMap.containsKey(PreferenceManager.PORT_ENABLED) ||
                    updatedPreferenceMap.containsKey(PreferenceManager.PORT_NUMBER)) {
                CommandListener.halt();
                if (enablePortCB.isSelected()) {
                    CommandListener.start();
                }
            }

            checkForSAMChanges();

            // Overlays
            if (updateOverlays) {
                IGVMainFrame.getInstance().getTrackManager().resetOverlayTracks();
            }

            // Proxies
            if (proxySettingsChanged) {
                IGVHttpUtils.updateProxySettings();
            }

            updatedPreferenceMap.clear();

            IGVMainFrame.getInstance().repaint();
            setVisible(false);

        } else {
            resetValidation();
        }
    }

    private void expMapToLociCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToLociCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(expMapToGeneCB.isSelected()));
    }

    private void clearGenomeCacheButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearGenomeCacheButtonActionPerformed
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }

    private void editServerPropertiesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editServerPropertiesCBActionPerformed
        boolean edit = editServerPropertiesCB.isSelected();
        dataServerURLTextField.setEnabled(edit);
        genomeServerURLTextField.setEnabled(edit);
    }

    private void dataServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldFocusLost
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }

    private void dataServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldActionPerformed
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }

    private void genomeServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldFocusLost
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }

    private void genomeServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldActionPerformed
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }


    private void expandIconCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(PreferenceManager.SHOW_EXPAND_ICON, String.valueOf(expandIconCB.isSelected()));

    }


    private void insertSizeThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldFocusLost
        this.insertSizeThresholdFieldActionPerformed(null);
    }

    private void insertSizeThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldActionPerformed
        String insertThreshold = insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.INSERT_SIZE_THRESHOLD,
                    insertThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void mappingQualityThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldFocusLost
        mappingQualityThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_mappingQualityThresholdFieldFocusLost

    private void mappingQualityThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldActionPerformed
        String qualityThreshold = mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.QUALITY_THRESHOLD,
                    qualityThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage(
                    "BlastMapping quality threshold must be an integer.");
        }
    }//GEN-LAST:event_mappingQualityThresholdFieldActionPerformed

    private void samMaxLevelFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxLevelFieldFocusLost
        samMaxLevelFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxLevelFieldFocusLost

    private void samMaxLevelFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxLevelFieldActionPerformed
        String maxLevelString = samMaxLevelsField.getText().trim();
        try {
            Integer.parseInt(maxLevelString);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_LEVELS, maxLevelString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Maximum read depth must be an integer.");
        }
    }//GEN-LAST:event_samMaxLevelFieldActionPerformed

    private void samShadeMismatchedBaseCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShadeMismatchedBaseCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHADE_BASE_QUALITY,
                String.valueOf(samShadeMismatchedBaseCB.isSelected()));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());

    }//GEN-LAST:event_samShadeMismatchedBaseCBActionPerformed

    private void samFlagUnmappedPairCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samFlagUnmappedPairCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FLAG_UNMAPPED_PAIR,
                String.valueOf(samFlagUnmappedPairCB.isSelected()));
    }

    private void samShowDuplicatesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShowDuplicatesCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_DUPLICATES,
                String.valueOf(!samFilterDuplicatesCB.isSelected()));
    }

    private void showSoftClippedCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_SOFT_CLIPPED,
                String.valueOf(showSoftClippedCB.isSelected()));
    }


    private void samMaxWindowSizeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxWindowSizeFieldFocusLost
        String maxSAMWindowSize = samMaxWindowSizeField.getText().trim();
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE, maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }//GEN-LAST:event_samMaxWindowSizeFieldFocusLost

    private void samMaxWindowSizeFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String maxSAMWindowSize = String.valueOf(samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE, maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }

    private void chartDrawTrackNameCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.DRAW_TRACK_NAME,
                String.valueOf(chartDrawTrackNameCB.isSelected()));
    }

    private void autoscaleCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.AUTOSCALE, String.valueOf(autoscaleCB.isSelected()));
    }


    private void colorBordersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorBordersCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.COLOR_BORDERS,
                String.valueOf(colorBordersCB.isSelected()));
    }//GEN-LAST:event_colorBordersCBActionPerformed

    private void bottomBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bottomBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_BOTTOM_BORDER,
                String.valueOf(bottomBorderCB.isSelected()));
    }//GEN-LAST:event_bottomBorderCBActionPerformed

    private void topBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_TOP_BORDER,
                String.valueOf(topBorderCB.isSelected()));
    }//GEN-LAST:event_topBorderCBActionPerformed

    private void chooseOverlayColorsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseOverlayColorsButtonActionPerformed
        (new LegendDialog(IGVMainFrame.getInstance(), true)).setVisible(true);
    }//GEN-LAST:event_chooseOverlayColorsButtonActionPerformed

    private void colorOverlyCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorOverlyCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.COLOR_OVERLAY_KEY, String.valueOf(
                colorOverlyCB.isSelected()));
    }//GEN-LAST:event_colorOverlyCBActionPerformed

    private void displayTracksCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_displayTracksCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.DISPLAY_OVERLAY_TRACKS_KEY, String.valueOf(
                displayTracksCB.isSelected()));
        updateOverlays = true;
    }//GEN-LAST:event_displayTracksCBActionPerformed

    private void overlayTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_TRACKS_KEY, String.valueOf(
                overlayTrackCB.isSelected()));
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());

        updateOverlays = true;
    }//GEN-LAST:event_overlayTrackCBActionPerformed

    private void overlayAttributeTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldKeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldKeyTyped

    private void overlayAttributeTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldFocusLost
        String attributeName = String.valueOf(overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, attributeName);
        updateOverlays = true;
    }//GEN-LAST:event_overlayAttributeTextFieldFocusLost

    private void overlayAttributeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, String.valueOf(
                overlayAttributeTextField.getText()));
        updateOverlays = true;
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldActionPerformed

    private void defaultTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldFocusLost

    private void defaultTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldActionPerformed

    private void trackNameAttributeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldFocusLost
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldFocusLost

    private void trackNameAttributeFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldActionPerformed
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldActionPerformed

    private void defaultChartTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldFocusLost

    private void defaultChartTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldActionPerformed

    private void showAttributesDisplayCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showAttributesDisplayCheckBoxActionPerformed
        boolean state = ((JCheckBox) evt.getSource()).isSelected();
        updatedPreferenceMap.put(PreferenceManager.SHOW_ATTRIBUTE_VIEWS_KEY, String.valueOf(state));
        IGVMainFrame.getInstance().doShowAttributeDisplay(state);
    }//GEN-LAST:event_showAttributesDisplayCheckBoxActionPerformed

    private void joinSegmentsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_joinSegmentsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.JOIN_ADJACENT_SEGMENTS_KEY, String.valueOf(
                joinSegmentsCB.isSelected()));
    }//GEN-LAST:event_joinSegmentsCBActionPerformed

    private void combinePanelsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_combinePanelsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_SINGLE_TRACK_PANE_KEY, String.valueOf(
                combinePanelsCB.isSelected()));
    }//GEN-LAST:event_combinePanelsCBActionPerformed

    private void showMissingDataCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showMissingDataCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_MISSING_DATA_KEY, String.valueOf(
                showMissingDataCB.isSelected()));
    }//GEN-LAST:event_showMissingDataCBActionPerformed

    private void showRefSeqCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showRefSeqCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_REF_SEQ,
                String.valueOf(showRefSeqCB.isSelected()));

    }

    private void filterVendorFailedReadsCBActionPerformed(ActionEvent e) {
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FILTER_FAILED_READS,
                String.valueOf(filterFailedReadsCB.isSelected()));
    }


    private void samMinBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldActionPerformed
        String baseQuality = samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MIN, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }//GEN-LAST:event_samMinBaseQualityFieldActionPerformed

    private void samMinBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldFocusLost
        samMinBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMinBaseQualityFieldFocusLost

    private void samMaxBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldActionPerformed
        String baseQuality = samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MAX, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }

    }//GEN-LAST:event_samMaxBaseQualityFieldActionPerformed

    private void samMaxBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldFocusLost
        samMaxBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxBaseQualityFieldFocusLost

    private void expMapToGeneCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToGeneCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(expMapToGeneCB.isSelected()));

    }//GEN-LAST:event_expMapToGeneCBActionPerformed

    private void labelYAxisCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_labelYAxisCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.Y_AXIS, String.valueOf(labelYAxisCB.isSelected()));
    }//GEN-LAST:event_labelYAxisCBActionPerformed

    private void shadeCenterCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shadeCenterCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.SHADE_CENTER, String.valueOf(shadeCenterCB.isSelected()));

    }//GEN-LAST:event_shadeCenterCBActionPerformed

    private void showCovTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showCovTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.SHOW_COV_TRACK, String.valueOf(showCovTrackCB.isSelected()));
    }//GEN-LAST:event_showCovTrackCBActionPerformed

    private void filterCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.FILTER_ALIGNMENTS, String.valueOf(filterCB.isSelected()));
        filterURL.setEnabled(filterCB.isSelected());
    }//GEN-LAST:event_filterCBActionPerformed

    private void filterURLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterURLActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FILTER_URL,
                String.valueOf(filterURL.getText()));

    }//GEN-LAST:event_filterURLActionPerformed

    private void filterURLFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_filterURLFocusLost
        filterURLActionPerformed(null);
    }//GEN-LAST:event_filterURLFocusLost

    private void portFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_portFieldActionPerformed
        String portString = portField.getText().trim();
        try {
            Integer.parseInt(portString);
            updatedPreferenceMap.put(PreferenceManager.PORT_NUMBER, portString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Port must be an integer.");
        }
    }//GEN-LAST:event_portFieldActionPerformed

    private void portFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_portFieldFocusLost
        portFieldActionPerformed(null);
    }//GEN-LAST:event_portFieldFocusLost

    private void enablePortCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enablePortCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PORT_ENABLED, String.valueOf(enablePortCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }//GEN-LAST:event_enablePortCBActionPerformed

    private void expandCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expandCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.EXPAND_FEAUTRE_TRACKS,
                String.valueOf(expandCB.isSelected()));
    }//GEN-LAST:event_expandCBActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        genomeServerURLTextField.setEnabled(true);
        genomeServerURLTextField.setText(PreferenceManager.DEFAULT_GENOME_SERVER_URL);
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, null);
        dataServerURLTextField.setEnabled(true);
        dataServerURLTextField.setText(PreferenceManager.DEFAULT_DATA_SERVER_URL);
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, null);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void searchZoomCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchZoomCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SEARCH_ZOOM, String.valueOf(searchZoomCB.isSelected()));
    }//GEN-LAST:event_searchZoomCBActionPerformed

    private void useByteRangeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useByteRangeCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.USE_BYTE_RANGE, String.valueOf(useByteRangeCB.isSelected()));
    }//GEN-LAST:event_useByteRangeCBActionPerformed

    private void showDatarangeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showDatarangeCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.SHOW_DATA_RANGE, String.valueOf(showDatarangeCB.isSelected()));
    }//GEN-LAST:event_showDatarangeCBActionPerformed

    private void showDatarangeCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_showDatarangeCBFocusLost
        showDatarangeCBActionPerformed(null);
    }//GEN-LAST:event_showDatarangeCBFocusLost

    private void snpThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String snpThreshold = snpThresholdField.getText().trim();
        try {
            Double.parseDouble(snpThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.ALLELE_THRESHOLD, snpThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Allele frequency threshold must be a number.");
        }
    }

    private void snpThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {
        snpThresholdFieldActionPerformed(null);
    }

    private void normalizeCoverageCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.NORMALIZE_COVERAGE, String.valueOf(normalizeCoverageCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }


    // Proxy settings

    private void useProxyCBActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.USE_PROXY, String.valueOf(useProxy));

    }


    private void authenticateProxyCBActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.PROXY_AUTHENTICATE, String.valueOf(authenticateProxy));

    }


    // Host

    private void proxyHostFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyHostFieldActionPerformed(null);
    }

    private void proxyHostFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        updatedPreferenceMap.put(PreferenceManager.PROXY_HOST, proxyHostField.getText());
    }

    private void proxyPortFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyPortFieldActionPerformed(null);
    }

    private void proxyPortFieldActionPerformed(java.awt.event.ActionEvent evt) {
        try {
            if (proxyPortField.getText().trim().length() > 0) {
                Integer.parseInt(proxyPortField.getText());
            }
            proxySettingsChanged = true;
            updatedPreferenceMap.put(PreferenceManager.PROXY_PORT, proxyPortField.getText());

        }
        catch (NumberFormatException e) {
            MessageUtils.showMessage("Proxy port must be an integer.");
        }
    }

    // Username

    private void proxyUsernameFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyUsernameFieldActionPerformed(null);
    }

    private void proxyUsernameFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        String user = proxyUsernameField.getText();
        updatedPreferenceMap.put(PreferenceManager.PROXY_USER, user);

    }

    // Password

    private void proxyPasswordFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyPasswordFieldActionPerformed(null);
    }

    private void proxyPasswordFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        String pw = proxyPasswordField.getText();
        String pwEncoded = Utilities.base64Encode(pw);
        updatedPreferenceMap.put(PreferenceManager.PROXY_PW, pwEncoded);

    }


    private void updateProxyState(boolean useProxy, boolean authenticateProxy) {
        proxyHostField.setEnabled(useProxy);
        proxyPortField.setEnabled(useProxy);
        proxyUsernameField.setEnabled(useProxy && authenticateProxy);
        proxyPasswordField.setEnabled(useProxy && authenticateProxy);
    }

    private void resetValidation() {
        // Assume valid input until proven otherwise
        inputValidated = true;
    }

    /*
     *    Object selection = geneMappingFile.getSelectedItem();
    String filename = (selection == null ? null : selection.toString().trim());
    updatedPreferenceMap.put(
    PreferenceManager.USER_PROBE_MAP_KEY,
    filename);
     * */

    private void initValues() {
        combinePanelsCB.setSelected(prefMgr.getShowSingleTrackPane());
        //drawExonNumbersCB.setSelected(preferenceManager.getDrawExonNumbers());
        defaultChartTrackHeightField.setText(String.valueOf(prefMgr.getDefaultChartTrackHeight()));
        defaultTrackHeightField.setText(String.valueOf(prefMgr.getDefaultTrackHeight()));
        displayTracksCB.setSelected(prefMgr.getDiplayOverlayTracks());
        overlayAttributeTextField.setText(prefMgr.getOverlayAttribute());
        overlayTrackCB.setSelected(prefMgr.getOverlayTracks());
        showMissingDataCB.setSelected(prefMgr.getShowMissingData());
        joinSegmentsCB.setSelected(prefMgr.isJoinAdjacentSegments());
        colorOverlyCB.setSelected(prefMgr.getColorOverlay());
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());

        enablePortCB.setSelected(prefMgr.isPortEnabled());
        portField.setText(String.valueOf(prefMgr.getPortNumber()));
        portField.setEnabled(enablePortCB.isSelected());

        expandCB.setSelected(prefMgr.isExpandTracks());
        searchZoomCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.SEARCH_ZOOM, true));

        useByteRangeCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.USE_BYTE_RANGE, true));
        showAttributesDisplayCheckBox.setSelected(prefMgr.getShowAttributeView());
        trackNameAttributeField.setText(prefMgr.getTrackAttributeName());
        PreferenceManager prefManager = PreferenceManager.getInstance();
        genomeServerURLTextField.setText(prefManager.getGenomeListURL());
        dataServerURLTextField.setText(prefMgr.getDataServerURL());

        // Chart panel
        PreferenceManager.ChartPreferences cp = prefManager.getChartPreferences();
        topBorderCB.setSelected(cp.isDrawTopBorder());
        bottomBorderCB.setSelected(cp.isDrawBottomBorder());
        colorBordersCB.setSelected(cp.isColorBorders());
        chartDrawTrackNameCB.setSelected(cp.isDrawTrackName());
        autoscaleCB.setSelected(cp.isAutoscale());
        showDatarangeCB.setSelected(cp.isShowDataRange());
        labelYAxisCB.setSelected(cp.isDrawAxis());

        PreferenceManager.SAMPreferences samPrefs = prefManager.getSAMPreferences();
        samMaxWindowSizeField.setText(String.valueOf(samPrefs.getMaxVisibleRange()));
        samMaxLevelsField.setText(String.valueOf(samPrefs.getMaxLevels()));
        mappingQualityThresholdField.setText((String.valueOf(samPrefs.getQualityThreshold())));
        insertSizeThresholdField.setText((String.valueOf(samPrefs.getInsertSizeThreshold())));
        snpThresholdField.setText((String.valueOf(samPrefs.getAlleleFreqThreshold())));
        //samShowZeroQualityCB.setSelected(samPrefs.isShowZeroQuality());
        samFilterDuplicatesCB.setSelected(!samPrefs.isShowDuplicates());
        filterFailedReadsCB.setSelected(samPrefs.isFilterFailedReads());
        showSoftClippedCB.setSelected(samPrefs.isShowSoftClipped());
        samFlagUnmappedPairCB.setSelected(samPrefs.isFlagUnmappedPair());
        showRefSeqCB.setSelected(samPrefs.isShowRefSequence());
        samShadeMismatchedBaseCB.setSelected(samPrefs.isShadeBaseQuality());
        samMinBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMin())));
        samMaxBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMax())));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        shadeCenterCB.setSelected(samPrefs.isShadeCenter());
        showCovTrackCB.setSelected(samPrefs.isShowCoverageTrack());
        filterCB.setSelected(samPrefs.isFilterAlignments());
        if (samPrefs.getFilterURL() != null) {
            filterURL.setText(samPrefs.getFilterURL());
        }


        expMapToGeneCB.setSelected(prefMgr.isMapProbesToGenes());
        expMapToLociCB.setSelected(!prefMgr.isMapProbesToGenes());

        normalizeCoverageCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.NORMALIZE_COVERAGE, false));

        expandIconCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.SHOW_EXPAND_ICON, true));

        boolean useProxy = prefMgr.getBooleanPreference(PreferenceManager.USE_PROXY, false);
        useProxyCB.setSelected(useProxy);

        boolean authenticateProxy = prefMgr.getBooleanPreference(PreferenceManager.PROXY_AUTHENTICATE, false);
        authenticateProxyCB.setSelected(authenticateProxy);

        proxyHostField.setText(prefMgr.get(PreferenceManager.PROXY_HOST, ""));
        proxyPortField.setText(prefMgr.get(PreferenceManager.PROXY_PORT, ""));
        proxyUsernameField.setText(prefMgr.get(PreferenceManager.PROXY_USER, ""));
        String pwCoded = prefMgr.get(PreferenceManager.PROXY_PW, "");
        proxyPasswordField.setText(Utilities.base64Decode(pwCoded));

        updateProxyState(useProxy, authenticateProxy);
    }

    private void checkForSAMChanges() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            boolean reloadSAM = false;
            for (String key : SAM_PREFERENCE_KEYS) {
                if (updatedPreferenceMap.containsKey(key)) {
                    reloadSAM = true;
                    break;
                }
            }
            if (reloadSAM) {
                IGVMainFrame.getInstance().getTrackManager().reloadSAMTracks();
                IGVMainFrame.getInstance().repaint();
            }
        } catch (NumberFormatException numberFormatException) {
        } finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    private void checkForProbeChanges() {
        if (updatedPreferenceMap.containsKey(PreferenceManager.PROBE_MAPPING_KEY)) {
            ProbeToGeneMap.getInstance().clearProbeMappings();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                PreferencesEditor dialog = new PreferencesEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    //TODO move this to another class,  or resource bundle
    static String overlayText = "<html>These options control the treatment of mutation tracks.  " +
            "Mutation data may optionally<br>be overlayed on other tracks that have a matching attribute value " +
            "from the sample info <br>file. " +
            "This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in the" +
            "text field below.";

    public String getOverlayText() {
        return overlayText;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // Generated using JFormDesigner non-commercial license
    private JTabbedPane tabbedPane;
    private JPanel generalPanel;
    private JPanel jPanel10;
    private JLabel missingDataExplanation;
    private JCheckBox showMissingDataCB;
    private JCheckBox combinePanelsCB;
    private JCheckBox joinSegmentsCB;
    private JCheckBox showAttributesDisplayCheckBox;
    private JCheckBox searchZoomCB;
    private JLabel missingDataExplanation6;
    private JLabel missingDataExplanation7;
    private JPanel tracksPanel;
    private JPanel jPanel6;
    private JLabel jLabel5;
    private JTextField defaultChartTrackHeightField;
    private JLabel trackNameAttributeLabel;
    private JTextField trackNameAttributeField;
    private JLabel missingDataExplanation2;
    private JLabel jLabel8;
    private JTextField defaultTrackHeightField;
    private JLabel missingDataExplanation4;
    private JLabel missingDataExplanation5;
    private JLabel missingDataExplanation3;
    private JCheckBox expandCB;
    private JCheckBox normalizeCoverageCB;
    private JLabel missingDataExplanation8;
    private JCheckBox expandIconCB;
    private JPanel overlaysPanel;
    private JPanel jPanel5;
    private JLabel jLabel3;
    private JTextField overlayAttributeTextField;
    private JCheckBox overlayTrackCB;
    private JLabel jLabel2;
    private JCheckBox displayTracksCB;
    private JLabel jLabel4;
    private JCheckBox colorOverlyCB;
    private JideButton chooseOverlayColorsButton;
    private JPanel chartPanel;
    private JPanel jPanel4;
    private JCheckBox topBorderCB;
    private Label label1;
    private JCheckBox chartDrawTrackNameCB;
    private JCheckBox bottomBorderCB;
    private JLabel jLabel7;
    private JCheckBox colorBordersCB;
    private JCheckBox labelYAxisCB;
    private JCheckBox autoscaleCB;
    private JLabel jLabel9;
    private JCheckBox showDatarangeCB;
    private JPanel alignmentPanel;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JTextField samMaxLevelsField;
    private JTextField snpThresholdField;
    private JLabel jLabel11;
    private JLabel jLabel26;
    private JLabel jLabel17;
    private JLabel jLabel16;
    private JTextField mappingQualityThresholdField;
    private JLabel jLabel14;
    private JTextField insertSizeThresholdField;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel18;
    private JTextField samMaxWindowSizeField;
    private JLabel jLabel12;
    private JPanel jPanel12;
    private JTextField samMinBaseQualityField;
    private JCheckBox samShadeMismatchedBaseCB;
    private JTextField samMaxBaseQualityField;
    private JCheckBox showCovTrackCB;
    private JCheckBox samFilterDuplicatesCB;
    private JCheckBox showRefSeqCB;
    private JLabel jLabel19;
    private JCheckBox filterCB;
    private JTextField filterURL;
    private JCheckBox samFlagUnmappedPairCB;
    private JCheckBox shadeCenterCB;
    private JLabel jLabel10;
    private JPanel legendPanel;
    private JCheckBox filterFailedReadsCB;
    private JLabel label2;
    private JCheckBox showSoftClippedCB;
    private JPanel expressionPane;
    private JPanel jPanel8;
    private JRadioButton expMapToGeneCB;
    private JLabel jLabel24;
    private JRadioButton expMapToLociCB;
    private JLabel jLabel21;
    private JPanel advancedPanel;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JLabel jLabel1;
    private JTextField genomeServerURLTextField;
    private JLabel jLabel6;
    private JTextField dataServerURLTextField;
    private JCheckBox editServerPropertiesCB;
    private JButton clearGenomeCacheButton;
    private JButton jButton1;
    private JPanel jPanel7;
    private JCheckBox enablePortCB;
    private JTextField portField;
    private JLabel jLabel22;
    private JPanel jPanel9;
    private JCheckBox useByteRangeCB;
    private JLabel jLabel25;
    private JPanel proxyPanel;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JTextField proxyUsernameField;
    private JLabel jLabel28;
    private JCheckBox authenticateProxyCB;
    private JLabel jLabel29;
    private JPasswordField proxyPasswordField;
    private JPanel jPanel17;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JLabel jLabel27;
    private JLabel jLabel23;
    private JCheckBox useProxyCB;
    private JLabel label3;
    private JButton clearAllProxyButton;
    private ButtonPanel okCancelButtonPanel;
    private JButton okButton;
    private JButton cancelButton;
    // End of variables declaration//GEN-END:variables

    public boolean isCanceled() {
        return canceled;
    }


    /**
     * List of keys that affect the alignments loaded.  This list is used to trigger a reload, if required.
     * Not all alignment preferences need trigger a reload, this is a subset.
     */
    static java.util.List<String> SAM_PREFERENCE_KEYS = Arrays.asList(
            PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE,
            PreferenceManager.SAMPreferences.SHOW_ZERO_QUALITY,
            PreferenceManager.SAMPreferences.SHOW_DUPLICATES,
            PreferenceManager.SAMPreferences.SHOW_SOFT_CLIPPED,
            PreferenceManager.SAMPreferences.MAX_LEVELS,
            PreferenceManager.SAMPreferences.MAX_READS,
            PreferenceManager.SAMPreferences.ALLELE_THRESHOLD,
            PreferenceManager.SAMPreferences.QUALITY_THRESHOLD,
            PreferenceManager.SAMPreferences.FILTER_ALIGNMENTS,
            PreferenceManager.SAMPreferences.FILTER_URL,
            PreferenceManager.SAMPreferences.FILTER_FAILED_READS);
}
