/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMSequenceDictionary {
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceMap.get(name);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int index = 0;
        for (SAMSequenceRecord record : list) {
            record.setSequenceIndex(index++);
            if (this.mSequenceMap.put(record.getSequenceName(), record) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + record.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        if (this.mSequenceMap.containsKey(sequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sequenceRecord.getSequenceName());
        }
        sequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sequenceRecord);
        this.mSequenceMap.put(sequenceRecord.getSequenceName(), sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        SAMSequenceRecord record = this.mSequenceMap.get(sequenceName);
        if (record == null) {
            return -1;
        }
        return record.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMSequenceDictionary that = (SAMSequenceDictionary)o;
        return ((Object)this.mSequences).equals(that.mSequences);
    }

    public int hashCode() {
        return ((Object)this.mSequences).hashCode();
    }
}

