/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BAMIndexContent {
    private final int mReferenceSequence;
    private final BinList mBinList;
    private final BAMIndexMetaData mMetaData;
    private final LinearIndex mLinearIndex;

    BAMIndexContent(int referenceSequence, Bin[] bins, int numberOfBins, BAMIndexMetaData metaData, LinearIndex linearIndex) {
        this.mReferenceSequence = referenceSequence;
        this.mBinList = new BinList(bins, numberOfBins);
        this.mMetaData = metaData;
        this.mLinearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public boolean containsBin(Bin bin) {
        return this.mBinList.getBin(bin.getBinNumber()) != null;
    }

    public BinList getBins() {
        return this.mBinList;
    }

    int getNumberOfNonNullBins() {
        return this.mBinList.getNumberOfNonNullBins();
    }

    public BAMIndexMetaData getMetaData() {
        return this.mMetaData;
    }

    public List<Chunk> getAllChunks() {
        ArrayList<Chunk> allChunks = new ArrayList<Chunk>();
        for (Bin b : this.mBinList) {
            if (b.getChunkList() == null) continue;
            allChunks.addAll(b.getChunkList());
        }
        return Collections.unmodifiableList(allChunks);
    }

    public LinearIndex getLinearIndex() {
        return this.mLinearIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BinList
    implements Iterable<Bin> {
        private final Bin[] mBinArray;
        public final int numberOfNonNullBins;
        public final int maxBinNumber;

        BinList(Bin[] binArray, int numberOfNonNullBins) {
            this.mBinArray = binArray;
            this.numberOfNonNullBins = numberOfNonNullBins;
            this.maxBinNumber = this.mBinArray.length - 1;
        }

        Bin getBin(int binNumber) {
            if (binNumber > this.maxBinNumber) {
                return null;
            }
            return this.mBinArray[binNumber];
        }

        int getNumberOfNonNullBins() {
            return this.numberOfNonNullBins;
        }

        @Override
        public Iterator<Bin> iterator() {
            return new BinIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BinIterator
        implements Iterator<Bin> {
            private int nextBin = 0;

            @Override
            public boolean hasNext() {
                while (this.nextBin <= BinList.this.maxBinNumber) {
                    if (BinList.this.getBin(this.nextBin) != null) {
                        return true;
                    }
                    ++this.nextBin;
                }
                return false;
            }

            @Override
            public Bin next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("This BinIterator is currently empty");
                }
                Bin result = BinList.this.getBin(this.nextBin);
                ++this.nextBin;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from a bin iterator");
            }
        }
    }
}

