/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.ui;

import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import xtools.browser.api.ui.ChooserWindow;
import xtools.browser.api.ui.GeneSetTabbedChooserPanel;

public class GeneSetFieldPlusChooser
extends JPanel
implements GFieldPlusChooser {
    private JTextField tfEntry = new JTextField(40);
    private JButton bEntry = new JButton(GuiHelper.ICON_ELLIPSIS);
    private ChooserWindow fWindow;

    public GeneSetFieldPlusChooser(boolean addDefaultActionListener, int selMode) {
        GeneSetTabbedChooserPanel chooser = new GeneSetTabbedChooserPanel(selMode);
        this.fWindow = new ChooserWindow(chooser);
        if (addDefaultActionListener) {
            this.init();
        } else {
            this.jbInit();
        }
    }

    public void setCustomActionListener(ActionListener customActionListener) {
        this.bEntry.addActionListener(customActionListener);
    }

    private void init() {
        this.jbInit();
        this.bEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] sels = GeneSetFieldPlusChooser.this.fWindow.show();
                GeneSetFieldPlusChooser.this.format(sels);
            }
        });
    }

    public Object[] showMeDirectly() {
        Object[] sels = this.fWindow.show();
        return sels;
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.tfEntry.setEditable(true);
        this.add((Component)this.tfEntry, "Center");
        this.add((Component)this.bEntry, "East");
    }

    private void format(Object[] sels) {
        if (sels == null) {
            this.tfEntry.setText("");
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < sels.length; ++i) {
            if (sels[i] == null) continue;
            buf.append(sels[i].toString().trim());
            if (i == sels.length - 1) continue;
            buf.append(',');
        }
        this.tfEntry.setText(buf.toString());
    }

    public String getText() {
        return this.tfEntry.getText();
    }

    public void setText(String text) {
        this.tfEntry.setText(text);
    }

    public JTextField getTextField() {
        return this.tfEntry;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.setText(null);
        } else {
            this.setText(obj.toString());
        }
    }
}

