/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.param;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.alg.ComparatorFactory;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.xbench.core.ObjectBindery;
import edu.mit.broad.msigdb_browser.xbench.prefs.XPreferencesFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import org.genepattern.browser.uiutil.FTPFile;
import org.genepattern.browser.uiutil.FTPList;
import xapps.browser.gsea.GseaWebResources;
import xtools.browser.api.param.AbstractParam;
import xtools.browser.api.param.ChooserHelper;
import xtools.browser.api.param.ParamHelper;
import xtools.browser.api.param.WChipChooserUI;
import xtools.browser.api.ui.NamedModel;

abstract class WChipChooserAbstractParam
extends AbstractParam {
    private boolean fMultipleAllowed = true;
    private MyPobActionListener fAl;
    protected WChipChooserUI fChooser;

    WChipChooserAbstractParam(String name, String nameEnglish, String desc, boolean reqd, boolean multipleAlllowed) {
        super(name, nameEnglish, Chip[].class, desc, (Object)new Chip[0], (Object[])new Chip[0], reqd);
        this.fMultipleAllowed = multipleAlllowed;
    }

    protected Object[] _getObjects() throws Exception {
        Object[] objs;
        Object val = this.getValue();
        if (val instanceof String) {
            String[] paths = WChipChooserAbstractParam._parse(val.toString());
            objs = VdbRuntimeResources.getChips(paths);
        } else {
            objs = val instanceof Object[] ? (Object[])val : new Object[]{val};
        }
        return objs;
    }

    protected Chip[] _getChips() throws Exception {
        Object[] objs = this._getObjects();
        if (this.isReqd() && objs.length == 0) {
            throw new IllegalArgumentException("Must specify Chip parameters, got: " + objs.length);
        }
        Chip[] chips = new Chip[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            chips[i] = (Chip)objs[i];
        }
        return chips;
    }

    private static String[] _parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set vals = ParseUtils.string2stringsSet(s, ",", false);
        System.out.println("to parse>" + s + "< got: " + vals);
        HashSet<String> use = new HashSet<String>();
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.length() <= 0) continue;
            use.add(key);
        }
        return use.toArray(new String[use.size()]);
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.log.debug(vals[i].getClass());
            if (vals[i] instanceof PersistentObject) {
                String p = ParserFactory.getCache().getSourcePath(vals[i]);
                buf.append(p);
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    protected ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new MyPobActionListener(this.fMultipleAllowed);
            this.fAl.setChooser(this.fChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return this.format(objs);
        }
        return this.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new WChipChooserUI(false);
            this.fChooser.setCustomActionListener(this.getActionListener());
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fChooser.setText(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    static class ChipListRenderer
    extends DefaultListCellRenderer {
        static Icon affy_icon = JarResources.getIcon("Chip16.png");

        ChipListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            if (value instanceof FTPFile) {
                str = ((FTPFile)value).getName();
                this.setText(str);
            } else {
                str = value.toString();
            }
            if (!isSelected) {
                if (VdbRuntimeResources.isChipAffy_hacky(str)) {
                    this.setForeground(Color.BLUE);
                    this.setIcon(affy_icon);
                } else if (VdbRuntimeResources.isChipGeneSymbol(str)) {
                    this.setForeground(Color.MAGENTA);
                    this.setIcon(null);
                } else if (VdbRuntimeResources.isChipSeqAccession(str)) {
                    this.setForeground(Color.MAGENTA);
                    this.setIcon(null);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setIcon(null);
                }
            }
            return this;
        }
    }

    private static class MyPobActionListener
    implements ActionListener {
        private boolean fMultipleAllowed;
        private WChipChooserUI fChooser;
        private DefaultListCellRenderer rend = new ChipListRenderer();

        public MyPobActionListener(boolean multipleAllowed) {
            this.fMultipleAllowed = multipleAllowed;
        }

        public void setChooser(WChipChooserUI chooser) {
            this.fChooser = chooser;
        }

        private ListModel createFTPModel() {
            if (!XPreferencesFactory.kOnlineMode.getBoolean()) {
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Offline mode");
                model.addElement("Change this in Menu=>Preferences");
                model.addElement("Choose chips from other tabs");
                return model;
            }
            try {
                FTPList ftpList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword(), GseaWebResources.getGseaFTPServerChipDir(), new ComparatorFactory.ChipNameComparator());
                ftpList.quit();
                return ftpList.getModel();
            }
            catch (Exception e) {
                AbstractParam.klog.error((Object)e);
                DefaultListModel<String> model = new DefaultListModel<String>();
                model.addElement("Error listing Broad website");
                model.addElement(e.getMessage());
                model.addElement("Choose chips from other tabs");
                return model;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fChooser == null) {
                return;
            }
            int selmode = !this.fMultipleAllowed ? 0 : 2;
            NamedModel chipsFromFTPModel = new NamedModel("Chips (from website)", this.createFTPModel());
            NamedModel[] models = new NamedModel[]{chipsFromFTPModel, new NamedModel("Chips (local .chip)", ObjectBindery.getModel(Chip.class))};
            Object[] sels = this.fChooser.getJListWindow().showDirectlyWithModels(models, selmode, this.rend);
            if (sels != null && sels.length != 0) {
                String[] paths = new String[sels.length];
                for (int i = 0; i < sels.length; ++i) {
                    paths[i] = sels[i] instanceof FTPFile ? ((FTPFile)sels[i]).getPath() : ParserFactory.getCache().getSourcePath(sels[i]);
                }
                String str = ChooserHelper.formatPob(sels);
                this.fChooser.setText(str);
            }
        }
    }
}

