/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.param;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import xtools.browser.api.param.Param;
import xtools.browser.api.param.ParamSet;
import xtools.browser.api.param.ReportLabelParam;

public class ToolParamSet
implements ParamSet {
    private final List fReqdParams;
    private final List fOptParams;
    private final Logger log = Logger.getLogger(ToolParamSet.class);

    public ToolParamSet() {
        this.fReqdParams = new ArrayList();
        this.fOptParams = new ArrayList();
    }

    public void addParam(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("Null param not allowed");
        }
        this.checkUniqueness(param);
        if (param.isReqd()) {
            this.fReqdParams.add(param);
        } else {
            this.fOptParams.add(param);
        }
    }

    public int getNumParams() {
        return this.fReqdParams.size() + this.fOptParams.size();
    }

    public Param getParam(int pos) {
        if (pos < this.fReqdParams.size()) {
            return (Param)this.fReqdParams.get(pos);
        }
        return (Param)this.fOptParams.get(pos - this.fReqdParams.size());
    }

    @Override
    public Properties toProperties() {
        Properties props = new Properties();
        for (int i = 0; i < this.getNumParams(); ++i) {
            Param param = this.getParam(i);
            String s = param.getValueStringRepresentation(true);
            if (s == null || (s = s.trim()).length() <= 0) continue;
            props.setProperty(param.getName(), s);
        }
        return props;
    }

    public boolean isRequiredAllSet() throws RuntimeException {
        for (int i = 0; i < this.fReqdParams.size(); ++i) {
            Param param = (Param)this.fReqdParams.get(i);
            if (param.isSpecified() || param.getDefault() != null) continue;
            return false;
        }
        return true;
    }

    public Param[] getParams() {
        int i;
        ArrayList all = new ArrayList();
        for (i = 0; i < this.fReqdParams.size(); ++i) {
            all.add(this.fReqdParams.get(i));
        }
        for (i = 0; i < this.fOptParams.size(); ++i) {
            all.add(this.fOptParams.get(i));
        }
        return all.toArray(new Param[all.size()]);
    }

    @Override
    public ReportLabelParam getReportLabelParam() {
        for (int i = 0; i < this.getNumParams(); ++i) {
            Param p = this.getParam(i);
            if (!(p instanceof ReportLabelParam)) continue;
            return (ReportLabelParam)p;
        }
        return null;
    }

    private void checkUniqueness(Param param) {
        if (param == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        if (this.fOptParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param + " # params: " + this.getNumParams() + " in the opt param list");
        }
        if (this.fReqdParams.contains(param)) {
            throw new RuntimeException("Duplicated param in declarations - already have param: " + param.getName() + " # params: " + this.getNumParams() + " in the reqd param list");
        }
    }
}

