/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.param;

import edu.mit.broad.msigdb_browser.genome.swing.fields.GComboBoxField;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldUtils;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import xtools.browser.api.param.Param;

public class ParamHelper {
    private ParamHelper() {
    }

    public static void addDocumentListener(final JTextField tf, final Param param) {
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                param.setValue(tf.getText());
                if (param.isFileBased()) {
                    tf.setForeground(GFieldUtils.getFileFieldColor(tf.getText()));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                param.setValue(tf.getText());
                if (param.isFileBased()) {
                    tf.setForeground(GFieldUtils.getFileFieldColor(tf.getText()));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    protected static GComboBoxField createActionListenerBoundHintsComboBox(boolean editable, ActionListener al, Param param) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(param.getHints());
        if (param.getValue() != null && model.getIndexOf(param.getValue()) == -1) {
            model.addElement(param.getValue());
        }
        JComboBox<Object> cb = new JComboBox<Object>(model);
        cb.setEditable(editable);
        cb.setSelectedItem(param.getValue());
        cb.addActionListener(al);
        return new GComboBoxField(cb);
    }

    protected static void safeSelectFirst(JComboBox cb) {
        if (cb.getModel().getSize() > 0) {
            cb.setSelectedIndex(0);
        }
    }

    protected static void safeSelectValueDefaultOrNone(JComboBox cb, Param param) {
        Object t = param.getValue();
        if (t == null) {
            t = param.getDefault();
        }
        if (t != null) {
            cb.setSelectedItem(t);
        }
    }

    protected static void safeSelectValueDefaultByString(JComboBox cb, Param param) {
        Object sel = ParamHelper.getIfHasValue(param.getValue(), cb);
        if (sel == null) {
            sel = param.getDefault();
        }
        if (sel == null) {
            return;
        }
        String sels = sel.toString();
        for (int i = 0; i < cb.getModel().getSize(); ++i) {
            if (!cb.getModel().getElementAt(i).toString().equals(sels)) continue;
            cb.setSelectedIndex(i);
            return;
        }
        ParamHelper.safeSelectFirst(cb);
    }

    private static Object getIfHasValue(Object val, JComboBox cb) {
        if (val == null) {
            return null;
        }
        String vals = val.toString();
        for (int i = 0; i < cb.getModel().getSize(); ++i) {
            if (!cb.getModel().getElementAt(i).toString().equals(vals)) continue;
            return val;
        }
        return null;
    }
}

