/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.param;

import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.GenesOfInterest;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.DataFormat;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtools.browser.api.param.AbstractObjectChooserParam;
import xtools.browser.api.param.ChooserHelper;
import xtools.browser.api.param.ParamHelper;
import xtools.browser.api.ui.GeneSetFieldPlusChooser;

public class GeneSetMultiChooserParam
extends AbstractObjectChooserParam {
    private MyPobActionListener fAl;
    private GeneSetFieldPlusChooser fPlusChooser;

    public GeneSetMultiChooserParam(String name, String nameEnglish, String desc) {
        super(name, nameEnglish, GeneSet[].class, desc, (Object[])new GeneSet[0], (Object[])new GeneSet[0], false);
    }

    public GeneSetMultiChooserParam() {
        this("grp", "Gene set", "GeneSet (grp file; only 1 allowed)");
    }

    public GeneSet[] getGeneSets() throws Exception {
        Object[] objs = this._getObjects();
        if (this.isReqd() && objs.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameter: " + this.getName());
        }
        ArrayList<Object> gsets = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof GeneSetMatrix) {
                gsets.addAll(((GeneSetMatrix)objs[i]).getGeneSetsL());
                continue;
            }
            if (objs[i] instanceof GeneSet) {
                gsets.add(objs[i]);
                continue;
            }
            if (objs[i] instanceof Chip) {
                gsets.add(((Chip)objs[i]).getProbeNamesAsGeneSet());
                continue;
            }
            if (objs[i] instanceof GenesOfInterest) {
                gsets.add(((GenesOfInterest)objs[i]).getAsOneGeneSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + objs[i]);
        }
        return gsets.toArray(new GeneSet[gsets.size()]);
    }

    public GeneSet getGeneSetCombo() throws Exception {
        GeneSet[] gsets = this.getGeneSets();
        HashSet all = new HashSet();
        for (int i = 0; i < gsets.length; ++i) {
            all.addAll(gsets[i].getMembersS());
        }
        return new FSet("combo", all);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String[]) {
            this.setValue((String[])value);
        } else if (value instanceof String) {
            super.setValue((String)value);
        } else {
            super.setValue(value);
        }
    }

    @Override
    public void setValue(String[] paths) {
        try {
            PersistentObject[] pobs = new PersistentObject[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                File file = new File(paths[i]);
                PersistentObject pob = ParserFactory.read(file, true);
                if (!DataFormat.isCompatibleRepresentationClass(pob, GeneSet.class)) {
                    throw new RuntimeException("Unexpected parsed value: " + pob + " class: " + pob.getClass() + " from file: " + file + " expecting: " + this.getTypes());
                }
                pobs[i] = pob;
            }
            super.setValue(pobs);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Object[] _getObjects() throws Exception {
        Object[] objs;
        Object val = this.getValue();
        if (val instanceof String) {
            String[] paths = GeneSetMultiChooserParam._parse(val.toString());
            objs = new Object[paths.length];
            for (int p = 0; p < paths.length; ++p) {
                objs[p] = AuxUtils.isAux(paths[p]) ? ParserFactory.readGeneSet(new File(paths[p])) : ParserFactory.read(new File(paths[p]), true);
            }
        } else {
            objs = val instanceof Object[] ? (Object[])val : new Object[]{val};
        }
        return objs;
    }

    private static String[] _parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set vals = ParseUtils.string2stringsSet(s, ",", false);
        System.out.println("to parse>" + s + "< got: " + vals);
        HashSet<String> use = new HashSet<String>();
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.length() <= 0) continue;
            use.add(key);
        }
        return use.toArray(new String[use.size()]);
    }

    protected static String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            if (vals[i] instanceof PersistentObject) {
                String p = ParserFactory.getCache().getSourcePath(vals[i]);
                buf.append(p);
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    protected ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new MyPobActionListener(true);
            this.fAl.setChooser(this.fPlusChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return GeneSetMultiChooserParam.format(objs);
        }
        return GeneSetMultiChooserParam.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fPlusChooser == null) {
            this.fPlusChooser = new GeneSetFieldPlusChooser(false, 2);
            this.fPlusChooser.setCustomActionListener(this.getActionListener());
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = GeneSetMultiChooserParam.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fPlusChooser.setText(text);
            ParamHelper.addDocumentListener(this.fPlusChooser.getTextField(), this);
        }
        return this.fPlusChooser;
    }

    private static class MyPobActionListener
    implements ActionListener {
        private boolean fMultipleAllowed;
        private GeneSetFieldPlusChooser fFieldPlusChooser;

        public MyPobActionListener(boolean multipleAllowed) {
            this.fMultipleAllowed = multipleAllowed;
        }

        public void setChooser(GeneSetFieldPlusChooser plusChooser) {
            this.fFieldPlusChooser = plusChooser;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fFieldPlusChooser == null) {
                return;
            }
            int selmode = !this.fMultipleAllowed ? 0 : 2;
            Object[] sels = this.fFieldPlusChooser.showMeDirectly();
            if (sels != null && sels.length != 0) {
                String[] paths = new String[sels.length];
                for (int i = 0; i < sels.length; ++i) {
                    paths[i] = ParserFactory.getCache().getSourcePath(sels[i]);
                }
                String str = ChooserHelper.formatPob(sels);
                this.fFieldPlusChooser.setText(str);
            }
        }
    }
}

