/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.param;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.swing.choosers.GFileFieldPlusChooser;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import java.io.File;
import java.net.URL;
import xtools.browser.api.param.AbstractParam;
import xtools.browser.api.param.ParamHelper;

public class FileParam
extends AbstractParam {
    private GFileFieldPlusChooser fChooser;

    public FileParam(String name, String nameEnglish, boolean reqd) {
        super(name, nameEnglish, File.class, "Path to data file", (Object[])new File[0], reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof File) {
            super.setValue(value);
        } else if (value instanceof String) {
            this.setValue(value.toString());
        } else if (value instanceof URL) {
            this.setValue(value.toString());
        } else {
            throw new IllegalArgumentException("Invalid type, only File and String accepted. Specified: " + value + " class: " + value.getClass());
        }
    }

    public void setValue(File file) {
        super.setValue(file);
    }

    public void setValue(String path) {
        super.setValue(path);
    }

    public void setValue_url(String filepath) {
        super.setValue(filepath);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof URL) {
            return val.toString();
        }
        if (val instanceof File) {
            File file = (File)this.getValue();
            if (full) {
                return file.getAbsolutePath();
            }
            return file.getName();
        }
        if (NamingConventions.isURL(val.toString())) {
            return val.toString();
        }
        return val.toString();
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GFileFieldPlusChooser();
            if (this.getValue() != null) {
                this.fChooser.setValue(this.getValue());
            } else {
                this.fChooser.setValue(this.getDefault());
            }
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }
}

