/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.gsea;

import edu.mit.broad.msigdb_browser.genome.Conf;
import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.TraceUtils;
import edu.mit.broad.msigdb_browser.xbench.core.api.VdbManager;
import edu.mit.broad.msigdb_browser.xbench.prefs.XPreferencesFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class VdbManagerForGsea
implements VdbManager {
    private String fCacheDate;
    private static final Logger klog = Logger.getLogger(VdbManagerForGsea.class);

    public VdbManagerForGsea(String buildDate) {
        this.fCacheDate = buildDate;
    }

    @Override
    public File getRuntimeHomeDir() {
        return XPreferencesFactory.kAppRuntimeHomeDir;
    }

    public File getTmpDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "tmp"));
    }

    public File getReportsCacheDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "reports_cache_" + this.fCacheDate));
    }

    @Override
    public File getDatabasesDir() {
        return VdbManagerForGsea._mkdir(new File(this.getRuntimeHomeDir(), "databases"));
    }

    @Override
    public File getDefaultOutputDir() {
        File out = VdbManagerForGsea._mkdir(XPreferencesFactory.kDefaultReportsOutputDir.getDir(false));
        String dn = NamingConventions.createNiceEnglishDate_for_dirs();
        return VdbManagerForGsea._mkdir(new File(out, dn));
    }

    private static File _mkdir(File dir) {
        if (!dir.exists()) {
            boolean made = dir.mkdir();
            if (!made) {
                if (Conf.isDebugMode()) {
                    TraceUtils.showTrace();
                }
                klog.fatal((Object)("Could not make dir: " + dir));
            } else {
                klog.info((Object)("Made Vdb dir: " + dir));
            }
        }
        return dir;
    }
}

