/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.gsea;

import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;

public class GseaWebResources {
    private static final String GSEA_FTP_SERVER = "ftp.broadinstitute.org";
    private static final String GSEA_FTP_SERVER_USERNAME = "anonymous";
    private static final String GSEA_FTP_SERVER_PASSWORD = "gsea@broadinstitute.org";
    private static final String GSEA_FTP_SERVER_BASE_DIR = "/pub/gsea";
    private static final String GSEA_FTP_SERVER_CHIPFILES_SUB_DIR = "annotations_versioned";
    private static final String GSEA_FTP_SERVER_MSIGDB_FILE_CURRENT = "msigdb_v7.2.xml";
    private static final String GSEA_FTP_SERVER_XML_SUB_DIR = "/xml";

    public static String getGseaFTPServer() {
        return GSEA_FTP_SERVER;
    }

    public static String getGseaFTPServerUserName() {
        return GSEA_FTP_SERVER_USERNAME;
    }

    public static String getGseaFTPServerPassword() {
        return GSEA_FTP_SERVER_PASSWORD;
    }

    public static String getFTPBase() {
        return "ftp://ftp.broadinstitute.org/pub/gsea";
    }

    public static String getGseaFTPServerChipDir() {
        return "/pub/gsea/annotations_versioned";
    }

    public static String getGseaFTPServerXMLDir() {
        return GseaWebResources.getFTPBase() + GSEA_FTP_SERVER_XML_SUB_DIR;
    }

    public static String getMSigDB_current_xml_fileName() {
        return GSEA_FTP_SERVER_MSIGDB_FILE_CURRENT;
    }

    public static String getGseaBaseURL() {
        return "http://www.gsea-msigdb.org/gsea";
    }

    public static String getGseaURLDisplayName() {
        return "www.gsea-msigdb.org/gsea";
    }

    public static String getGseaHelpURL() {
        return GseaWebResources.getGseaBaseURL() + "/wiki";
    }

    public static String getGseaContactURL() {
        return GseaWebResources.getGseaBaseURL() + "/contact.jsp";
    }

    public static String getGseaDataFormatsHelpURL() {
        return GseaWebResources.getGseaBaseURL() + "/wiki/index.php/Data_formats";
    }

    public static String getGeneSetURL(String gsetName) {
        gsetName = AuxUtils.getAuxNameOnlyNoHash(gsetName);
        return GseaWebResources.getGseaBaseURL() + "/msigdb/cards/" + gsetName + ".html";
    }

    public static String getPubMedURL(String pmid) {
        return "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&dopt=Citation&list_uids=" + pmid;
    }
}

