/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.gsea;

import com.jgoodies.looks.HeaderStyle;
import com.jidesoft.docking.DefaultDockableHolder;
import edu.mit.broad.msigdb_browser.genome.Conf;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.genome.swing.SystemConsole;
import edu.mit.broad.msigdb_browser.xbench.actions.ShowAppRuntimeHomeDirAction;
import edu.mit.broad.msigdb_browser.xbench.actions.ShowDefaultOutputDirAction;
import edu.mit.broad.msigdb_browser.xbench.actions.XAction;
import edu.mit.broad.msigdb_browser.xbench.actions.ext.BrowserAction;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import edu.mit.broad.msigdb_browser.xbench.core.api.FileManager;
import edu.mit.broad.msigdb_browser.xbench.core.api.FileManagerImpl;
import edu.mit.broad.msigdb_browser.xbench.core.api.VdbManager;
import edu.mit.broad.msigdb_browser.xbench.core.api.WindowManager;
import edu.mit.broad.msigdb_browser.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import xapps.browser.MSigDBViewerContainer;
import xapps.browser.api.frameworks.fiji.StatusBarAppender;
import xapps.browser.api.frameworks.fiji.WindowManagerImplJideTabbedPane;
import xapps.browser.gsea.ContactAction;
import xapps.browser.gsea.GseaHelpAction;
import xapps.browser.gsea.GseaWebResources;
import xapps.browser.gsea.VdbManagerForGsea;

public class GseaFijiTabsApplicationFrame
extends DefaultDockableHolder
implements Application.Handler {
    private static final Properties buildProps = JarResources.getBuildInfo();
    public static final String RPT_CACHE_BUILD_DATE = "April4_2006_build";
    private static String USER_VISIBLE_FRAME_TITLE;
    private static final Image ICON;
    private static final List<Image> FRAME_ICONS;
    public static final String PROFILE_NAME = "gsea_browser";
    private StatusBarAppender fStatusBar;
    private GseaFijiTabsApplicationFrame fFrame = this;
    private WindowAdapter fWindowListener;
    private MyWindowManagerImplJideTabbedPane fWindowManager;
    private static final VdbManager fVdbmanager;
    private FileManager fFileManager;

    public GseaFijiTabsApplicationFrame() {
        super(USER_VISIBLE_FRAME_TITLE);
        this.fFrame.setVisible(false);
        this.fFrame.setDefaultCloseOperation(0);
        this.fFrame.setIconImages(FRAME_ICONS);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GseaFijiTabsApplicationFrame.this.exitApplication(e);
            }
        };
        this.fFrame.addWindowListener(this.fWindowListener);
        this.fFrame.getDockingManager().setProfileKey(PROFILE_NAME);
        this.fFrame.getDockingManager().setOutlineMode(0);
        this.fFrame.getDockingManager().beginLoadLayoutData();
        this.fFrame.getDockingManager().setInitSplitPriority(1);
        this.fWindowManager = new MyWindowManagerImplJideTabbedPane();
        this.fStatusBar = SystemConsole.createStatusBarAppender("StatusBar");
        Application.registerHandler(this);
        this.fFrame.setJMenuBar(this.createMenuBar());
        this.jbInit();
    }

    public void makeVisible(boolean bring2front) {
        this.fFrame.getDockingManager().loadLayoutData();
        this.fFrame.getDockingManager().getWorkspace().setAcceptDockableFrame(false);
        if (bring2front) {
            this.fFrame.toFront();
        }
    }

    public void backgroundInit() {
        try {
            Application.getFileManager().getFileChooser();
            Application.getFileManager().getDirChooser("test");
        }
        catch (Throwable t) {
            System.out.println("Error background initing: " + t);
        }
        System.out.println("Done background init");
    }

    private void jbInit() {
        this.fFrame.getContentPane().setLayout(new BorderLayout());
        this.fFrame.getContentPane().add(new MSigDBViewerContainer());
        this.fFrame.getContentPane().add((Component)this.fStatusBar.getAsComponent(), "Last");
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            menuBar.add(this.createJMenu("File", new Object[]{new MyExitAction()}));
        }
        menuBar.add(this.createJMenu("Help", new Object[]{new GseaHelpAction("GSEA web site", "Open the GSEA website in a web browser", GseaWebResources.getGseaBaseURL()), new GseaHelpAction(), new BrowserAction("GSEA & MSigDB License Terms", "GSEA & MSigDB License Terms", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"), null, new ShowAppRuntimeHomeDirAction("Show GSEA home folder"), new ShowDefaultOutputDirAction("Show GSEA output folder (default location)"), null, new ContactAction(), null, this.formatBuildInfoForHelp(), this.formatBuildTimestampForHelp()}));
        return menuBar;
    }

    private String formatBuildInfoForHelp() {
        String buildVer = buildProps.getProperty("build.version");
        String buildNum = buildProps.getProperty("build.number");
        String buildInfo = "MSigDB XML Browser v" + buildVer + " [build: " + buildNum + "]";
        return buildInfo;
    }

    private String formatBuildTimestampForHelp() {
        String buildTS = buildProps.getProperty("build.timestamp");
        if (StringUtils.isBlank((CharSequence)buildTS)) {
            return null;
        }
        return "Built: " + buildTS;
    }

    private JMenu createJMenu(String name, Object[] objs) {
        JMenu menu = new JMenu(name, true);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) {
                menu.addSeparator();
                continue;
            }
            if (objs[i] instanceof JMenuItem) {
                menu.add((JMenuItem)objs[i]);
                continue;
            }
            if (objs[i] instanceof String) {
                menu.add(objs[i].toString());
                continue;
            }
            menu.add(new JMenuItem((Action)objs[i]));
        }
        return menu;
    }

    private void exitApplication(WindowEvent e_opt) {
        boolean res;
        boolean ask = XPreferencesFactory.kAskBeforeAppShutdown.getBoolean();
        if (ask && !(res = this.getWindowManager().showConfirm("Exit the application?"))) {
            return;
        }
        this.fFrame.removeWindowListener(this.fWindowListener);
        this.fWindowListener = null;
        if (this.fFrame.getDockingManager() != null) {
            this.fFrame.getDockingManager().saveLayoutData();
        }
        this.fFrame.dispose();
        this.fFrame = null;
        if (!Conf.isDebugMode()) {
            Conf.exitSystem(false);
        }
    }

    public String getName() {
        return "GSEA";
    }

    @Override
    public FileManager getFileManager() {
        if (this.fFileManager == null) {
            this.fFileManager = new FileManagerImpl();
        }
        return this.fFileManager;
    }

    @Override
    public VdbManager getVdbManager() {
        return fVdbmanager;
    }

    @Override
    public WindowManager getWindowManager() throws HeadlessException {
        return this.fWindowManager;
    }

    @Override
    public StatusBarAppender getStatusBarAppender() {
        return this.fStatusBar;
    }

    static {
        System.setProperty("GSEA", Boolean.TRUE.toString());
        if (StringUtils.isBlank((CharSequence)buildProps.getProperty("build.version"))) {
            buildProps.setProperty("build.version", "[NO BUILD VERSION FOUND]");
        }
        if (StringUtils.isBlank((CharSequence)buildProps.getProperty("build.number"))) {
            buildProps.setProperty("build.number", "Error loading build.properties!");
        }
        USER_VISIBLE_FRAME_TITLE = "MSigDB XML Browser " + buildProps.getProperty("build.version");
        ICON = JarResources.getImage("icon_64x64.png");
        FRAME_ICONS = Arrays.asList(JarResources.getImage("icon_16x16.png"), JarResources.getImage("icon_16x16@2x.png"), JarResources.getImage("icon_32x32.png"), JarResources.getImage("icon_32x32@2x.png"), JarResources.getImage("icon_128x128.png"), JarResources.getImage("icon_128x128@2x.png"), JarResources.getImage("icon_256x256.png"), JarResources.getImage("icon_256x256@2x.png"), JarResources.getImage("icon_512x512.png"), JarResources.getImage("icon_512x512@2x.png"));
        fVdbmanager = new VdbManagerForGsea(RPT_CACHE_BUILD_DATE);
    }

    class MyExitAction
    extends XAction {
        public MyExitAction() {
            super("ExitAction", "Exit", "Quit the GSEA application");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GseaFijiTabsApplicationFrame.this.exitApplication(null);
        }
    }

    class MyWindowManagerImplJideTabbedPane
    extends WindowManagerImplJideTabbedPane {
        MyWindowManagerImplJideTabbedPane() {
            super((JFrame)((Object)GseaFijiTabsApplicationFrame.this.fFrame));
        }
    }
}

