/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.gsea;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.viewers.AbstractViewer;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import xapps.browser.MGUIUtils;
import xapps.browser.VToolsForMSigDBBrowser;

public class GeneSetAnnotationWithOverlaps {
    private GeneSet query;
    private One[] fOnes;
    private String[] fAllGeneSetNames;
    private GeneSetAnnotationWithOverlaps fInstance = this;
    private static String[] COL_NAMES = new String[]{"NAME", "OVERLAP", "JACCARD", "# GENES", "DESCRIPTION", "COLLECTION"};

    public GeneSetAnnotationWithOverlaps(GeneSet query, One[] ones) {
        this.query = query;
        this.fOnes = ones;
    }

    public TableModel createModel() {
        return new Model();
    }

    public Viewer createViewer(MSigDB msigdb) {
        return new Viewer(this.query.getName(true), msigdb);
    }

    public String[] getAllDisplayedGeneSetNames() {
        if (this.fAllGeneSetNames == null) {
            this.fAllGeneSetNames = new String[this.fOnes.length];
            for (int i = 0; i < this.fOnes.length; ++i) {
                this.fAllGeneSetNames[i] = this.fOnes[i].getAnn().getGeneSet(true).getName(true);
            }
        }
        return this.fAllGeneSetNames;
    }

    class MyViewerHook
    implements VToolsForMSigDBBrowser.ViewerHook {
        private MSigDB msigdb;
        private SortableTable table;

        MyViewerHook(MSigDB msigdb, SortableTable table) {
            this.msigdb = msigdb;
            this.table = table;
        }

        @Override
        public String[] getSelectedGeneSetNames() {
            int[] rows = this.table.getSelectedRows();
            String[] names = new String[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = this.table.getModel().getValueAt(rows[i], 1).toString();
            }
            return names;
        }

        @Override
        public int getNumSelectedRows() {
            return this.table.getSelectedRowCount();
        }

        @Override
        public MSigDB getMSigDB() {
            return this.msigdb;
        }

        @Override
        public String[] getAllDisplayedGeneSetNames() {
            return GeneSetAnnotationWithOverlaps.this.fInstance.getAllDisplayedGeneSetNames();
        }
    }

    public static class JaccardTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final DecimalFormat formatter = new DecimalFormat("#.00000");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Double) {
                value = formatter.format((Double)value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class Viewer
    extends AbstractViewer {
        public Viewer(String queryName, MSigDB msigdb) {
            super("Overlaps", null, "Overlaps query: " + queryName);
            this.jbInit(msigdb);
        }

        private void jbInit(MSigDB msigdb) {
            this.setLayout(new BorderLayout());
            TableModel dmodel = GeneSetAnnotationWithOverlaps.this.createModel();
            SortableTable table = Viewer.createTable(dmodel, true, true);
            table.getColumnModel().getColumn(2).setCellRenderer(new JaccardTableCellRenderer());
            table.setAutoResizeMode(0);
            this.setLayout(new BorderLayout());
            JScrollPane sp = new JScrollPane((Component)table);
            this.add((Component)sp, "Center");
            this.add((Component)MGUIUtils.createExportSetsControlPanel(new MyViewerHook(msigdb, table), new MyViewerHook(msigdb, table)), "South");
            this.revalidate();
        }
    }

    class Model
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return GeneSetAnnotationWithOverlaps.this.fOnes.length;
        }

        @Override
        public String getColumnName(int col) {
            return COL_NAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            GeneSetAnnotation ann = GeneSetAnnotationWithOverlaps.this.fOnes[row].getAnn();
            if (col == 0) {
                return ann.getStandardName();
            }
            if (col == 1) {
                return GeneSetAnnotationWithOverlaps.this.fOnes[row].getOverlap();
            }
            if (col == 2) {
                return new Double(GeneSetAnnotationWithOverlaps.this.fOnes[row].getJaccard());
            }
            if (col == 3) {
                return new Integer(ann.getGeneSet(false).getNumMembers());
            }
            if (col == 4) {
                return ann.getDescription().getBrief();
            }
            if (col == 5) {
                return ann.getCategory().getName();
            }
            return "huh";
        }

        public Class getColumnClass(int col) {
            if (col == 1 || col == 3) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public static class One {
        private GeneSetAnnotation gsa;
        private int inter;
        private double jacq;

        public One(GeneSetAnnotation gsa, int inter, int querySize) {
            this.gsa = gsa;
            this.inter = inter;
            int N = querySize + gsa.getGeneSet(false).getNumMembers();
            int K = gsa.getGeneSet(false).getNumMembers();
            int m = querySize;
            this.jacq = (float)inter / (float)(N - inter);
        }

        public int getOverlap() {
            return this.inter;
        }

        public double getJaccard() {
            return this.jacq;
        }

        public GeneSetAnnotation getAnn() {
            return this.gsa;
        }
    }
}

