/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.api.vtools;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import xtools.browser.api.param.Param;

public class ParamSetFormForAFew {
    public static final Color LIGHT_GREEN = Color.decode("#EAFFEA");
    public static final int DEFAULT_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();

    public static JPanel createParamsPanel(Param[] params) {
        StringBuffer colStr = ParamSetFormForAFew._createColStr();
        StringBuffer rowStr = ParamSetFormForAFew._createRowStr(params);
        PanelBuilder builder = ParamSetFormForAFew.createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        int rowcnt = 3;
        for (int i = 0; i < params.length; ++i) {
            GFieldPlusChooser chooser = params[i].getSelectionComponent();
            if (params[i].isFileBased() && chooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)chooser).getTextField().setBackground(LIGHT_GREEN);
            }
            JLabel label = new JLabel(params[i].getHtmlLabel_v3());
            ParamSetFormForAFew.enableToolTips(label, params[i]);
            builder.add((Component)label, cc.xy(1, rowcnt));
            builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
            rowcnt += 2;
        }
        return builder.getPanel();
    }

    public static void enableToolTips(JLabel label, Param param) {
        label.setToolTipText(param.getDesc());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(DEFAULT_INITIAL_DELAY);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }
        });
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("120dlu,      4dlu,        150dlu,   4dlu,  40dlu");
    }

    private static StringBuffer _createRowStr(Param[] params) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 5dlu,");
        for (int i = 0; i < params.length; ++i) {
            rowStr.append("pref, 3dlu");
            if (params.length == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    public static PanelBuilder createPanelBuilder(StringBuffer colStr, StringBuffer rowStr) {
        FormLayout layout = new FormLayout(colStr.toString(), rowStr.toString());
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        return builder;
    }
}

