/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.api.frameworks.fiji;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.ResizeStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.status.TimeStatusBarItem;
import edu.mit.broad.msigdb_browser.genome.Conf;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.viewers.SystemConsoleViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class StatusBarAppender
extends AbstractAppender {
    private StatusBar fJideStatusBar = new StatusBar();
    private LabelStatusBarItem fStatusBarLabelItem;
    private SystemConsoleViewer fSystemConsoleComp = new SystemConsoleViewer();

    public StatusBarAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
        this.fSystemConsoleComp.setBorder(BorderFactory.createTitledBorder("Application messages"));
        this.fJideStatusBar.add((Component)new TimeStatusBarItem(), (Object)"fix");
        this.fStatusBarLabelItem = new LabelStatusBarItem();
        this.fStatusBarLabelItem.setIcon(JarResources.getIcon("expandall.png"));
        this.fStatusBarLabelItem.setToolTipText("Click for application messages (such as # of permutations complete)");
        this.fJideStatusBar.add((Component)this.fStatusBarLabelItem, (Object)"flexible");
        MemoryStatusBarItem gc = new MemoryStatusBarItem();
        gc.setPreferredWidth(75);
        this.fJideStatusBar.add((Component)gc, (Object)"fix");
        ResizeStatusBarItem resize = new ResizeStatusBarItem();
        resize.setPreferredWidth(20);
        resize.setBorder(BorderFactory.createEmptyBorder());
        this.fJideStatusBar.add((Component)resize, (Object)"fix");
        this.fStatusBarLabelItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatusBarAppender.this.showPopup((JComponent)StatusBarAppender.this.fStatusBarLabelItem);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabelItem.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabelItem.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public JComponent getAsComponent() {
        return this.fJideStatusBar;
    }

    private void showPopup(JComponent owner) {
        JidePopup popup = new JidePopup();
        popup.setMovable(true);
        popup.getContentPane().setLayout(new BorderLayout());
        this.fSystemConsoleComp.setPreferredSize(new Dimension(700, 350));
        popup.getContentPane().add(this.fSystemConsoleComp);
        popup.setDefaultFocusComponent((Component)this.fSystemConsoleComp);
        popup.setOwner((Component)owner);
        popup.setResizable(true);
        popup.setMovable(true);
        if (popup.isPopupVisible()) {
            popup.hidePopup();
        } else {
            popup.showPopup();
        }
    }

    public void append(LogEvent event) {
        String txt = new String(this.getLayout().toByteArray(event));
        Level level = event.getLevel();
        if (level == Level.INFO) {
            this.fStatusBarLabelItem.setForeground(Color.BLACK);
            this.fStatusBarLabelItem.setText(txt);
        } else if (level == Level.DEBUG && Conf.isDebugMode()) {
            this.fStatusBarLabelItem.setForeground(Color.DARK_GRAY);
            this.fStatusBarLabelItem.setText(txt);
        } else if (level == Level.WARN) {
            this.fStatusBarLabelItem.setForeground(Color.ORANGE);
            this.fStatusBarLabelItem.setText(txt);
        }
    }
}

