/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.genome.viewers.Viewer;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.msigdb.DeconAccessions;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDBImpl;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import xapps.browser.MSigDBViewer;
import xapps.browser.api.vtools.AbstractVToolWithParams;
import xapps.browser.api.vtools.Hooks;
import xapps.browser.gsea.GeneSetAnnotationWithOverlaps;
import xtools.browser.api.param.ChipChooserMultiParam;
import xtools.browser.api.param.GeneSetMatrixFormatParam;
import xtools.browser.api.param.GeneSetMultiChooserParam;
import xtools.browser.api.param.SelectedOrAllParam;
import xtools.browser.api.param.StringInputParam;

public class VToolsForMSigDBBrowser {
    private static Viewer _openIt(String msg, String tabName, Viewer v, JTabbedPane viewer_window_opt) {
        Application.getWindowManager().showMessage(msg + ". Results are displayed in a new tab");
        if (viewer_window_opt != null) {
            viewer_window_opt.addTab(tabName, (JComponent)((Object)v));
            viewer_window_opt.setSelectedComponent((JComponent)((Object)v));
            return null;
        }
        return v;
    }

    static class MyBaseHook
    implements Hooks.BaseHook {
        private JTextField tfName;
        private String fSaveNameHint;

        MyBaseHook(String save_name_hint_prefix) {
            this.fSaveNameHint = save_name_hint_prefix;
        }

        @Override
        public String getSaveNameHint() {
            return this.fSaveNameHint;
        }

        @Override
        public String getComponentMessage() {
            return null;
        }

        @Override
        public JTextField getTextField() {
            String sn;
            if (this.tfName == null) {
                this.tfName = new JTextField(60);
                this.tfName.setBorder(BorderFactory.createTitledBorder("Enter a short name for the result"));
            }
            if ((sn = this.getSaveNameHint()) != null && sn.length() > 0) {
                this.tfName.setText(sn);
            }
            return this.tfName;
        }

        @Override
        public String getSaveName() {
            if (this.tfName != null) {
                return this.tfName.getText();
            }
            return "na";
        }
    }

    public static interface ViewerHook {
        public String[] getSelectedGeneSetNames();

        public String[] getAllDisplayedGeneSetNames();

        public int getNumSelectedRows();

        public MSigDB getMSigDB();
    }

    public static class SearchByGeneSet
    extends AbstractVToolWithParams {
        private JTabbedPane viewer_window_opt;
        private MSigDB msigdb;
        private GeneSetMultiChooserParam fGeneSetParam;

        public SearchByGeneSet(MSigDB msigdb, JTabbedPane viewer_window_opt) {
            super("Search by gene set", new MyBaseHook("geneset_"));
            this.viewer_window_opt = viewer_window_opt;
            this.msigdb = msigdb;
        }

        public int findInt(Collection set, GeneSet gset) {
            Iterator e = set.iterator();
            int cnt = 0;
            while (e.hasNext()) {
                if (!gset.isMember(e.next().toString())) continue;
                ++cnt;
            }
            return cnt;
        }

        @Override
        public Viewer execute() throws Exception {
            GeneSet gset = this.fGeneSetParam.getGeneSetCombo();
            ArrayList<GeneSetAnnotationWithOverlaps.One> hits = new ArrayList<GeneSetAnnotationWithOverlaps.One>();
            for (int i = 0; i < this.msigdb.getNumGeneSets(); ++i) {
                GeneSetAnnotation gsa = this.msigdb.getGeneSetAnnotation(i);
                FSet query = (FSet)gsa.getGeneSet(false);
                int inter = this.findInt(query.getMembers_quick(), gset);
                if (inter > 0) {
                    hits.add(new GeneSetAnnotationWithOverlaps.One(gsa, inter, gset.getNumMembers()));
                }
                if (i % 250 != 0) continue;
                System.out.println("Done searching " + (i + 1) + " / " + this.msigdb.getNumGeneSets());
            }
            klog.debug((Object)("# of hits: " + hits.size()));
            GeneSetAnnotationWithOverlaps.One[] inters = hits.toArray(new GeneSetAnnotationWithOverlaps.One[hits.size()]);
            GeneSetAnnotationWithOverlaps gso = new GeneSetAnnotationWithOverlaps(gset, inters);
            return VToolsForMSigDBBrowser._openIt("# of hits: " + hits.size(), "Gene set search: " + NamingConventions.removeExtension(gset.getName(true)) + "( " + gset.getNumMembers() + ")", gso.createViewer(this.msigdb), this.viewer_window_opt);
        }

        @Override
        public void declareParams() {
            this.fGeneSetParam = new GeneSetMultiChooserParam("gset", "Gene set (ids must be symbols)", "Gene set");
            this.fParamSet.addParam(this.fGeneSetParam);
        }

        @Override
        public String getTitle() {
            return "Search for overlapping gene sets";
        }

        @Override
        public String getHelpURL() {
            return JarResources.getHelpURL("xapps_mbrowser_SearchByGeneSet");
        }
    }

    public static class SearchByGene
    extends AbstractVToolWithParams {
        private JTabbedPane viewer_window_opt;
        private MSigDB msigdb;
        private StringInputParam fGeneNameParam;

        public SearchByGene(MSigDB msigdb, JTabbedPane viewer_window_opt) {
            super("Search by gene", new MyBaseHook("gene_"));
            this.viewer_window_opt = viewer_window_opt;
            this.msigdb = msigdb;
        }

        @Override
        public Viewer execute() throws Exception {
            String geneName = this.fGeneNameParam.getString().toUpperCase();
            if (!VdbRuntimeResources.getChip_Seq_Accession().isProbe(geneName)) {
                Application.getWindowManager().showMessage("This is not a valid gene symbol (or known alias): " + geneName);
                return null;
            }
            DeconAccessions.Lookup lp = DeconAccessions.creatLookup(geneName);
            geneName = lp.getSymbol();
            ArrayList<GeneSetAnnotation> hits = new ArrayList<GeneSetAnnotation>();
            for (int i = 0; i < this.msigdb.getNumGeneSets(); ++i) {
                GeneSetAnnotation ga = this.msigdb.getGeneSetAnnotation(i);
                if (!ga.getGeneSet(false).isMember(geneName)) continue;
                hits.add(ga);
            }
            klog.debug((Object)("# of hits: " + hits.size()));
            MSigDBImpl hits_msigdb = new MSigDBImpl(geneName, this.msigdb.getVersion(), this.msigdb.getBuildDate(), hits.toArray(new GeneSetAnnotation[hits.size()]));
            MSigDBViewer widget = new MSigDBViewer(hits_msigdb, false);
            return VToolsForMSigDBBrowser._openIt("# of hits: " + hits.size(), "Gene search: " + geneName, widget, this.viewer_window_opt);
        }

        @Override
        public void declareParams() {
            this.fGeneNameParam = new StringInputParam("gene", "Gene (only symbols, case INsensitive)", "Gene name", null, true);
            this.fParamSet.addParam(this.fGeneNameParam);
        }

        @Override
        public String getTitle() {
            return "Search for gene sets that contain the specified gene";
        }

        @Override
        public String getHelpURL() {
            return JarResources.getHelpURL("xapps_mbrowser_SearchByGene");
        }
    }

    public static class ExportGeneSets
    extends AbstractVToolWithParams {
        private GeneSetMatrixFormatParam fGmFormatParam;
        private ChipChooserMultiParam fChipsTargetParam;
        private ViewerHook hook;
        private SelectedOrAllParam fOnlySelectedFieldsParam;

        public ExportGeneSets(ViewerHook hook) {
            super("Export gene sets", new MyBaseHook("export_"));
            this.hook = hook;
        }

        @Override
        public Viewer execute() throws Exception {
            String[] selNames = this.hook.getSelectedGeneSetNames();
            GeneSetMatrix gm = this.fOnlySelectedFieldsParam.isOnlySelected() && selNames != null && selNames.length > 0 ? this.hook.getMSigDB().createGeneSetMatrix(selNames) : this.hook.getMSigDB().createGeneSetMatrix(this.hook.getAllDisplayedGeneSetNames());
            Chip2ChipMapperSymbol mapper = VdbRuntimeResources.getGeneSymbolMapper(this.fChipsTargetParam.getChipCombo());
            MGeneSetMatrix mgm = mapper.map(gm);
            String newName = this.getSaveName() + "." + mapper.getTargetChip().getName();
            GeneSetMatrix mapped_gm = mgm.getMappedGeneSetMatrix("mapped_").cloneShallow(newName);
            File gmFile = kReport.savePageInvisibly2Cache(mapped_gm, this.fGmFormatParam);
            ParserFactory.read(gmFile, false);
            Application.getWindowManager().showMessage("Saved GeneSetMatrix at: " + gmFile.getPath());
            return null;
        }

        @Override
        public void declareParams() {
            this.fGmFormatParam = new GeneSetMatrixFormatParam();
            this.fChipsTargetParam = new ChipChooserMultiParam("chip_target", "Target chip(s)", "The destination chip - to which orthology/homology mappings are converted to", true);
            this.fParamSet.addParam(this.fChipsTargetParam);
            this.fParamSet.addParam(this.fGmFormatParam);
            this.fOnlySelectedFieldsParam = new SelectedOrAllParam();
            this.fParamSet.addParam(this.fOnlySelectedFieldsParam);
        }

        @Override
        public String getTitle() {
            return "Export selected gene sets";
        }

        @Override
        public String getHelpURL() {
            return JarResources.getHelpURL("xapps_mbrowser_ExportGeneSets");
        }
    }
}

