/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.xbench.prefs;

import edu.mit.broad.msigdb_browser.genome.Conf;
import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.msigdb_browser.genome.utils.SystemUtils;
import edu.mit.broad.msigdb_browser.xbench.actions.XAction;
import edu.mit.broad.msigdb_browser.xbench.core.ApplicationDialog;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import edu.mit.broad.msigdb_browser.xbench.prefs.BooleanPreference;
import edu.mit.broad.msigdb_browser.xbench.prefs.DirPreference;
import edu.mit.broad.msigdb_browser.xbench.prefs.Preference;
import edu.mit.broad.msigdb_browser.xbench.prefs.StringPreference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class XPreferencesFactory {
    private static final Logger klog;
    public static File kAppRuntimeHomeDir;
    public static final BooleanPreference kAskBeforeAppShutdown;
    public static final BooleanPreference kOnlineMode;
    public static final StringPreference kLastToolName;
    public static final DirPreference kDefaultReportsOutputDir;

    public static int getToolTreeWidth() {
        if (Conf.isGseaApp()) {
            return 300;
        }
        return 250;
    }

    public static int getToolTreeWidth_min() {
        if (Conf.isGseaApp()) {
            return 150;
        }
        return 150;
    }

    public static int getToolTreeDivLocation() {
        return 350;
    }

    private XPreferencesFactory() {
    }

    public static Object showSetPreferenceDialog(Preference pref) {
        GFieldPlusChooser field = pref.getSelectionComponent();
        String title = "Set preference: " + pref.getName();
        JPanel input = new JPanel(new BorderLayout());
        JLabel label = new JLabel(pref.getName() + ": ");
        label.setFont(GuiHelper.FONT_DEFAULT_BOLD);
        input.add((Component)label, "West");
        input.add((Component)field.getComponent(), "Center");
        input.add((Component)new JLabel(pref.getDesc()), "South");
        ApplicationDialog dd = new ApplicationDialog(title, input);
        int res = dd.show();
        if (res == 0) {
            try {
                pref.setValue(field.getValue());
            }
            catch (Throwable t) {
                Application.getWindowManager().showError("Could not set preference: " + pref.getName(), t);
                return null;
            }
        }
        return pref.getValue();
    }

    public static JButton createActionButton(Preference pref) {
        return new JButton(new GenericPrefAction(pref));
    }

    static {
        boolean made;
        klog = Logger.getLogger(XPreferencesFactory.class);
        kAppRuntimeHomeDir = new File(SystemUtils.getUserHome(), "gsea_home");
        if (!kAppRuntimeHomeDir.exists() && !(made = kAppRuntimeHomeDir.mkdir())) {
            klog.fatal((Object)("Could not make gsea_home dir at: >" + kAppRuntimeHomeDir + "<"));
        }
        klog.debug((Object)("kAppRuntimeHomeDir: " + kAppRuntimeHomeDir + " " + kAppRuntimeHomeDir.exists()));
        kAskBeforeAppShutdown = new BooleanPreference("Prompt before closing application", "Display a prompt asking for confirmation before shutting down the application", false);
        kOnlineMode = new BooleanPreference("Connect over the Internet", "You can connect to the GSEA website over the Internet. This ensures you always get the current version of gene sets and chip annotations. ", true);
        kLastToolName = new StringPreference("Last Tool Run", "Dont change me", "");
        kDefaultReportsOutputDir = new DirPreference("Browser reports output folder", "Location of the output directory where Browser tool reports are stored", new File(kAppRuntimeHomeDir, "output_browser"));
    }

    static class GenericPrefAction
    extends XAction {
        Preference fPref;

        GenericPrefAction(Preference pref) {
            this(pref, null);
        }

        GenericPrefAction(Preference pref, Icon customIcon) {
            super("GenericPrefAction", pref.getName(), pref.getDesc(), customIcon);
            this.fPref = pref;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            XPreferencesFactory.showSetPreferenceDialog(this.fPref);
        }
    }
}

