/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.xbench;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.charts.XChart;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.DataFormat;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.genepattern.browser.uiutil.FTPFile;

public class RendererFactory2 {
    public static final Icon FTP_FILE_ICON = JarResources.getIcon("FTPFile.gif");

    public static class CommonLookListRenderer
    extends DefaultListCellRenderer {
        private boolean ifFileOnlyShowName;

        public CommonLookListRenderer(boolean ifFileOnlyShowName) {
            this.ifFileOnlyShowName = ifFileOnlyShowName;
        }

        public CommonLookListRenderer() {
            this(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof PersistentObject) {
                PersistentObject pob = (PersistentObject)value;
                if (pob.getQuickInfo() != null) {
                    StringBuffer buf = new StringBuffer("<html><body>").append(pob.getName());
                    buf.append("<font color=#666666> [").append(pob.getQuickInfo()).append(']').append("</font></html></body>");
                    this.setText(buf.toString());
                } else {
                    this.setText(pob.getName());
                }
                File f = null;
                if (ParserFactory.getCache().isCached(pob)) {
                    f = ParserFactory.getCache().getSourceFile(pob);
                }
                if (f != null) {
                    this.setToolTipText(f.getAbsolutePath());
                } else {
                    this.setToolTipText("Unknown origins of file: " + f);
                }
            } else if (value instanceof File) {
                if (this.ifFileOnlyShowName) {
                    this.setText(((File)value).getName());
                } else {
                    this.setText(((File)value).getAbsolutePath());
                }
                this.setIcon(DataFormat.getIcon(value));
                this.setToolTipText(((File)value).getAbsolutePath());
            } else if (value instanceof XChart) {
                this.setText(((XChart)value).getName());
                this.setIcon(XChart.ICON);
            } else if (value instanceof FTPFile) {
                Object s = ((FTPFile)value).getPath();
                String slc = ((String)s).toLowerCase();
                if (slc.indexOf("c1.") != -1) {
                    s = (String)s + " [Positional]";
                } else if (slc.indexOf("c2.") != -1) {
                    s = (String)s + " [Curated]";
                } else if (slc.indexOf("c3.") != -1) {
                    s = (String)s + " [Motif]";
                } else if (slc.indexOf("c4.") != -1) {
                    s = (String)s + " [Computational]";
                }
                this.setText((String)s);
                this.setIcon(FTP_FILE_ICON);
            }
            return this;
        }
    }
}

