/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.msigdb;

import edu.mit.broad.msigdb_browser.genome.objects.AbstractObject;
import edu.mit.broad.msigdb_browser.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import gnu.trove.THashMap;
import java.util.HashSet;
import java.util.Map;

public class MSigDBImpl
extends AbstractObject
implements MSigDB {
    private GeneSetAnnotation[] fGeneSetAnns;
    private String fVersion;
    private String fBuildDate;
    private Map fGeneSetNameGeneSetAnnotationMap;

    public MSigDBImpl(String name, String version, String build_date, GeneSetAnnotation[] gsanns) {
        this.initHere(name, version, build_date, gsanns);
    }

    private void initHere(String name, String version, String build_date, GeneSetAnnotation[] gsanns) {
        super.initialize(name);
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> all = new HashSet<String>();
        this.fGeneSetNameGeneSetAnnotationMap = new THashMap();
        for (int i = 0; i < gsanns.length; ++i) {
            if (all.contains(gsanns[i].getStandardName())) {
                duplicates.add(gsanns[i].getStandardName());
                continue;
            }
            all.add(gsanns[i].getStandardName());
            this.fGeneSetNameGeneSetAnnotationMap.put(gsanns[i].getStandardName(), gsanns[i]);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Duplicate gene set annotations: " + duplicates.size() + "\n" + duplicates);
        }
        this.fGeneSetAnns = gsanns;
        this.fVersion = version;
        this.fBuildDate = build_date;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public String getBuildDate() {
        return this.fBuildDate;
    }

    @Override
    public GeneSetMatrix createGeneSetMatrix(String[] gsetNames) {
        GeneSet[] gsets = new GeneSet[gsetNames.length];
        for (int i = 0; i < gsetNames.length; ++i) {
            gsets[i] = this.getGeneSetAnnotation(gsetNames[i]).getGeneSet(false);
        }
        String name = "gsets_" + gsetNames.length + "_" + this._toName();
        return new DefaultGeneSetMatrix(name, gsets);
    }

    private String _toName() {
        return this.getName() + "." + this.getVersion() + ".symbols";
    }

    @Override
    public GeneSetAnnotation getGeneSetAnnotation(int g) {
        return this.fGeneSetAnns[g];
    }

    @Override
    public GeneSetAnnotation getGeneSetAnnotation(String gsStdName) {
        if (gsStdName == null) {
            throw new IllegalArgumentException("Param gsStdName cannot be null");
        }
        Object obj = this.fGeneSetNameGeneSetAnnotationMap.get(gsStdName);
        if (obj == null && (obj = this.fGeneSetNameGeneSetAnnotationMap.get(gsStdName.toUpperCase())) == null) {
            throw new IllegalArgumentException("No gset ann with std name: " + gsStdName);
        }
        return (GeneSetAnnotation)obj;
    }

    @Override
    public int getNumGeneSets() {
        return this.fGeneSetAnns.length;
    }
}

