/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.msigdb;

import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetCategory;

public class GeneSetCategoryImpl
implements GeneSetCategory {
    public static GeneSetCategory POSITIONAL = new GeneSetCategoryImpl("c1", "Positional", "Position on the Genome");
    public static GeneSetCategory CURATED = new GeneSetCategoryImpl("c2", "Curated", "Curated gene sets");
    public static GeneSetCategory MOTIF = new GeneSetCategoryImpl("c3", "Motif", "Identified by sequence motif analysis");
    public static GeneSetCategory COMPUTED = new GeneSetCategoryImpl("c4", "Computational", "Identified by computational analysis");
    public static GeneSetCategory GO = new GeneSetCategoryImpl("c5", "Gene Ontology", "Gene Ontology sets");
    public static GeneSetCategory PATHWAY = new GeneSetCategoryImpl("c6", "Oncogenic Signatures", "Oncogenic pathway activation modules");
    public static GeneSetCategory IMMUNE = new GeneSetCategoryImpl("c7", "Immunologic Signatures", "Curated immune system gene sets");
    public static GeneSetCategory CELL_TYPE = new GeneSetCategoryImpl("c8", "Cell Type Signatures", "Curated immune system gene sets");
    public static GeneSetCategory HALLMARK = new GeneSetCategoryImpl("H", "Hallmark", "Hallmark gene sets");
    public static GeneSetCategory ARCHIVED = new GeneSetCategoryImpl("ARCHIVED", "Archived", "Retired gene sets referenced by the Hallmarks");
    public static GeneSetCategory[] ALL = new GeneSetCategory[]{POSITIONAL, CURATED, MOTIF, COMPUTED, GO, PATHWAY, IMMUNE, CELL_TYPE, HALLMARK, ARCHIVED};
    private String fCode;
    private String fName;
    private String fDesc;

    public static GeneSetCategory lookup(String codeName) {
        for (int i = 0; i < ALL.length; ++i) {
            if (!ALL[i].getCode().equalsIgnoreCase(codeName)) continue;
            return ALL[i];
        }
        throw new IllegalArgumentException("No such gene set category for code: " + codeName);
    }

    private GeneSetCategoryImpl(String code, String name, String desc) {
        this.fCode = code;
        this.fName = name;
        this.fDesc = desc;
    }

    @Override
    public String getCode() {
        return this.fCode;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getDesc() {
        return this.fDesc;
    }

    public boolean equals(Object obj) {
        GeneSetCategory categ;
        return obj instanceof GeneSetCategory && (categ = (GeneSetCategory)obj).getCode().equals(this.fName);
    }
}

