/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.msigdb;

import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.vdb.Organism;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetCategory;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetCategoryImpl;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetContributor;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetContributorImpl;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetDescription;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetDescriptionImpl;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetExternalLinks;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetExternalLinksImpl;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeneSetAnnotationImpl
implements GeneSetAnnotation {
    private Logger log = Logger.getLogger(GeneSetAnnotationImpl.class);
    private GeneSet fGeneSet_orig;
    private GeneSet fGeneSet_symbolized;
    private Chip fChipxx;
    private String fChip_name;
    private GeneSetContributor fContributor;
    private String fStandardName;
    private String fSystematicName;
    private GeneSetExternalLinks fExtLinks;
    private Organism fOrganism;
    private GeneSetCategory fCategory;
    private GeneSetDescription fDesc;
    private Set fTags;

    private void init(GeneSet gset_orig, GeneSet gset_symbolized_opt, Chip chip_orig_opt, String chip_orig_reqd, GeneSetContributor contributor, String pmid, String geoid, String specificGeneSetListingURL, String extDetailsURL, String standardName, String systematicName, Organism org, GeneSetCategory categ, GeneSetDescription desc, Set tags) {
        if (gset_orig == null) {
            throw new IllegalArgumentException("Param gset_orig cannot be null");
        }
        if (chip_orig_reqd == null) {
            throw new IllegalArgumentException("Param chip_orig_reqd cannot be null");
        }
        this.fGeneSet_orig = gset_orig;
        this.fGeneSet_symbolized = gset_symbolized_opt;
        this.fChip_name = chip_orig_reqd;
        this.fChipxx = chip_orig_opt;
        this.fContributor = contributor;
        this.fExtLinks = new GeneSetExternalLinksImpl(pmid, geoid, specificGeneSetListingURL, extDetailsURL);
        this.fStandardName = standardName;
        this.fSystematicName = systematicName;
        this.fOrganism = org;
        this.fCategory = categ;
        this.fDesc = desc;
        this.fTags = tags != null ? Collections.unmodifiableSet(tags) : Collections.EMPTY_SET;
    }

    public GeneSetAnnotationImpl(GeneSet gset_orig, GeneSet gset_symbolized_opt, String chip_name, String contributor, String pmid, String geoid, String specificGeneSetListingURL, String extDetailsURL, String standardName, String systematicName, String orgName, String categCode, String desc_brief, String desc_full, Set tags) {
        this.init(gset_orig, gset_symbolized_opt, null, chip_name, GeneSetContributorImpl.create(contributor), pmid, geoid, specificGeneSetListingURL, extDetailsURL, standardName, systematicName, Organism.parseOrganism(orgName), GeneSetCategoryImpl.lookup(categCode), new GeneSetDescriptionImpl(desc_brief, desc_full), tags);
    }

    @Override
    public GeneSet getGeneSet(boolean orig) {
        if (orig) {
            return this.fGeneSet_orig;
        }
        if (this.fGeneSet_symbolized != null) {
            return this.fGeneSet_symbolized;
        }
        if (GeneSetAnnotationImpl.isGeneSymbol(this.fGeneSet_orig)) {
            return this.fGeneSet_orig;
        }
        if (this.fGeneSet_symbolized == null) {
            this.fGeneSet_symbolized = this._getChipOriginal().symbolize(this.fGeneSet_orig);
            if (this.fGeneSet_symbolized.getNumMembers() == 0) {
                throw new IllegalStateException("Bad conversion for: " + this.fGeneSet_orig.getName() + " " + this.getChipOriginal_name());
            }
            if (this.fGeneSet_symbolized.getNumMembers() < this.fGeneSet_orig.getNumMembers() / 2) {
                this.log.warn((Object)("POOR conversion for: " + this.fGeneSet_orig.getName() + " orig: " + this.fGeneSet_orig.getNumMembers() + " symbols: " + this.fGeneSet_symbolized.getNumMembers() + " chip: " + this.getChipOriginal_name()));
            }
        }
        return this.fGeneSet_symbolized;
    }

    private static boolean isGeneSymbol(GeneSet gset) {
        boolean isGeneSymbol = false;
        try {
            for (int i = 0; i < gset.getNumMembers() && i <= 2 && !isGeneSymbol; ++i) {
                if (!VdbRuntimeResources.getChip_Gene_Symbol().isProbe(gset.getMember(i))) continue;
                isGeneSymbol = true;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return isGeneSymbol;
    }

    @Override
    public GeneSetContributor getContributor() {
        return this.fContributor;
    }

    @Override
    public GeneSetExternalLinks getExternalLinks() {
        return this.fExtLinks;
    }

    @Override
    public String getStandardName() {
        return this.fStandardName;
    }

    @Override
    public String getLSIDName() {
        return this.fSystematicName;
    }

    private Chip _getChipOriginal() {
        if (this.fChipxx == null) {
            this.fChipxx = VdbRuntimeResources.getChip(this.getChipOriginal_name());
        }
        return this.fChipxx;
    }

    @Override
    public String getChipOriginal_name() {
        return this.fChip_name;
    }

    @Override
    public Organism getOrganism() {
        return this.fOrganism;
    }

    @Override
    public GeneSetCategory getCategory() {
        return this.fCategory;
    }

    @Override
    public GeneSetDescription getDescription() {
        return this.fDesc;
    }

    @Override
    public Set getTags() {
        return this.fTags;
    }

    @Override
    public String[] getTagsArray() {
        return this.getTags().toArray(new String[this.getTags().size()]);
    }
}

