/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.msigdb;

import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;

public class DeconAccessions {
    private DeconAccessions() throws Exception {
    }

    public static Lookup creatLookup(String originalId) throws Exception {
        Gene gene = null;
        if (VdbRuntimeResources.getChip_Gene_Symbol().isProbe(originalId)) {
            gene = VdbRuntimeResources.getChip_Gene_Symbol().getProbe(originalId).getGene();
        } else if (VdbRuntimeResources.getAliasDb().isAlias(originalId)) {
            gene = VdbRuntimeResources.getAliasDb().getHugo(originalId);
        } else if (VdbRuntimeResources.getChip_Seq_Accession().isProbe(originalId)) {
            gene = VdbRuntimeResources.getChip_Seq_Accession().getHugo(originalId);
        }
        return new Lookup(originalId, gene);
    }

    public static class Lookup {
        private String fOriginalId;
        private Gene fMatch;

        Lookup(String original, Gene match) {
            this.fOriginalId = original;
            this.fMatch = match;
        }

        public String getSymbol() {
            if (this.fMatch != null) {
                return this.fMatch.getSymbol();
            }
            return this.fOriginalId;
        }
    }
}

