/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.map;

import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSet;
import edu.mit.broad.msigdb_browser.vdb.map.Mapper;
import edu.mit.broad.msigdb_browser.vdb.map.MappingDbType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class MGeneSetImpl
implements MGeneSet {
    private GeneSet mappedGeneSet;

    protected MGeneSetImpl(GeneSet sourceGeneSet, String sourceChipName, String targetChipName, MappingDbType dbType, Mapper mapper) throws Exception {
        if (sourceGeneSet == null) {
            throw new IllegalArgumentException("Param sourceGeneSet cannot be null");
        }
        if (sourceChipName == null) {
            throw new IllegalArgumentException("Param sourceChipName cannot be null");
        }
        if (targetChipName == null) {
            throw new IllegalArgumentException("Param targetChipName cannot be null");
        }
        if (dbType == null) {
            throw new IllegalArgumentException("Param dbType cannot be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Param mapper cannot be null");
        }
        HashSet<Set> targets = new HashSet<Set>();
        for (int i = 0; i < sourceGeneSet.getNumMembers(); ++i) {
            String sourceProbeName = sourceGeneSet.getMember(i);
            Set target = mapper.map(sourceProbeName);
            if (target == null) continue;
            if (target instanceof String) {
                targets.add(target);
                continue;
            }
            if (target instanceof Set) {
                targets.addAll(target);
                continue;
            }
            throw new IllegalStateException("Unnown mapped object: " + target + " " + target.getClass());
        }
        this.mappedGeneSet = new FSet(sourceGeneSet.getName(), Collections.unmodifiableSet(targets));
    }

    @Override
    public GeneSet getMappedGeneSet() {
        return this.mappedGeneSet;
    }
}

