/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.map;

import edu.mit.broad.msigdb_browser.genome.objects.AbstractObject;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.map.Chip2ChipMapper;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSetMatrixImpl;
import edu.mit.broad.msigdb_browser.vdb.map.MappingDbType;
import edu.mit.broad.msigdb_browser.vdb.map.MappingDbTypes;
import java.util.HashSet;
import java.util.Set;

public class Chip2ChipMapperSymbol
extends AbstractObject
implements Chip2ChipMapper {
    private Chip fSourceChip;
    private Chip fTargetChip;

    public static final String createId(Chip sourceChip, Chip targetChip, MappingDbType db) {
        return sourceChip.getName() + "." + targetChip.getName() + "." + db.getName();
    }

    public Chip2ChipMapperSymbol(Chip sourceChip, Chip targetChip) {
        if (sourceChip == null) {
            throw new IllegalArgumentException("Param sourceChip cannot be null");
        }
        if (targetChip == null) {
            throw new IllegalArgumentException("Param targetChip cannot be null");
        }
        System.out.println("##### source: " + sourceChip.getName() + " target: " + targetChip.getName());
        this.fSourceChip = sourceChip;
        this.fTargetChip = targetChip;
        super.initialize(Chip2ChipMapperSymbol.createId(this.fSourceChip, this.fTargetChip, this.getMappingDbType()));
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public MappingDbType getMappingDbType() {
        return MappingDbTypes.GENE_SYMBOL;
    }

    @Override
    public Chip getTargetChip() {
        return this.fTargetChip;
    }

    @Override
    public Set map(String sourceProbeName) throws Exception {
        String symbol;
        HashSet<String> targetProbes = new HashSet<String>();
        if (this.fTargetChip.isProbe(sourceProbeName)) {
            targetProbes.add(sourceProbeName);
        }
        if ((symbol = this.fSourceChip.getSymbol(sourceProbeName, Chip.OMIT_NULLS)) != null) {
            Set set = this.fTargetChip.getProbeNames(symbol);
            targetProbes.addAll(set);
        }
        return targetProbes;
    }

    @Override
    public MGeneSetMatrix map(GeneSetMatrix sourceGm) throws Exception {
        return new MGeneSetMatrixImpl(sourceGm, this.fSourceChip.getName(), this.fTargetChip.getName(), MappingDbTypes.GENE_SYMBOL, this);
    }
}

