/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.chip;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.vdb.chip.AbstractChip;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.chip.Probe;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileInMemoryChip
extends AbstractChip {
    private Probe[] fProbes;
    private THashMap fSymbolProbeNameSetMap;
    private Map fProbeNameProbeMap;
    private boolean fDeepDataInited = false;
    private Chip[] fMadeFromChips_lazy;

    public FileInMemoryChip(String chipName, String sourcePath) {
        super(chipName, sourcePath);
    }

    public FileInMemoryChip(String chipName, String sourcePath, Probe[] probes) {
        this.initHere(chipName, sourcePath, probes);
        this.fDeepDataInited = true;
    }

    protected FileInMemoryChip(Chip[] chips) throws Exception {
        super(FileInMemoryChip._createComboName(chips), "combo_dummy_source");
        if (chips == null) {
            throw new IllegalArgumentException("Param chips cannot be null");
        }
        for (int i = 0; i < chips.length; ++i) {
            if (chips[i] != null) continue;
            throw new IllegalArgumentException("Param chips cannot be null at index: " + i);
        }
        this.fMadeFromChips_lazy = chips;
    }

    private void initHere(String chipName, String sourcePath, Probe[] probes) {
        if (!this.isInited()) {
            super.initialize(chipName);
        }
        if (!NamingConventions.isURL(sourcePath)) {
            boolean missing = false;
            if (sourcePath == null) {
                missing = true;
            } else if (!new File(sourcePath).exists()) {
                missing = true;
            } else if (!sourcePath.equals("combo_dummy_source")) {
                missing = true;
            }
            if (missing) {
                this.log.warn((Object)("Missing chip file: >" + sourcePath + "<"));
            }
        }
        if (probes == null) {
            throw new IllegalArgumentException("Param probes cannot be null");
        }
        if (chipName == null) {
            throw new IllegalArgumentException("Param chipName cannot be null");
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<String> duplicates = new HashSet<String>();
        this.fProbes = new Probe[probes.length];
        for (int i = 0; i < probes.length; ++i) {
            this.fProbes[i] = probes[i];
            if (names.contains(probes[i].getName())) {
                duplicates.add(probes[i].getName());
            }
            names.add(probes[i].getName());
        }
        if (!duplicates.isEmpty()) {
            this.log.debug((Object)("There were duplicate probes: " + duplicates.size() + "\n" + duplicates + "\n" + this.getName()));
        } else {
            this.log.debug((Object)("There were no duplicates: " + names.size() + " " + this.getName()));
        }
        names.clear();
        duplicates.clear();
        this.fSourcePath = sourcePath;
    }

    private void readDeepData() throws Exception {
        if (this.fDeepDataInited) {
            return;
        }
        if (this.fMadeFromChips_lazy != null) {
            HashSet<Probe> allProbes = new HashSet<Probe>();
            for (int c = 0; c < this.fMadeFromChips_lazy.length; ++c) {
                Probe[] probes = this.fMadeFromChips_lazy[c].getProbes();
                for (int p = 0; p < probes.length; ++p) {
                    Probe probe = probes[p];
                    allProbes.add(probe);
                }
            }
            this.initHere(FileInMemoryChip._createComboName(this.fMadeFromChips_lazy), "combo_dummy_source", allProbes.toArray(new Probe[allProbes.size()]));
            this.fDeepDataInited = true;
            return;
        }
        try {
            FileInMemoryChip chip = (FileInMemoryChip)ParserFactory.readChip(this.fSourcePath, true);
            this.initHere(chip.getName(), this.fSourcePath, chip.fProbes);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception(t);
        }
        finally {
            this.fDeepDataInited = true;
        }
    }

    @Override
    public String getQuickInfo() {
        if (this.fDeepDataInited) {
            return this.fProbes.length + " probes";
        }
        return null;
    }

    @Override
    public int getNumProbes() throws Exception {
        this.readDeepData();
        return this.fProbes.length;
    }

    @Override
    public Probe getProbe(int i) throws Exception {
        this.readDeepData();
        return this.fProbes[i];
    }

    @Override
    public Probe[] getProbes() throws Exception {
        this.readDeepData();
        Probe[] probes = new Probe[this.fProbes.length];
        for (int p = 0; p < this.fProbes.length; ++p) {
            probes[p] = this.fProbes[p];
        }
        return probes;
    }

    protected void initProbeProbeMap() throws Exception {
        if (this.fProbeNameProbeMap == null) {
            this.readDeepData();
            this.fProbeNameProbeMap = new HashMap();
            for (int i = 0; i < this.fProbes.length; ++i) {
                this.fProbeNameProbeMap.put(this.fProbes[i].getName().toUpperCase(), this.fProbes[i]);
            }
        }
    }

    @Override
    public Set getProbeNames() throws Exception {
        this.initProbeProbeMap();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.getNumProbes(); ++i) {
            set.add(this.getProbe(i).getName());
        }
        return set;
    }

    @Override
    public boolean isProbe(String probeName) throws Exception {
        if (probeName == null) {
            return false;
        }
        this.initProbeProbeMap();
        probeName = probeName.toUpperCase();
        return this.fProbeNameProbeMap.containsKey(probeName);
    }

    @Override
    public Probe getProbe(String probeName_orig) throws Exception {
        if (probeName_orig == null) {
            throw new IllegalArgumentException("Param probeName cannot be null");
        }
        this.initProbeProbeMap();
        String probeName = probeName_orig.toUpperCase();
        Object obj = this.fProbeNameProbeMap.get(probeName);
        if (obj == null) {
            throw new IllegalArgumentException("No Probe called: " + probeName_orig + " on this chip (chip name is >" + this.getName() + "<)");
        }
        return (Probe)obj;
    }

    private void initSymbolMap() throws Exception {
        if (this.fSymbolProbeNameSetMap == null) {
            this.readDeepData();
            this.fSymbolProbeNameSetMap = new THashMap();
            for (int i = 0; i < this.fProbes.length; ++i) {
                Gene gene = this.fProbes[i].getGene();
                if (gene == null) continue;
                String symbol = gene.getSymbol();
                HashSet curr = this.fSymbolProbeNameSetMap.get((Object)symbol);
                if (curr == null) {
                    curr = new HashSet();
                }
                ((Set)curr).add(this.fProbes[i].getName());
                this.fSymbolProbeNameSetMap.put((Object)symbol, curr);
            }
        }
    }

    @Override
    public Set getProbeNames(String geneSymbol) throws Exception {
        this.initSymbolMap();
        Object curr = this.fSymbolProbeNameSetMap.get((Object)geneSymbol);
        if (curr == null) {
            return Collections.EMPTY_SET;
        }
        return (Set)curr;
    }

    private static String _createComboName(Chip[] chips) {
        StringBuffer chipName = new StringBuffer();
        for (int c = 0; c < chips.length; ++c) {
            chipName.append(chips[c].getName());
            if (c == chips.length - 1) continue;
            chipName.append('_');
        }
        return chipName.toString();
    }
}

