/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.chip.ChipHelper;
import edu.mit.broad.msigdb_browser.vdb.chip.FileInMemoryChip;
import edu.mit.broad.msigdb_browser.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.msigdb_browser.vdb.meg.AliasDb;
import edu.mit.broad.msigdb_browser.vdb.meg.AliasDbImpl;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class VdbRuntimeResources {
    static Set affy_prefixes_hack = new HashSet();
    private static AliasDb kAliasDb;
    private static WeakHashMap kChipNameChipFileObject;
    private static Chip kAffy_combo_chip;
    private static String FTP_ANNOTATION_BASE;
    private static String fChipLocBase;

    public static AliasDb getAliasDb() throws Exception {
        if (kAliasDb == null) {
            kAliasDb = new AliasDbImpl(VdbRuntimeResources.getChip_Gene_Symbol());
        }
        return kAliasDb;
    }

    public static Chip getChip_Seq_Accession() {
        return VdbRuntimeResources.getChip("SEQ_ACCESSION");
    }

    public static Chip getChip_Gene_Symbol() {
        return VdbRuntimeResources.getChip("GENE_SYMBOL");
    }

    public static boolean isChipGeneSymbol(String chipName) {
        chipName = VdbRuntimeResources._nameOrPath2Name(chipName).toUpperCase();
        return chipName.startsWith("GENE_SYMBOL");
    }

    public static boolean isChipSeqAccession(String chipName) {
        chipName = VdbRuntimeResources._nameOrPath2Name(chipName).toUpperCase();
        return chipName.startsWith("SEQ_ACCESSION");
    }

    public static Chip2ChipMapperSymbol getGeneSymbolMapper(Chip chip) throws Exception {
        return new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), chip);
    }

    public static boolean isPathGeneSymbolChip(String filePath) {
        return StringUtils.equalsIgnoreCase((CharSequence)"GENE_SYMBOL", (CharSequence)FilenameUtils.getBaseName((String)(filePath = VdbRuntimeResources._nameOrPath2Name(filePath)))) && StringUtils.equalsIgnoreCase((CharSequence)"chip", (CharSequence)FilenameUtils.getExtension((String)filePath));
    }

    public static boolean isChipAffy_hacky(String name) {
        name = VdbRuntimeResources._nameOrPath2Name(name);
        name = name.toUpperCase();
        Iterator iterator = affy_prefixes_hack.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString().toUpperCase();
            if (!name.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    public static Chip getChip_Affy() {
        try {
            if (kAffy_combo_chip == null) {
                kAffy_combo_chip = ChipHelper.createComboChip(VdbRuntimeResources.getChips_Affy());
                kAffy_combo_chip.cloneShallow("AFFYMETRIX");
            }
            return kAffy_combo_chip;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Chip[] getChips_Affy() {
        try {
            String[] affy_names = ParseUtils.slurpIntoArray(JarResources.toURL("AffyChipNames.txt"), true);
            return VdbRuntimeResources.getChips(affy_names);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Chip[] getChips(String[] namesOrPaths) throws Exception {
        Chip[] chips = new Chip[namesOrPaths.length];
        for (int i = 0; i < namesOrPaths.length; ++i) {
            chips[i] = VdbRuntimeResources.getChip(namesOrPaths[i]);
        }
        return chips;
    }

    public static Chip getChip(String chipNameOrPath) {
        if (chipNameOrPath == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        File tmpf = new File(chipNameOrPath = chipNameOrPath.trim());
        if (tmpf.exists() && tmpf.isFile() && tmpf.getName().endsWith(".chip")) {
            return new FileInMemoryChip(tmpf.getName(), tmpf.getPath());
        }
        if (chipNameOrPath.toUpperCase().startsWith("AFFY")) {
            return VdbRuntimeResources.getChip_Affy();
        }
        Object obj = kChipNameChipFileObject.get(chipNameOrPath);
        if (obj == null) {
            String chipFile_source = VdbRuntimeResources.getChipFile_source(chipNameOrPath);
            obj = new FileInMemoryChip(chipNameOrPath, chipFile_source);
            kChipNameChipFileObject.put(chipNameOrPath, obj);
        }
        return (Chip)obj;
    }

    private static String _nameOrPath2Name(String nop) {
        if (nop.startsWith("ftp.")) {
            return nop.substring("gseaftp.broadinstitute.org://pub/gsea/annotations/".length());
        }
        if (nop.startsWith("ftp:")) {
            return nop.substring(FTP_ANNOTATION_BASE.length());
        }
        if (nop.startsWith("gseaftp.")) {
            return nop.substring("gseaftp.broadinstitute.org://pub/gsea/annotations/".length());
        }
        if (nop.startsWith("ftp:")) {
            return nop.substring(FTP_ANNOTATION_BASE.length());
        }
        return new File(nop).getName();
    }

    public static String getChipFile_source(String chipNameOrPath) {
        String path;
        if (chipNameOrPath == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        if (((String)chipNameOrPath).startsWith("ftp")) {
            if (((String)chipNameOrPath).startsWith("ftp.")) {
                chipNameOrPath = "ftp://" + (String)chipNameOrPath;
            }
            return chipNameOrPath;
        }
        if (((String)chipNameOrPath).startsWith("gseaftp")) {
            if (((String)chipNameOrPath).startsWith("gseaftp.")) {
                chipNameOrPath = "ftp://" + (String)chipNameOrPath;
            }
            return chipNameOrPath;
        }
        if (((String)(chipNameOrPath = ((String)chipNameOrPath).replace('-', '_'))).equalsIgnoreCase("GeneSymbol")) {
            chipNameOrPath = "GENE_SYMBOL";
        }
        if (((String)chipNameOrPath).equalsIgnoreCase("SeqAccession")) {
            chipNameOrPath = "SEQ_ACCESSION";
        }
        if (!(path = fChipLocBase + (String)chipNameOrPath).endsWith(".chip")) {
            path = path + ".chip";
        }
        return path;
    }

    static {
        affy_prefixes_hack.add("HG");
        affy_prefixes_hack.add("HC");
        affy_prefixes_hack.add("HU");
        affy_prefixes_hack.add("Hu");
        affy_prefixes_hack.add("MG");
        affy_prefixes_hack.add("MOE");
        affy_prefixes_hack.add("Mu");
        affy_prefixes_hack.add("Mouse");
        kChipNameChipFileObject = new WeakHashMap();
        fChipLocBase = FTP_ANNOTATION_BASE = "ftp://gseaftp.broadinstitute.org/pub/gsea/annotations/";
    }
}

