/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.viewers;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.swing.SystemConsole;
import edu.mit.broad.msigdb_browser.genome.viewers.AbstractViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SystemConsoleViewer
extends AbstractViewer {
    public static final String NAME = "SystemConsoleViewer";
    public static final Icon ICON = JarResources.getIcon("Output16.gif");

    public SystemConsoleViewer() {
        super(NAME, ICON, NAME);
        this.init();
    }

    private void init() {
        final SystemConsole comp = new SystemConsole();
        comp.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(comp), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        JButton but = new JButton("Clear All Output");
        panel.add(but);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                comp.setText("");
            }
        });
        JButton bCopy = new JButton("Copy");
        panel.add(bCopy);
        bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(comp.getText());
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.add((Component)panel, "South");
    }

    @Override
    public String getAssociatedTitle() {
        return NAME;
    }
}

