/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.utils;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;

public class SystemUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    private static Boolean kIsLinuxOrUnix;

    public static boolean isLinuxOrUnix() {
        if (kIsLinuxOrUnix == null) {
            String osName = OS_NAME.toLowerCase();
            kIsLinuxOrUnix = osName.indexOf("unix") != -1 || osName.indexOf("linux") != -1 || osName.equalsIgnoreCase("OSF1") ? Boolean.TRUE : Boolean.FALSE;
        }
        return kIsLinuxOrUnix;
    }

    public static boolean isMac() {
        return org.apache.commons.lang3.SystemUtils.IS_OS_MAC_OSX;
    }

    public static String getProperty(String key, boolean caseSensitive) {
        if (caseSensitive) {
            return System.getProperty(key);
        }
        String s = System.getProperty(key);
        if (s == null || s.length() == 0) {
            s = System.getProperty(key.toLowerCase());
        }
        if (s == null || s.length() == 0) {
            s = System.getProperty(key.toUpperCase());
        }
        return s;
    }

    public static String asString() {
        StringBuffer buf = new StringBuffer();
        Properties prop = System.getProperties();
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String obj = it.next().toString();
            String val = prop.getProperty(obj);
            buf.append(obj).append('=').append((Object)val).append('\n');
        }
        return buf.toString();
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getJavaPath() {
        return SystemUtils.getJavaHome() + File.separator + "bin" + File.separator + "java";
    }

    public static String getJavaHome() {
        return System.getProperty("java.home").trim();
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path").trim();
    }

    public static File getPwd() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static boolean isHeadless() {
        return SystemUtils.isPropertyTrue("java.awt.headless");
    }

    public static boolean isPropertyTrue(String prpName) {
        String p = SystemUtils.getProperty(prpName, false);
        return Boolean.valueOf(p);
    }

    public static boolean isPropertyDefined(String prpName) {
        String p = SystemUtils.getProperty(prpName, false);
        return p != null && p.trim().length() != 0;
    }
}

