/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.swing.fields;

import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;
import java.awt.Color;
import java.io.File;
import java.util.StringTokenizer;

public class GFieldUtils {
    public static final Color GOOD_COLOR = Color.blue;
    public static final Color ERROR_COLOR = Color.red;

    public static Color getFileFieldColor(String pathOrPaths) {
        if (pathOrPaths == null) {
            return ERROR_COLOR;
        }
        if (pathOrPaths.startsWith("http") || pathOrPaths.startsWith("ftp") || pathOrPaths.startsWith("gseaftp")) {
            return GOOD_COLOR;
        }
        if ((pathOrPaths = pathOrPaths.trim()).indexOf(44) == -1) {
            return GFieldUtils._getColor(pathOrPaths);
        }
        StringTokenizer tok = new StringTokenizer(pathOrPaths, ",");
        int cnt = tok.countTokens();
        for (int i = 0; i < cnt; ++i) {
            if (GFieldUtils.isGoodPath(tok.nextToken())) continue;
            return ERROR_COLOR;
        }
        return GOOD_COLOR;
    }

    public static Color _getColor(String path) {
        if (GFieldUtils.isGoodPath(path)) {
            return GOOD_COLOR;
        }
        return ERROR_COLOR;
    }

    public static boolean isGoodPath(String pathMaybeWithAux) {
        if (pathMaybeWithAux == null || pathMaybeWithAux.length() == 0) {
            return false;
        }
        if (pathMaybeWithAux.toLowerCase().startsWith("http") || pathMaybeWithAux.toLowerCase().startsWith("www") || pathMaybeWithAux.toLowerCase().startsWith("ftp") || pathMaybeWithAux.toLowerCase().startsWith("gseaftp")) {
            return true;
        }
        File file = AuxUtils.getBaseFileFromFullPath(pathMaybeWithAux);
        return file.exists();
    }
}

