/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.swing;

import edu.mit.broad.msigdb_browser.genome.Constants;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.swing.TextIconPair;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class GuiHelper
implements Constants {
    public static final Icon ICON_ERROR16 = JarResources.getIcon("Error.gif");
    public static final Icon ICON_START16 = JarResources.getIcon("Run16.png");
    public static final Icon ICON_HELP16 = JarResources.getIcon("Help16_v2.gif");
    public static final Icon ICON_ELLIPSIS = JarResources.getIcon("Ellipsis.png");
    public static final Dimension DIMENSION_STANDARD_WINDOW = new Dimension(500, 500);
    public static final Font FONT_DEFAULT_BOLD = new Font("Helvetica", 1, 12);
    public static final Font FONT_DEFAULT = new Font("Helvetica", 0, 12);
    public static final Color COLOR_DARK_BROWN = new Color(128, 64, 64);
    private static final Logger klog = Logger.getLogger(GuiHelper.class);
    private static final Dimension kPlaceholderSize = new Dimension(200, 50);

    private GuiHelper() {
    }

    public static void centerComponent(Component comp) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = comp.getSize();
        comp.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static JPanel createPlaceholderPanel(Dimension prefsize, TextIconPair pair) {
        return GuiHelper._createPanel(prefsize, pair.text, pair.icon);
    }

    public static JPanel createWaitingPlaceholder() {
        return GuiHelper.createPlaceholderPanel(kPlaceholderSize, TextIconPair.WAITING_FOR_TASK);
    }

    private static JPanel _createPanel(Dimension prefsize, String text, Icon icon) {
        JPanel panel = new JPanel();
        panel.setPreferredSize(prefsize);
        JLabel label = new JLabel(text);
        label.setSize(prefsize);
        label.setIcon(icon);
        panel.setLayout(new FlowLayout(1));
        panel.add(label);
        panel.setBackground(Color.white);
        return panel;
    }

    public static class List2 {
        public static void setSelected(Object[] selected_vals, JList jlist, DefaultListModel listModel) {
            if (selected_vals == null) {
                klog.error((Object)"Null arg for selected selected_vals");
                return;
            }
            TIntArrayList indices = new TIntArrayList();
            for (int i = 0; i < selected_vals.length; ++i) {
                int index = listModel.indexOf(selected_vals[i]);
                if (index == -1) continue;
                indices.add(index);
            }
            jlist.setSelectedIndices(indices.toNativeArray());
        }
    }

    public static class Table {
        public static void setColumnSize(int size, int col, JTable table, boolean alsoMax) {
            TableColumn column = table.getColumnModel().getColumn(col);
            column.setMinWidth(0);
            if (alsoMax) {
                column.setMaxWidth(size);
            }
            column.setPreferredWidth(size);
        }
    }
}

