/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.reports.api;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.parsers.DataFormat;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.genome.reports.api.Report;
import edu.mit.broad.msigdb_browser.genome.reports.api.ToolComments;
import edu.mit.broad.msigdb_browser.genome.reports.pages.FileWrapperPage;
import edu.mit.broad.msigdb_browser.genome.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import xtools.browser.api.Tool;
import xtools.browser.api.param.GeneSetMatrixFormatParam;

public class ToolReport
implements Report {
    private transient Logger log = Logger.getLogger(this.getClass());
    private static transient Logger klog = Logger.getLogger(ToolReport.class);
    private Tool fTool_opt;
    private Class fProducerClass;
    private File fReportDir;
    private ToolComments fToolComments;
    private final long fTimestamp = System.currentTimeMillis();
    private int fNumPagesAdded;
    private String fReportName;
    private List fErrors;
    private Pages fPages;
    private File fHtmlIndexPageFile;

    public ToolReport(File useThisRptDir) throws IllegalArgumentException {
        if (!useThisRptDir.exists()) {
            throw new IllegalArgumentException("Report dir does not exists!!: " + useThisRptDir.getAbsolutePath());
        }
        this.fReportDir = useThisRptDir;
        this.fToolComments = new ToolComments();
        this.fPages = new Pages();
    }

    @Override
    public String getName() {
        return this.fReportName;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public String getNameEnglish() {
        return null;
    }

    @Override
    public String getQuickInfo() {
        return "" + this.fNumPagesAdded;
    }

    @Override
    public File[] getFilesProduced() {
        List files = this.fPages.getFiles_list();
        if (this.fHtmlIndexPageFile != null && this.fHtmlIndexPageFile.exists() && !files.contains(this.fHtmlIndexPageFile)) {
            files.add(this.fHtmlIndexPageFile);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public void addComment(String comment) {
        this.fToolComments.add(comment);
    }

    public void addError(String msg, Throwable t) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(t);
        this.log.error((Object)msg, t);
    }

    @Override
    public Properties getParametersUsed() {
        if (this.fTool_opt != null) {
            return this.fTool_opt.getParamSet().toProperties();
        }
        throw new IllegalStateException("Tool not cached: " + this.fTool_opt);
    }

    @Override
    public Class getProducer() {
        return this.fProducerClass;
    }

    public File savePageInvisibly2Cache(GeneSetMatrix gm, GeneSetMatrixFormatParam gmf) {
        File file = this._createFile(gm.getName(), gmf.getDataFormat().getExtension());
        try {
            if (gmf.getDataFormat() == DataFormat.GMT_FORMAT) {
                ParserFactory.saveGmt(gm, file, false);
            } else if (gmf.getDataFormat() == DataFormat.GMX_FORMAT) {
                ParserFactory.save(gm, file, false);
            } else {
                this.log.warn((Object)("Unkown gm format: " + gmf.getDataFormat()));
                ParserFactory.save(gm, file, false);
            }
            this._centralAddPage(new FileWrapperPage(file));
        }
        catch (Throwable t) {
            this.addError("Trouble saving pob to reports", t);
        }
        return file;
    }

    private void _centralAddPage(FileWrapperPage page) {
        this._centralAddPage(page, false);
    }

    private void _centralAddPage(FileWrapperPage page, boolean keepTrack) {
        if (page == null) {
            throw new IllegalArgumentException("Param page cannot be null");
        }
        if (keepTrack) {
            this.fPages.add(page);
        }
        ++this.fNumPagesAdded;
    }

    private File _createFile(String fname, String suffix) {
        return ToolReport._createFile(fname, suffix, this.fReportDir);
    }

    private static File _createFile(String fname, String suffix, File inDir) {
        File file = null;
        try {
            boolean made;
            StringBuffer name = fname.endsWith(suffix) ? new StringBuffer(fname) : new StringBuffer(fname).append('.').append(suffix);
            file = ToolReport.createSafeReportFile(name.toString(), inDir);
            if (FileUtils.isLocked(file)) {
                int max = fname.length();
                if (max > 10) {
                    max = 10;
                }
                name = new StringBuffer(fname.substring(0, max)).append(".WARNING_renamed_on_detecting_lock").append(System.currentTimeMillis()).append('.').append(suffix);
                String name_str = NamingConventions.createSafeFileName(name.toString());
                file = new File(inDir, name_str);
            }
            if (!file.exists() && !(made = file.createNewFile())) {
                throw new IOException("Could not make file: " + file.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            if (file == null) {
                file = ToolReport.createSafeReportFile("tmp_report_error_file." + System.currentTimeMillis() + suffix, inDir);
            }
            StringBuffer err = new StringBuffer("Fatal error making file to save a component of the reports in");
            err.append("\nInstead using a result file: ").append(file.getPath());
            klog.fatal((Object)err, t);
        }
        return file;
    }

    private static File createSafeReportFile(String name, File inDir) {
        return NamingConventions.createSafeFile(inDir, name);
    }

    static class Pages
    implements Serializable {
        private List plist = new ArrayList();
        private List flist = new ArrayList();

        Pages() {
        }

        private void writeObject(ObjectOutputStream out) {
            klog.debug((Object)("Ignoring: " + out));
        }

        private void readObject(ObjectInputStream in) {
            klog.debug((Object)("Ignoring: " + in));
        }

        void add(FileWrapperPage page) {
            this.plist.add(page);
            this.flist.add(page.getFile());
        }

        List getFiles_list() {
            return this.flist;
        }
    }
}

