/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AbstractParser;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserException;
import edu.mit.broad.msigdb_browser.genome.reports.api.Report;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import xtools.browser.api.DefaultReport;

public class ReportParser
extends AbstractParser {
    public ReportParser() {
        super(Report.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        PrintWriter pw = this.startExport(pob, file);
        Report rep = (Report)pob;
        StringBuffer buf = new StringBuffer();
        buf.append("producer_class").append('\t').append(rep.getProducer().getName()).append('\n');
        buf.append("producer_timestamp").append('\t').append(rep.getTimestamp()).append('\n');
        Properties prp = rep.getParametersUsed();
        Enumeration<Object> en = prp.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            String val = prp.getProperty(key);
            buf.append("param").append('\t').append(key).append('\t').append(val).append('\n');
        }
        buf.append('\n');
        File[] files = rep.getFilesProduced();
        for (int f = 0; f < files.length; ++f) {
            buf.append("file").append('\t').append(files[f].getPath()).append('\n');
        }
        pw.print(buf.toString());
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        ArrayList<File> filesList = new ArrayList<File>();
        Properties params = new Properties();
        Class<?> cl = null;
        long ts = 0L;
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings(currLine, "\t", false);
            if (fields.length != 2 && fields.length != 3) {
                throw new ParserException("Bad Report format -- expect 2 or 3, found: " + fields.length + " line: " + currLine);
            }
            if (fields[0].equalsIgnoreCase("producer_class")) {
                if (fields.length != 2) {
                    throw new ParserException(">2 fields for producer_class line: " + currLine);
                }
                cl = Class.forName(fields[1]);
            }
            if (fields[0].equalsIgnoreCase("producer_timestamp")) {
                if (fields.length != 2) {
                    throw new ParserException(">2 fields for producer_timestamp line: " + currLine);
                }
                ts = Long.parseLong(fields[1]);
            }
            if (fields[0].equalsIgnoreCase("file")) {
                if (fields.length != 2) {
                    throw new ParserException(">2 fields for file line: " + currLine);
                }
                filesList.add(new File(fields[1]));
            } else if (fields[0].equalsIgnoreCase("param")) {
                if (fields.length != 3) {
                    throw new ParserException("Insufficient fields for param line: " + currLine);
                }
                params.put(fields[1], fields[2]);
            }
            currLine = this.nextLine(bin);
        }
        bin.close();
        File[] files = filesList.toArray(new File[filesList.size()]);
        DefaultReport report = new DefaultReport(sourcepath, ts, cl, files, params, false);
        return ReportParser.unmodlist(report);
    }
}

