/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.ObjectCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.commons.lang3.ObjectUtils;

public class PobBoxModel
extends DefaultComboBoxModel<PersistentObject> {
    private List<PersistentObject> persistentObjects = new ArrayList<PersistentObject>();
    private Object selected = null;
    private Comparator<PersistentObject> comp;

    @Override
    public void addElement(PersistentObject persistentObject) {
        this.persistentObjects.add(persistentObject);
        int endIndex = this.persistentObjects.size() - 1;
        this.fireIntervalAdded(this, endIndex, endIndex);
        if (this.selected == null && persistentObject != null && this.persistentObjects.size() == 1) {
            this.setSelectedItem(persistentObject);
        }
    }

    @Override
    public void removeElement(Object anObjectToRemove) {
        int index = this.persistentObjects.indexOf(anObjectToRemove);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selected) {
            if (index > 0) {
                this.setSelectedItem(this.getElementAt(index - 1));
            } else if (this.persistentObjects.isEmpty()) {
                this.setSelectedItem(null);
            } else {
                this.setSelectedItem(this.getElementAt(index + 1));
            }
        }
        this.persistentObjects.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeAllElements() {
        if (this.persistentObjects.isEmpty()) {
            return;
        }
        int endIndex = this.persistentObjects.size() - 1;
        this.persistentObjects.clear();
        this.selected = null;
        this.fireIntervalRemoved(this, 0, endIndex);
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object objectToSelect) {
        if (this.selected == null && objectToSelect != null || this.selected != null && !this.selected.equals(objectToSelect)) {
            this.selected = objectToSelect;
            this.fireContentsChanged(ObjectCache.class, -1, -1);
        }
    }

    @Override
    public int getSize() {
        return this.persistentObjects.size();
    }

    @Override
    public int getIndexOf(Object anObject) {
        return this.persistentObjects.indexOf(anObject);
    }

    @Override
    public PersistentObject getElementAt(int index) {
        if (index >= 0 && index < this.persistentObjects.size()) {
            return this.persistentObjects.get(index);
        }
        return null;
    }

    public void sort() {
        if (this.comp == null) {
            this.comp = new PobComparator();
        }
        Collections.sort(this.persistentObjects, this.comp);
    }

    static class PobComparator
    implements Comparator<PersistentObject> {
        PobComparator() {
        }

        @Override
        public int compare(PersistentObject pn1, PersistentObject pn2) {
            String s1 = pn1.getName();
            String s2 = pn2.getName();
            return ObjectUtils.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }
}

