/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.Headers;
import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AbstractParser;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotationImpl;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetExternalLinks;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDBImpl;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MSigDBParser
extends AbstractParser
implements Headers.MSigDB {
    public MSigDBParser() {
        super(MSigDB.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        this.export((MSigDB)pob, file, true);
    }

    public void export(MSigDB msigdb, File file, boolean convertToSymbols) throws Exception {
        PrintWriter pw = this.startExport(msigdb, file);
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("MSIGDB");
        root.addAttribute("NAME", msigdb.getName());
        root.addAttribute("VERSION", msigdb.getVersion());
        root.addAttribute("BUILD_DATE", msigdb.getBuildDate());
        for (int g = 0; g < msigdb.getNumGeneSets(); ++g) {
            GeneSetAnnotation ann = msigdb.getGeneSetAnnotation(g);
            MSigDBParser._addGeneSetElement(root, ann, convertToSymbols);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)pw, format);
        writer.write(document);
        writer.close();
        pw.close();
        this.doneExport();
    }

    public static void setGeneSetAttributes(Element el, GeneSetAnnotation ann, boolean convertToSymbols) {
        el.addAttribute("STANDARD_NAME", ann.getStandardName());
        el.addAttribute("SYSTEMATIC_NAME", ann.getLSIDName());
        el.addAttribute("ORGANISM", ann.getOrganism().toString());
        GeneSetExternalLinks links = ann.getExternalLinks();
        MSigDBParser.addAttribute_safe(el, "PMID", links.getPMID());
        MSigDBParser.addAttribute_safe(el, "GEOID", links.getGeoID());
        MSigDBParser.addAttribute_safe(el, "GENESET_LISTING_URL", links.getSpecificGeneSetListingURL());
        MSigDBParser.addAttribute_safe(el, "EXTERNAL_DETAILS_URL", links.getExtDetailsURL());
        el.addAttribute("CHIP", ann.getChipOriginal_name());
        el.addAttribute("CATEGORY_CODE", ann.getCategory().getCode());
        el.addAttribute("CONTRIBUTOR", ann.getContributor().getName());
        el.addAttribute("DESCRIPTION_BRIEF", ann.getDescription().getBrief());
        el.addAttribute("DESCRIPTION_FULL", ann.getDescription().getFull());
        el.addAttribute("TAGS", MSigDBParser._toString(ann.getTags()));
        el.addAttribute("MEMBERS", MSigDBParser.toString(ann.getGeneSet(true)));
        if (convertToSymbols) {
            el.addAttribute("MEMBERS_SYMBOLIZED", MSigDBParser.toString(ann.getGeneSet(false)));
        }
    }

    private static Element _addGeneSetElement(Element root, GeneSetAnnotation ann, boolean convertToSymbols) {
        Element el = root.addElement("GENESET");
        MSigDBParser.setGeneSetAttributes(el, ann, convertToSymbols);
        return el;
    }

    private static void addAttribute_safe(Element el, String attName, String attValue) {
        if (attValue != null) {
            el.addAttribute(attName, attValue);
        }
    }

    private static String toString(GeneSet gset) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            buf.append(gset.getMember(i));
            if (i == gset.getNumMembers() - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        SAXReader reader = new SAXReader();
        Document document = reader.read(is);
        Element root = document.getRootElement();
        String msigdb_name = root.attribute("NAME").getValue();
        String msigdb_version = root.attribute("VERSION").getValue();
        String msigdb_build_date = root.attribute("BUILD_DATE").getValue();
        ArrayList<GeneSetAnnotation> list = new ArrayList<GeneSetAnnotation>();
        int cnt = 0;
        Iterator i = root.elementIterator("GENESET");
        while (i.hasNext()) {
            Element el = (Element)i.next();
            list.add(this._parseOneGsa(el));
            if (cnt % 500 == 0) {
                System.out.println("read in from gsetann: " + (cnt + 1));
            }
            ++cnt;
        }
        MSigDBImpl db = new MSigDBImpl(msigdb_name, msigdb_version, msigdb_build_date, list.toArray(new GeneSetAnnotation[list.size()]));
        db.addComment(this.fComment.toString());
        this.doneImport();
        return MSigDBParser.unmodlist(db);
    }

    private static String attribute_safe(Element el, String attName) {
        Attribute att = el.attribute(attName);
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    private static String attribute_reqd(Element el, String attName) {
        Attribute att = el.attribute(attName);
        if (att != null) {
            return att.getValue();
        }
        throw new IllegalArgumentException("Expected attribute: >" + attName + "< was not found");
    }

    private GeneSetAnnotation _parseOneGsa(Element el) throws Exception {
        FSet gset = new FSet(el.attribute("STANDARD_NAME").getValue(), MSigDBParser._fromSet(el, "MEMBERS"));
        FSet gset_symbols = new FSet(el.attribute("STANDARD_NAME").getValue(), MSigDBParser._fromSet(el, "MEMBERS_SYMBOLIZED"));
        GeneSetAnnotationImpl gsann = new GeneSetAnnotationImpl(gset, gset_symbols, MSigDBParser.attribute_reqd(el, "CHIP"), MSigDBParser.attribute_reqd(el, "CONTRIBUTOR"), MSigDBParser.attribute_safe(el, "PMID"), MSigDBParser.attribute_safe(el, "GEOID"), MSigDBParser.attribute_safe(el, "GENESET_LISTING_URL"), MSigDBParser.attribute_safe(el, "EXTERNAL_DETAILS_URL"), MSigDBParser.attribute_reqd(el, "STANDARD_NAME"), MSigDBParser.attribute_reqd(el, "SYSTEMATIC_NAME"), MSigDBParser.attribute_reqd(el, "ORGANISM"), MSigDBParser.attribute_reqd(el, "CATEGORY_CODE"), MSigDBParser.attribute_reqd(el, "DESCRIPTION_BRIEF"), MSigDBParser.attribute_safe(el, "DESCRIPTION_FULL"), MSigDBParser._fromSet(el, "TAGS"));
        return gsann;
    }

    private static Set _fromSet(Element el, String attName) {
        Attribute att = el.attribute(attName);
        if (att != null) {
            return ParseUtils.string2stringsSet(att.getValue(), ",", false);
        }
        return null;
    }

    private static String _toString(Set set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            buf.append(key);
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

