/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AbstractParser;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GmtParser
extends AbstractParser {
    public GmtParser() {
        super(GeneSetMatrix.class);
    }

    @Override
    public void export(PersistentObject gmpob, File file) throws Exception {
        PrintWriter pw = this.startExport(gmpob, file);
        GeneSetMatrix gm = (GeneSetMatrix)gmpob;
        for (int i = 0; i < gm.getNumGeneSets(); ++i) {
            GeneSet gset = gm.getGeneSet(i);
            StringBuffer buf = new StringBuffer(gset.getName()).append('\t');
            String ne = gset.getNameEnglish();
            if (this.isNullorNa(ne)) {
                ne = "na";
            }
            buf.append(ne).append('\t');
            for (int f = 0; f < gset.getNumMembers(); ++f) {
                buf.append(gset.getMember(f));
                if (f >= gset.getNumMembers() - 1) continue;
                buf.append('\t');
            }
            buf.append('\n');
            pw.print(buf.toString());
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        int row = 0;
        ArrayList<FSet> gsets = new ArrayList<FSet>();
        while (currLine != null) {
            StringTokenizer tok = new StringTokenizer(currLine, "\t");
            int cnt = tok.countTokens();
            if (cnt <= 1) {
                throw new ParserException("Empty gene line: " + currLine + " at row: " + row);
            }
            String gsetName = tok.nextToken().trim().toUpperCase();
            String gsetname_english = tok.nextToken().trim();
            ArrayList<String> geneNames = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String geneName = tok.nextToken().trim();
                if (this.isNull(geneName)) continue;
                geneNames.add(geneName);
            }
            String fname = sourcepath.concat("#").concat(gsetName);
            FSet gset = new FSet(fname, gsetname_english, geneNames, true);
            gsets.add(gset);
            ++row;
            currLine = this.nextLine(bin);
        }
        bin.close();
        this.doneImport();
        return GmtParser.unmodlist(new DefaultGeneSetMatrix(sourcepath, gsets));
    }
}

