/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AbstractParser;
import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class FSetParser
extends AbstractParser {
    public FSetParser() {
        super(GeneSet.class);
    }

    @Override
    public void export(PersistentObject gsetorgm, File file) throws Exception {
        if (gsetorgm instanceof GeneSetMatrix) {
            GeneSetMatrix gm = (GeneSetMatrix)gsetorgm;
            File baseFile = file.getParentFile();
            for (int i = 0; i < gm.getNumGeneSets(); ++i) {
                String name = AuxUtils.getAuxNameOnlyNoHash(gm.getGeneSet(i).getName());
                this._export(gm.getGeneSet(i), new File(baseFile, name));
            }
        } else {
            this._export((GeneSet)gsetorgm, file);
        }
        this.doneExport();
    }

    private void _export(GeneSet gset, File file) throws Exception {
        PrintWriter pw = this.startExport(gset, file);
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            pw.println(gset.getMember(i));
        }
        pw.close();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        FSet fset = this.parse(sourcepath, new BufferedReader(new InputStreamReader(is)));
        this.doneImport();
        return FSetParser.unmodlist(fset);
    }

    protected FSet parse(String sourcepath, BufferedReader buf) throws IOException {
        String currLine = this.nextLine(buf);
        ArrayList<String> lines = new ArrayList<String>();
        while (currLine != null) {
            lines.add(currLine);
            currLine = this.nextLine(buf);
        }
        buf.close();
        String[] members = lines.toArray(new String[lines.size()]);
        return new FSet(sourcepath, null, members);
    }
}

