/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.objects;

import edu.mit.broad.msigdb_browser.genome.objects.AbstractObject;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;
import edu.mit.broad.msigdb_browser.vdb.chip.Probe;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FSet
extends AbstractObject
implements GeneSet {
    private List fMembers;

    private FSet() {
    }

    public FSet(String name, String nameEnglish, String[] members) {
        this.init(name, nameEnglish, members, true);
    }

    public FSet(String name, String nameEnglish, List members, boolean checkForDuplicates) {
        this.init(name, nameEnglish, members, checkForDuplicates);
    }

    public FSet(String name, List members, boolean checkForDuplicates) {
        this.init(name, null, members, checkForDuplicates);
    }

    public FSet(String name, String[] members) {
        this.init(name, null, members, true);
    }

    public FSet(String name, Set members) {
        this.init(name, null, members, false);
    }

    private void init(String name, String nameEnglish, Collection members, boolean checkForDuplicates) {
        super.initialize(name, nameEnglish);
        if (members == null) {
            throw new NullPointerException("Param members cant be null");
        }
        this.fMembers = new ArrayList();
        int cnt = 0;
        for (Object member : members) {
            String mn;
            ++cnt;
            if (member == null) {
                throw new NullPointerException("Member is null at: " + cnt);
            }
            if (member instanceof Gene) {
                Gene gene = (Gene)member;
                mn = gene.getSymbol();
            } else {
                mn = member instanceof Probe ? ((Probe)member).getName() : member.toString();
            }
            if (checkForDuplicates) {
                if (this.fMembers.contains(mn)) {
                    this.log.warn((Object)("Duplicate GeneSet member: " + mn));
                    continue;
                }
                this.fMembers.add(mn);
                continue;
            }
            this.fMembers.add(mn);
        }
    }

    private void init(String name, String nameEnglish, String[] members, boolean checkForDuplicates) {
        super.initialize(name, nameEnglish);
        if (members == null) {
            throw new NullPointerException("Members param cant be null");
        }
        this.fMembers = new ArrayList();
        for (int i = 0; i < members.length; ++i) {
            if (members[i] == null) {
                throw new NullPointerException("Member is null at: " + i);
            }
            if (checkForDuplicates) {
                if (this.fMembers.contains(members[i])) {
                    this.log.warn((Object)("Duplicate GeneSet member: " + members[i]));
                    continue;
                }
                this.fMembers.add(members[i]);
                continue;
            }
            this.fMembers.add(members[i]);
        }
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumMembers()).append(" members");
        return buf.toString();
    }

    @Override
    public String getName(boolean stripAux) {
        if (stripAux) {
            return AuxUtils.getAuxNameOnlyNoHash(this.getName());
        }
        return this.getName();
    }

    @Override
    public String getMember(int pos) {
        return (String)this.fMembers.get(pos);
    }

    @Override
    public boolean isMember(String name) {
        return this.fMembers.contains(name);
    }

    @Override
    public int getNumMembers() {
        return this.fMembers.size();
    }

    @Override
    public List getMembers() {
        return Collections.unmodifiableList(this.fMembers);
    }

    public List getMembers_quick() {
        return this.fMembers;
    }

    @Override
    public Set getMembersS() {
        return Collections.unmodifiableSet(new HashSet(this.fMembers));
    }

    @Override
    public String[] getMembersArray() {
        return this.fMembers.toArray(new String[this.fMembers.size()]);
    }
}

