/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class FtpResultInputStream
extends InputStream {
    private File file;
    private InputStream inputStream;

    public FtpResultInputStream(File file, boolean gzipCompressed) throws IOException {
        if (file == null) {
            throw new IOException("file cannot be null");
        }
        this.file = file;
        this.inputStream = new BufferedInputStream(new FileInputStream(file));
        if (gzipCompressed) {
            this.inputStream = new GzipCompressorInputStream(this.inputStream);
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

