/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome;

import edu.mit.broad.msigdb_browser.genome.StandardException;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import xapps.browser.gsea.GseaWebResources;

public class JarResources {
    public static Icon ICON_NOT_FOUND;
    public static Icon ICON_UNKNOWN_DATA_FORMAT;
    private static final String PKG_GENOME = "/edu/mit/broad/msigdb_browser/genome/";
    private static final String PKG_RESOURCE = "/edu/mit/broad/msigdb_browser/genome/resources/";
    private static Logger klog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getBuildInfo() {
        Properties properties;
        URL url = JarResources.toURL("build.properties");
        Properties buildProps = new Properties();
        InputStream urlStream = url.openStream();
        try {
            buildProps.load(urlStream);
            properties = buildProps;
        }
        catch (Throwable throwable) {
            try {
                urlStream.close();
                throw throwable;
            }
            catch (Throwable t) {
                klog.error((Object)t);
                return buildProps;
            }
        }
        urlStream.close();
        return properties;
    }

    private JarResources() {
    }

    public static URL toURL(String filename) {
        return JarResources.class.getResource(PKG_RESOURCE + filename);
    }

    public static String getHelpURL(String keyName) {
        keyName = keyName.replace('.', '_');
        return GseaWebResources.getGseaBaseURL() + "/doc/GSEAUserGuideFrame.html?" + keyName;
    }

    public static String getWikiErrorURL(String errName) {
        return GseaWebResources.getGseaBaseURL() + "/wiki/index.php/" + errName;
    }

    public static JButton createHelpButton(String keyName) {
        Action a = JarResources.createHelpAction(keyName);
        if (a != null) {
            return new JButton(a);
        }
        return new JButton("Help broken: " + keyName);
    }

    public static Action createHelpAction(String keyName) {
        Object urle = JarResources.getHelpURL(keyName);
        if (urle == null || ((String)urle).length() == 0) {
            urle = "Help broken for key: " + keyName;
            klog.warn(urle);
        }
        Object url = urle;
        return new AbstractAction("Help", JarResources.getIcon("Help16_v2.gif"), (String)url){
            final /* synthetic */ String val$url;
            {
                this.val$url = string;
                super(arg0, arg1);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URL(this.val$url).toURI());
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError(t);
                }
            }
        };
    }

    public static Action createHelpAction(StandardException se) {
        Object urle = JarResources.getWikiErrorURL("" + se.getErrorCode());
        if (urle == null || ((String)urle).length() == 0) {
            urle = "Help broken for key: " + se.getErrorCode();
            klog.warn(urle);
        }
        final String url = urle;
        return new AbstractAction("Help for error " + se.getErrorCode(), JarResources.getIcon("Help16_v2.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError(t);
                }
            }
        };
    }

    public static Icon getIcon(String name) {
        URL url = null;
        try {
            url = JarResources.toURL(name);
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        catch (Throwable t) {
            klog.error((Object)t);
        }
        klog.warn((Object)("could not find resource: " + name + " url: " + url + " ... using default icon instead."));
        return ICON_NOT_FOUND;
    }

    public static ImageIcon getImageIcon(String name) {
        return (ImageIcon)JarResources.getIcon(name);
    }

    public static Image getImage(String name) {
        return ((ImageIcon)JarResources.getIcon(name)).getImage();
    }

    static {
        klog = Logger.getLogger(JarResources.class);
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                klog.debug((Object)"Loading basic icons ...");
                URL nf_url = JarResources.class.getResource("/edu/mit/broad/msigdb_browser/genome/resources/IconNotFound.gif");
                if (nf_url == null) {
                    System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                    System.err.println("Expected location: /edu/mit/broad/msigdb_browser/genome/resources/IconNotFound.gif");
                    ICON_NOT_FOUND = null;
                    ICON_UNKNOWN_DATA_FORMAT = null;
                } else {
                    Image image = Toolkit.getDefaultToolkit().getImage(nf_url);
                    if (image == null) {
                        System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                        System.err.println("Expected location: resources/IconNotFound.gif");
                    }
                    ICON_NOT_FOUND = new NotFoundIcon(image);
                    URL qu = JarResources.class.getResource("/edu/mit/broad/msigdb_browser/genome/resources/UnknownDataFormat16.gif");
                    if (qu != null) {
                        image = Toolkit.getDefaultToolkit().getImage(qu);
                        ICON_UNKNOWN_DATA_FORMAT = new ImageIcon(image);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Fatal error initializing JarResources " + t.getMessage());
        }
    }

    public static class NotFoundIcon
    extends ImageIcon {
        NotFoundIcon(Image image) {
            super(image);
        }
    }
}

