/*
 * Decompiled with CFR 0.152.
 */
package xtools.browser.api.ui;

import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.xbench.RendererFactory2;
import edu.mit.broad.msigdb_browser.xbench.core.ObjectBindery;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.browser.api.ui.ChooserPanel;
import xtools.browser.api.ui.NamedModel;

public class GeneSetTabbedChooserPanel
extends JTabbedPane
implements ChooserPanel {
    private static final Logger klog = Logger.getLogger(GeneSetTabbedChooserPanel.class);
    private JList jlGeneSet;
    private JTextArea taGenes;
    private NamedModel fModel = new NamedModel("GeneSets(grp)", ObjectBindery.getModel(GeneSet.class));
    private int fSelectionMode = 0;

    public GeneSetTabbedChooserPanel(int selMode) {
        this.jlGeneSet = new JList();
        RendererFactory2.CommonLookListRenderer rend = new RendererFactory2.CommonLookListRenderer();
        this.jlGeneSet.setCellRenderer(rend);
        this.fSelectionMode = selMode;
        this.jlGeneSet.setModel(this.fModel.model);
        this.jlGeneSet.setSelectionMode(selMode);
        this.taGenes = new JTextArea();
        this.taGenes.setText("");
        this.addTab("Text Entry", new JScrollPane(this.taGenes));
        this.addTab(this.fModel.name, new JScrollPane(this.jlGeneSet));
    }

    @Override
    public JComponent getChooser() {
        return this;
    }

    @Override
    public String getTitle() {
        String text = "Select a gene set";
        if (this.fSelectionMode == 2) {
            text = "Select one or more gene set(s)";
        }
        return text;
    }

    @Override
    public Object[] getChoosenObjects() {
        String[] strs;
        String s;
        ArrayList<Object> allValues = new ArrayList<Object>();
        Object[] sels = this.jlGeneSet.getSelectedValues();
        if (sels != null) {
            for (int i = 0; i < sels.length; ++i) {
                if (sels[i] == null) continue;
                allValues.add(sels[i]);
            }
        }
        if ((s = this.taGenes.getText()) != null && (strs = ParseUtils.string2strings(s, "\t\n", false)).length != 0) {
            FSet gset = new FSet("from_text_area_", strs);
            try {
                ParserFactory.save(gset, File.createTempFile(gset.getName(), ".grp"));
            }
            catch (Throwable t) {
                klog.error((Object)t);
            }
            allValues.add(gset);
        }
        return allValues.toArray(new Object[allValues.size()]);
    }

    @Override
    public JList[] getJListsForDoubleClick() {
        return new JList[]{this.jlGeneSet};
    }
}

