/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser.api.vtools;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.StandardDialog;
import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.xbench.actions.ext.BrowserAction;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import edu.mit.broad.msigdb_browser.xbench.core.api.DialogType;
import edu.mit.broad.msigdb_browser.xbench.core.api.VTool;
import edu.mit.broad.msigdb_browser.xbench.project.ProjectLoggers;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingWorker;

public class VToolRunner {
    private ProjectLoggers.MyLoggerLight logger = new ProjectLoggers.MyLoggerLight();

    public void showRunner(final VTool tool, DialogType dt) {
        final StandardDialogJide dialog = new StandardDialogJide(Application.getWindowManager().getRootFrame(), tool, dt);
        dialog.createBannerPanel();
        dialog.createContentPanel();
        dialog.createButtonPanel();
        dialog.bRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            dialog.setEnabled(false);
                            VToolRunner.this.logger.startSpinner(tool.getTitle(), dialog.getRootPane());
                            tool.getRunnable().run();
                            VToolRunner.this.logger.stopSpinner(dialog.getRootPane());
                        }
                        catch (Throwable t) {
                            VToolRunner.this.logger.write("Error: " + t.getMessage());
                            Application.getWindowManager().showError(t);
                        }
                        finally {
                            if (VToolRunner.this.logger != null) {
                                VToolRunner.this.logger.stopSpinner(dialog.getRootPane());
                            }
                            dialog.setDialogResult(0);
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        dialog.bRun.setEnabled(tool.isRequiredAllSet());
        dialog.bCancel.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (dialog != null) {
                    dialog.setDialogResult(-1);
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        dialog.bHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String url = tool.getHelpURL();
                BrowserAction ba = new BrowserAction("Help", "Online documentation for this tool", GuiHelper.ICON_HELP16, url);
                ba.actionPerformed(evt);
            }
        });
        tool.getComponent().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                dialog.checkAllSet();
            }
        });
        dialog.buttonPanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                dialog.checkAllSet();
            }
        });
        tool.getInitFocusedComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                dialog.checkAllSet();
            }
        });
        dialog.setDefaultCancelAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setDialogResult(-1);
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setDefaultAction(dialog.bRun.getAction());
        dialog.getRootPane().setDefaultButton(dialog.bRun);
        dialog.pack();
        dialog.setSize(Application.DEFAULT_MODAL_WIDGET_RUNNER_DIALOG);
        VToolRunner._centerFrame((Window)((Object)dialog));
        dialog.show();
    }

    private static void _centerFrame(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = w.getSize();
        w.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    private static class StandardDialogJide
    extends StandardDialog {
        private JButton bRun;
        private JButton bCancel;
        private JButton bHelp;
        private VTool tool;
        private DialogType dt;
        private ButtonPanel buttonPanel;

        StandardDialogJide(JFrame parent, VTool tool, DialogType dt) throws HeadlessException {
            super((Frame)parent, tool.getTitle());
            this.tool = tool;
            this.dt = dt;
        }

        void checkAllSet() {
            if (this.tool.isRequiredAllSet()) {
                this.bRun.setEnabled(true);
            } else {
                this.bRun.setEnabled(false);
            }
        }

        public JComponent createBannerPanel() {
            return this.dt.createBannerPanel(this.tool.getTitle());
        }

        public JComponent createContentPanel() {
            JComponent comp = this.tool.getComponent();
            this.setInitFocusedComponent(this.tool.getInitFocusedComponent());
            return comp;
        }

        public ButtonPanel createButtonPanel() {
            if (this.buttonPanel == null) {
                this.buttonPanel = new ButtonPanel();
                this.bRun = new JButton(GuiHelper.ICON_START16);
                this.bCancel = new JButton(GuiHelper.ICON_ERROR16);
                this.bHelp = new JButton(GuiHelper.ICON_HELP16);
                this.bHelp.setMnemonic(ButtonResources.getResourceBundle((Locale)Locale.US).getString("Button.help.mnemonic").charAt(0));
                this.buttonPanel.addButton((AbstractButton)this.bRun, (Object)"AFFIRMATIVE");
                this.buttonPanel.addButton((AbstractButton)this.bCancel, (Object)"CANCEL");
                this.buttonPanel.addButton((AbstractButton)this.bHelp, (Object)"HELP");
                this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            return this.buttonPanel;
        }
    }
}

