/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser;

import com.jidesoft.swing.JideTabbedPane;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.io.FtpResultInputStream;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserFactory;
import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.genome.viewers.AbstractViewer;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import edu.mit.broad.msigdb_browser.xbench.actions.ext.BrowserAction;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingWorker;
import xapps.browser.MSigDBViewer;
import xapps.browser.gsea.GseaWebResources;
import xtools.browser.api.param.FileParam;

public class MSigDBViewerContainer
extends AbstractViewer {
    public static final String NAME = "MSigDBBrowser";
    public static final Icon ICON = JarResources.getIcon("icon_16x16.png");
    private JideTabbedPane fTabbedPane;
    private FileParam fFileOrURLParam;
    private MSigDB curr_msigdb;
    private JComponent fFiller;

    public MSigDBViewerContainer() {
        super(NAME, ICON, "MSigDB gene sets browser");
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout(15, 15));
        this.fFileOrURLParam = new FileParam("path", "File path or URL to the MSigDB XML database", true);
        this.fFileOrURLParam.setValue_url(GseaWebResources.getMSigDB_current_xml_fileName());
        JButton bLoad = new JButton("Load database", JarResources.getIcon("Run16.png"));
        bLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MSigDBViewerContainer.this.fFileOrURLParam.isSpecified()) {
                    Application.getWindowManager().showMessage("No file path or URL specified. First enter one and then try loading");
                } else {
                    boolean firstTime = MSigDBViewerContainer.this.curr_msigdb == null;
                    Object fileName = MSigDBViewerContainer.this.fFileOrURLParam.getValue().toString();
                    if (((String)fileName).startsWith("msigdb_v")) {
                        fileName = GseaWebResources.getGseaFTPServerXMLDir() + "/" + (String)fileName;
                    }
                    RetrieveAndParseWorker retrieveAndParseWorker = new RetrieveAndParseWorker((String)fileName, firstTime);
                    retrieveAndParseWorker.execute();
                }
            }
        });
        JButton bLicense = new JButton("MSigDB License", GuiHelper.ICON_HELP16);
        bLicense.addActionListener(new BrowserAction(GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"));
        JPanel buttonPanel = new JPanel(new BorderLayout(10, 5));
        buttonPanel.add((Component)bLicense, "Center");
        buttonPanel.add((Component)bLoad, "West");
        JPanel topPanel = new JPanel(new BorderLayout(10, 10));
        topPanel.setBackground(Color.DARK_GRAY);
        topPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        JLabel label = new JLabel(this.fFileOrURLParam.getHtmlLabel_v2());
        label.setForeground(Color.WHITE);
        topPanel.add((Component)label, "West");
        topPanel.add((Component)this.fFileOrURLParam.getSelectionComponent().getComponent(), "Center");
        topPanel.add((Component)buttonPanel, "East");
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)topPanel, "North");
        this.fTabbedPane = new JideTabbedPane(1);
        this.fTabbedPane.setTabEditingAllowed(true);
        this.fTabbedPane.setShowCloseButton(true);
        this.fTabbedPane.setShowCloseButtonOnTab(true);
        this.fTabbedPane.setShowGripper(true);
        this.fTabbedPane.setShowIconsOnTab(true);
        this.fTabbedPane.setShowTabButtons(true);
        this.fFiller = GuiHelper.createWaitingPlaceholder();
        this.fTabbedPane.addTab("", (Component)this.fFiller);
        this.add((Component)this.fTabbedPane, "Center");
        this.revalidate();
    }

    private static String pathorurl2name(String path) {
        String name;
        if (NamingConventions.isURL(path)) {
            name = path;
            StringTokenizer tok = new StringTokenizer(name, "/");
            while (tok.hasMoreTokens()) {
                name = tok.nextToken();
            }
        } else {
            File file = new File(path);
            name = file.getName();
        }
        return NamingConventions.removeExtension(name);
    }

    class MSigDBParserWorker
    extends SwingWorker<MSigDB, Void> {
        private final InputStream msigDbInputStream;
        private final String fileName;
        private final boolean firstTime;

        public MSigDBParserWorker(InputStream msigDbInputStream, String fileName, boolean firstTime) {
            this.msigDbInputStream = msigDbInputStream;
            this.fileName = fileName;
            this.firstTime = firstTime;
        }

        @Override
        protected MSigDB doInBackground() throws Exception {
            ProgressMonitorInputStream progMonIS = new ProgressMonitorInputStream(Application.getWindowManager().getRootFrame(), "Parsing file " + this.fileName, this.msigDbInputStream);
            return ParserFactory.readMSigDB(this.fileName, progMonIS, true, true);
        }

        @Override
        protected void done() {
            super.done();
            try {
                MSigDBViewerContainer.this.curr_msigdb = (MSigDB)this.get();
                MSigDBViewer widget = new MSigDBViewer(MSigDBViewerContainer.this.curr_msigdb, true, MSigDBViewerContainer.this.fTabbedPane);
                klog.info((Object)"Parsing complete.");
                if (this.firstTime) {
                    MSigDBViewerContainer.this.fTabbedPane.remove((Component)MSigDBViewerContainer.this.fFiller);
                }
                MSigDBViewerContainer.this.fTabbedPane.addTab(MSigDBViewerContainer.pathorurl2name(this.fileName) + " [version=" + MSigDBViewerContainer.this.curr_msigdb.getVersion() + " build=" + MSigDBViewerContainer.this.curr_msigdb.getBuildDate() + "]", (Component)widget);
                MSigDBViewerContainer.this.fTabbedPane.setSelectedComponent((Component)widget);
            }
            catch (Exception e) {
                Application.getWindowManager().showError("Trouble launching Browse MSigDB", e);
            }
            finally {
                File tempFile;
                if (this.msigDbInputStream instanceof FtpResultInputStream && !(tempFile = ((FtpResultInputStream)this.msigDbInputStream).getFile()).delete()) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    class RetrieveAndParseWorker
    extends SwingWorker<InputStream, Void> {
        private final String fileName;
        private final boolean firstTime;

        public RetrieveAndParseWorker(String fileName, boolean firstTime) {
            this.fileName = fileName;
            this.firstTime = firstTime;
        }

        @Override
        protected InputStream doInBackground() throws Exception {
            return ParserFactory.createInputStream(this.fileName);
        }

        @Override
        protected void done() {
            super.done();
            try {
                InputStream msigdbInputStream = (InputStream)this.get();
                MSigDBParserWorker parserWorker = new MSigDBParserWorker(msigdbInputStream, this.fileName, this.firstTime);
                parserWorker.execute();
            }
            catch (Exception e) {
                Application.getWindowManager().showError("Trouble launching Browse MSigDB", e);
            }
        }
    }
}

