/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.QuickFilterPane;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.models.MSigDBModel;
import edu.mit.broad.msigdb_browser.genome.swing.GPopupChecker;
import edu.mit.broad.msigdb_browser.genome.swing.GuiHelper;
import edu.mit.broad.msigdb_browser.genome.viewers.AbstractViewer;
import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import edu.mit.broad.msigdb_browser.xbench.actions.ext.BrowserAction;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import xapps.browser.GeneSetPagePanel;
import xapps.browser.MGUIUtils;
import xapps.browser.VToolsForMSigDBBrowser;
import xapps.browser.gsea.GseaWebResources;

public class MSigDBViewer
extends AbstractViewer {
    public static final String NAME = "MSigDBViewer";
    public static final Icon ICON = JarResources.getIcon("icon_16x16.png");
    private MSigDBViewer fInstance = this;
    private JideTabbedPane fTabbedPane_opt;
    private MSigDB fMSigDB;
    private boolean showDeepSearchOptions;
    private JLabel fStatusLabel;
    private TableModel curr_displayed_table_model;
    private QuickTableFilterField quickFilterTable;
    private JTable sortableTable;
    private MSigDBModel msigDbTableModel;

    public MSigDBViewer(MSigDB msigdb, boolean showDeepSearchOptions) {
        this(msigdb, showDeepSearchOptions, null);
    }

    public MSigDBViewer(MSigDB msigdb, boolean showDeepSearchOptions, JideTabbedPane tp) {
        super(NAME, ICON, "Gene sets browser [MSigDB]");
        this.fMSigDB = msigdb;
        this.showDeepSearchOptions = showDeepSearchOptions;
        this.fTabbedPane_opt = tp;
        this.jbInit();
    }

    public String[] getSelectedGeneSetNames() {
        JTable table = this.getDisplayedTable();
        int[] rows = this.getDisplayedTable().getSelectedRows();
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            names[i] = table.getModel().getValueAt(rows[i], 1).toString();
        }
        return names;
    }

    public String[] getDisplayedGeneSetNames() {
        JTable table = this.getDisplayedTable();
        String[] names = new String[this.getDisplayedTable().getRowCount()];
        for (int i = 0; i < this.getDisplayedTable().getRowCount(); ++i) {
            names[i] = table.getModel().getValueAt(i, 1).toString();
        }
        return names;
    }

    public int getNumSelectedRows() {
        return this.getDisplayedTable().getSelectedRows().length;
    }

    public GeneSetAnnotation getSelectedGeneSetAnnotation() {
        String[] selNames = this.getSelectedGeneSetNames();
        if (selNames.length > 0) {
            return this.fMSigDB.getGeneSetAnnotation(selNames[0]);
        }
        return null;
    }

    private void jbInit() {
        this.setLayout(new BorderLayout(15, 15));
        this.add(this.createViewAndSearchComponent(), "Center");
        this.add((Component)MGUIUtils.createExportSetsControlPanel(new MyViewerHook(), new MyViewerHook()), "South");
        this.revalidate();
    }

    private JPanel createDeepSearchPanel() {
        ButtonPanel bp = new ButtonPanel();
        bp.setBorder((Border)BorderFactory.createTitledBorder("Deep search options"));
        JButton bGeneSetSearch = new JButton("Find sets that overlap with my set ...");
        bp.addButton((AbstractButton)bGeneSetSearch);
        bGeneSetSearch.addActionListener(new VToolsForMSigDBBrowser.SearchByGeneSet(this.fMSigDB, (JTabbedPane)this.fTabbedPane_opt));
        JButton bGeneSearch = new JButton("Find sets that contain this gene ...");
        bp.addButton((AbstractButton)bGeneSearch);
        bGeneSearch.addActionListener(new VToolsForMSigDBBrowser.SearchByGene(this.fMSigDB, (JTabbedPane)this.fTabbedPane_opt));
        return bp;
    }

    private JTable getOrigTable() {
        return this.sortableTable;
    }

    private JTable getDisplayedTable() {
        return this.quickFilterTable.getTable();
    }

    private Component createViewAndSearchComponent() {
        this.msigDbTableModel = new MSigDBModel(this.fMSigDB);
        QuickFilterPane quickFilterPane = new QuickFilterPane((TableModel)new SortableTableModel((TableModel)this.msigDbTableModel), new int[]{4, 5, 6, 7});
        this.quickFilterTable = new QuickTableFilterField(quickFilterPane.getDisplayTableModel(), new int[]{1, 4});
        JPanel quickSearchPanel = new JPanel(new FlowLayout(3));
        quickSearchPanel.add((Component)this.quickFilterTable);
        quickSearchPanel.setBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "", 4, 1));
        JideSplitPane pane = new JideSplitPane(0);
        quickFilterPane.setBorder((Border)BorderFactory.createCompoundBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "QuickFilterPane", 4, 1), BorderFactory.createEmptyBorder(6, 0, 0, 0)));
        pane.addPane((Component)quickFilterPane);
        JPanel tablePanel = new JPanel(new BorderLayout(2, 2));
        tablePanel.setBorder(BorderFactory.createCompoundBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "Filtered result List (right click for options)", 4, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.fStatusLabel = new JLabel(this.quickFilterTable.getDisplayTableModel().getRowCount() + " out of " + this.msigDbTableModel.getRowCount() + " gene sets");
        this.fStatusLabel.setHorizontalAlignment(0);
        this.fStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fStatusLabel.setForeground(GuiHelper.COLOR_DARK_BROWN);
        this.sortableTable = new SortableTable((TableModel)this.quickFilterTable.getDisplayTableModel());
        this.sortableTable.getTableHeader().setPreferredSize(new Dimension(100, 20));
        DefaultTableCellRenderer tcrColumn = new DefaultTableCellRenderer();
        tcrColumn.setHorizontalAlignment(2);
        this.sortableTable.getColumnModel().getColumn(3).setCellRenderer(tcrColumn);
        final MyPopup popup = new MyPopup();
        this.sortableTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                popup.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                popup.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                popup.maybeShowPopup(e);
            }
        });
        ListSelectionModel lsm = this.sortableTable.getSelectionModel();
        lsm.setSelectionMode(2);
        lsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    // empty if block
                }
            }
        });
        this.quickFilterTable.setTable(this.sortableTable);
        JScrollPane scrollPane = new JScrollPane(this.sortableTable, 22, 30);
        this.curr_displayed_table_model = this.msigDbTableModel;
        this.quickFilterTable.getDisplayTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getSource() instanceof FilterableTableModel) {
                    MSigDBViewer.this.curr_displayed_table_model = (TableModel)e.getSource();
                    int count = MSigDBViewer.this.curr_displayed_table_model.getRowCount();
                    MSigDBViewer.this.fStatusLabel.setText(count + " out of " + MSigDBViewer.this.msigDbTableModel.getRowCount() + " gene sets ");
                }
            }
        });
        this.sortableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int sel_count = MSigDBViewer.this.sortableTable.getSelectedRowCount();
                int count = MSigDBViewer.this.curr_displayed_table_model.getRowCount();
                MSigDBViewer.this.fStatusLabel.setText(count + " out of " + MSigDBViewer.this.msigDbTableModel.getRowCount() + " gene sets  [ " + sel_count + " selected ]");
            }
        });
        tablePanel.add((Component)this.fStatusLabel, "First");
        tablePanel.add(scrollPane);
        if (this.showDeepSearchOptions) {
            pane.add((Component)this.createDeepSearchPanel());
        }
        pane.addPane((Component)tablePanel);
        JPanel panel = new JPanel(new BorderLayout(3, 3));
        panel.add((Component)quickSearchPanel, "First");
        panel.add((Component)pane);
        return panel;
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    class MyViewerHook
    implements VToolsForMSigDBBrowser.ViewerHook {
        @Override
        public String[] getSelectedGeneSetNames() {
            return MSigDBViewer.this.fInstance.getSelectedGeneSetNames();
        }

        @Override
        public int getNumSelectedRows() {
            return MSigDBViewer.this.fInstance.getNumSelectedRows();
        }

        @Override
        public MSigDB getMSigDB() {
            return MSigDBViewer.this.fMSigDB;
        }

        @Override
        public String[] getAllDisplayedGeneSetNames() {
            return MSigDBViewer.this.fInstance.getDisplayedGeneSetNames();
        }
    }

    class OpenPubMedIdAction
    extends AbstractAction {
        OpenPubMedIdAction() {
            super("Open Entrez page for this PubMed ID", JarResources.getIcon("ViewPubMedPage.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneSetAnnotation gsa = MSigDBViewer.this.getSelectedGeneSetAnnotation();
            new BrowserAction(GseaWebResources.getPubMedURL(gsa.getExternalLinks().getPMID())).actionPerformed(e);
        }
    }

    class CopyGeneSetNamesAction
    extends AbstractAction {
        CopyGeneSetNamesAction() {
            super("Copy gene set names into the clipboard", JarResources.getIcon("Copy16_b.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] gsetNames = MSigDBViewer.this.getSelectedGeneSetNames();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < gsetNames.length; ++i) {
                buf.append(gsetNames[i]).append('\n');
            }
            StringSelection stsel = new StringSelection(buf.toString());
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(stsel, stsel);
        }
    }

    class OpenGeneSetPageAction
    extends AbstractAction {
        OpenGeneSetPageAction() {
            super("Full GeneSetPages at Broad website", JarResources.getIcon("ViewGeneSetPages.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneSetAnnotation gsa = MSigDBViewer.this.getSelectedGeneSetAnnotation();
            new BrowserAction(GseaWebResources.getGeneSetURL(gsa.getStandardName())).actionPerformed(e);
        }
    }

    class CopyGeneSetMembersIntoClipboardAction
    extends AbstractAction {
        CopyGeneSetMembersIntoClipboardAction() {
            super("Copy gene set members into clipboard", JarResources.getIcon("QuickView.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneSetAnnotation gsa = MSigDBViewer.this.getSelectedGeneSetAnnotation();
            if (gsa == null) {
                return;
            }
            MSigDBViewer.this.log.debug((Object)("setting: " + gsa.getStandardName()));
            String[] names = gsa.getGeneSet(false).getMembersArray();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < names.length; ++i) {
                buf.append(names[i]).append('\n');
            }
            StringSelection stsel = new StringSelection(buf.toString());
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(stsel, stsel);
        }
    }

    class QuickViewAction
    extends AbstractAction {
        GeneSetPagePanel panel;

        QuickViewAction() {
            super("Annotation QuickView", JarResources.getIcon("QuickView.gif"));
            this.panel = new GeneSetPagePanel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneSetAnnotation gsa = MSigDBViewer.this.getSelectedGeneSetAnnotation();
            if (gsa == null) {
                return;
            }
            MSigDBViewer.this.log.debug((Object)("setting: " + gsa.getStandardName()));
            this.panel.setData(gsa);
            JButton but = new JButton(new OpenGeneSetPageAction());
            but.setText("View full GeneSetPage");
            Application.getWindowManager().showMessage("QuickView: " + gsa.getStandardName() + " [" + gsa.getGeneSet(false).getNumMembers() + " genes]", this.panel, new JButton[]{but}, true);
        }
    }

    class MyPopup
    extends GPopupChecker {
        private JPopupMenu fPopup = new JPopupMenu("For the selected set ...");
        private OpenPubMedIdAction pubmedidAction;
        private QuickViewAction quickViewAction;
        private CopyGeneSetMembersIntoClipboardAction copyGeneSetAction;
        private OpenGeneSetPageAction openGeneSetPageAction;

        MyPopup() {
            this.fPopup.setInvoker(MSigDBViewer.this.getOrigTable());
            this.pubmedidAction = new OpenPubMedIdAction();
            this.copyGeneSetAction = new CopyGeneSetMembersIntoClipboardAction();
            this.quickViewAction = new QuickViewAction();
            this.openGeneSetPageAction = new OpenGeneSetPageAction();
            this.fPopup.add(this.quickViewAction);
            this.fPopup.addSeparator();
            this.fPopup.add(this.openGeneSetPageAction);
            this.fPopup.add(this.pubmedidAction);
            this.fPopup.addSeparator();
            this.fPopup.add(this.copyGeneSetAction);
            this.fPopup.add(new CopyGeneSetNamesAction());
        }

        void show(MouseEvent e) {
            if (MSigDBViewer.this.getDisplayedTable().getSelectedRowCount() == 1) {
                GeneSetAnnotation gsa = MSigDBViewer.this.getSelectedGeneSetAnnotation();
                if (gsa == null) {
                    return;
                }
                if (gsa.getExternalLinks() == null || gsa.getExternalLinks().getPMID() == null || gsa.getExternalLinks().getPMID().length() == 0) {
                    this.pubmedidAction.setEnabled(false);
                } else {
                    this.pubmedidAction.setEnabled(true);
                }
            }
            if (MSigDBViewer.this.getDisplayedTable().getSelectedRows().length > 1) {
                this.quickViewAction.setEnabled(false);
                this.openGeneSetPageAction.setEnabled(false);
                this.pubmedidAction.setEnabled(false);
                this.copyGeneSetAction.setEnabled(false);
            } else {
                this.quickViewAction.setEnabled(true);
                this.openGeneSetPageAction.setEnabled(true);
                this.copyGeneSetAction.setEnabled(true);
            }
            this.fPopup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        protected void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() || e.getClickCount() == 2) {
                this.show(e);
            }
        }
    }
}

