/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.browser.uiutil;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferClient;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.genepattern.browser.uiutil.FTPFile;

public class FTPList
extends JList {
    private FileTransferClient ftpClient = new FileTransferClient();
    private String[] fFileNames;

    public FTPList(String host, String username, String password, String dir, Comparator comp_opt) throws IOException, FTPException, IllegalArgumentException {
        this.ftpClient.setRemoteHost(host);
        this.ftpClient.setUserName(username);
        this.ftpClient.setPassword(password);
        this.ftpClient.connect();
        this.ftpClient.getAdvancedFTPSettings().setConnectMode(FTPConnectMode.PASV);
        this.ftpClient.changeDirectory(dir);
        this.fFileNames = this.ftpClient.directoryNameList();
        DefaultListModel<FTPFile> model = new DefaultListModel<FTPFile>();
        if (this.fFileNames != null) {
            if (comp_opt != null) {
                List<String> all = Arrays.asList(this.fFileNames);
                Collections.sort(all, comp_opt);
                this.fFileNames = all.toArray(new String[all.size()]);
            }
            for (String filename : this.fFileNames) {
                if (VdbRuntimeResources.isChipGeneSymbol(filename) || VdbRuntimeResources.isChipSeqAccession(filename)) continue;
                model.addElement(new FTPFile(host, dir, filename));
            }
        }
        this.setModel(model);
    }

    public void quit() throws IOException, FTPException {
        this.ftpClient.disconnect();
    }
}

